/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.render;

import blue.BlueData;
import blue.BlueSystem;
import blue.LiveData;
import blue.ProjectProperties;
import blue.event.PlayModeListener;
import blue.score.ScoreGenerationException;
import blue.services.render.CSDRenderService;
import blue.services.render.CsdRenderResult;
import blue.services.render.CsoundBinding;
import blue.services.render.RealtimeRenderService;
import blue.services.render.RenderTimeManager;
import blue.settings.GeneralSettings;
import blue.settings.ProjectPropertiesUtil;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObjectException;
import blue.ui.core.render.ProcessConsole;
import blue.utility.FileUtilities;
import blue.utility.ScoreUtilities;
import blue.utility.TextUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CommandlineRunner
implements PlayModeListener,
RealtimeRenderService {
    ProcessConsole console = new ProcessConsole();
    RunProxy runProxy;
    ArrayList<PlayModeListener> listeners = new ArrayList();
    private BlueData data = null;
    private boolean shouldStop = false;
    JCheckBox disableMessagesBox = null;
    JPanel errorPanel = null;

    public CommandlineRunner() {
        this.console.addPlayModeListener(this);
    }

    public String toString() {
        return "Commmandline Runner";
    }

    public void addPlayModeListener(PlayModeListener listener) {
        this.listeners.add(listener);
    }

    public void removePlayModeListener(PlayModeListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyPlayModeListeners(int playMode) {
        for (PlayModeListener listener : this.listeners) {
            listener.playModeChanged(playMode);
        }
    }

    public void setData(BlueData data) {
        this.data = data;
    }

    public void render() throws SoundObjectException {
        if (this.data == null) {
            return;
        }
        this.shouldStop = false;
        try {
            String command = ProjectPropertiesUtil.getRealtimeCommandLine((ProjectProperties)this.data.getProjectProperties());
            String globalSco = this.data.getGlobalOrcSco().getGlobalSco();
            globalSco = TextUtilities.stripMultiLineComments((String)globalSco);
            globalSco = TextUtilities.stripSingleLineComments((String)globalSco);
            double startTime = this.data.getRenderStartTime();
            double endTime = this.data.getRenderEndTime();
            CsdRenderResult result = CSDRenderService.getDefault().generateCSD(this.data, startTime, endTime, true, false);
            RenderTimeManager timeManager = (RenderTimeManager)Lookup.getDefault().lookup(RenderTimeManager.class);
            timeManager.setTempoMapper(result.getTempoMapper());
            String csd = result.getCsdText();
            File temp = FileUtilities.createTempTextFile((String)"tempCsd", (String)".csd", (File)BlueSystem.getCurrentProjectDirectory(), (String)csd);
            command = command + " \"" + temp.getAbsolutePath() + "\"";
            this.play(command, BlueSystem.getCurrentProjectDirectory(), this.data.getRenderStartTime());
        }
        catch (SoundObjectException soe) {
            throw soe;
        }
        catch (ScoreGenerationException ex) {
            NotificationDisplayer.getDefault().notify("Error", NotificationDisplayer.Priority.HIGH.getIcon(), BlueSystem.getString((String)"message.generateScore.error") + "\n" + ex.getLocalizedMessage(), null);
            System.err.println("[" + BlueSystem.getString((String)"message.error") + "] " + ex.getLocalizedMessage());
        }
    }

    public void renderForBlueLive() throws SoundObjectException {
        String command;
        CsdRenderResult result = CSDRenderService.getDefault().generateCSDForBlueLive(this.data, false);
        String tempCSD = result.getCsdText();
        File temp = FileUtilities.createTempTextFile((String)"tempCsd", (String)".csd", (File)BlueSystem.getCurrentProjectDirectory(), (String)tempCSD);
        String osName = System.getProperty("os.name");
        LiveData liveData = this.data.getLiveData();
        if (liveData.isCommandLineEnabled()) {
            if (liveData.isCommandLineOverride()) {
                command = liveData.getCommandLine();
            } else {
                command = ProjectPropertiesUtil.getRealtimeCommandLine((ProjectProperties)this.data.getProjectProperties());
                command = command + " -Lstdin ";
                command = command + liveData.getCommandLine();
            }
        } else {
            command = ProjectPropertiesUtil.getRealtimeCommandLine((ProjectProperties)this.data.getProjectProperties());
            command = command + " -Lstdin ";
        }
        command = osName.contains("Windows") ? command + " \"" + temp.getAbsolutePath() + "\"" : command + " " + temp.getAbsolutePath();
        this.play(command, BlueSystem.getCurrentProjectDirectory(), -1.0);
    }

    public void play(String command, File currentWorkingDirectory, double renderStart) {
        this.runProxy = new RunProxy(command, currentWorkingDirectory, renderStart);
        Thread t = new Thread(this.runProxy);
        t.setPriority(10);
        t.start();
    }

    public boolean isRunning() {
        return this.console.isRunning();
    }

    public void stop() {
        this.shouldStop = true;
        this.runProxy.stop();
    }

    public void passToStdin(String text) {
        NoteList nl = null;
        try {
            nl = ScoreUtilities.getNotes((String)text);
        }
        catch (NoteParseException e) {
            e.printStackTrace();
            nl = null;
        }
        if (nl == null) {
            return;
        }
        for (Note note : nl) {
            this.console.passToStdin(note.toString());
        }
    }

    public void addBinding(CsoundBinding binding) {
    }

    public void removeBinding(CsoundBinding binding) {
    }

    public void playModeChanged(int playMode) {
        if (playMode == 0) {
            if (this.console.getLastExitValue() != 0) {
                GeneralSettings generalSettings = GeneralSettings.getInstance();
                if (generalSettings.isCsoundErrorWarningEnabled()) {
                    if (this.errorPanel == null) {
                        this.errorPanel = new JPanel(new BorderLayout());
                        this.errorPanel.add((Component)new JLabel("<html>There was an error in running Csound.<br>Please view the Csound Output Dialog for more information.<br><br></html>"), "Center");
                        this.disableMessagesBox = new JCheckBox("Disable Error Message Dialog");
                        this.errorPanel.add((Component)this.disableMessagesBox, "South");
                    }
                    this.disableMessagesBox.setSelected(false);
                    SwingUtilities.invokeLater(() -> {
                        JOptionPane.showMessageDialog(null, this.errorPanel, "Csound Error", 0);
                        if (this.disableMessagesBox.isSelected()) {
                            generalSettings.setCsoundErrorWarningEnabled(false);
                            generalSettings.save();
                        }
                    });
                }
                this.notifyPlayModeListeners(playMode);
                return;
            }
            if (this.data.isLoopRendering() && !this.shouldStop) {
                try {
                    this.render();
                }
                catch (SoundObjectException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    this.notifyPlayModeListeners(0);
                }
            } else {
                this.notifyPlayModeListeners(playMode);
            }
        } else {
            this.notifyPlayModeListeners(playMode);
        }
    }

    class RunProxy
    implements Runnable {
        String command;
        File currentWorkingDirectory;
        double renderStart = -1.0;

        public RunProxy(String command, File currentWorkingDirectory, double renderStart) {
            this.renderStart = renderStart;
            this.command = command;
            this.currentWorkingDirectory = currentWorkingDirectory;
        }

        @Override
        public void run() {
            try {
                if (this.renderStart >= 0.0) {
                    RenderTimeManager manager = (RenderTimeManager)Lookup.getDefault().lookup(RenderTimeManager.class);
                    manager.initiateRender(this.renderStart);
                    CommandlineRunner.this.console.setRenderTimeManager(manager);
                } else {
                    CommandlineRunner.this.console.setRenderTimeManager(null);
                }
                CommandlineRunner.this.console.execWait(this.command, this.currentWorkingDirectory);
            }
            catch (IOException ioe) {
                CommandlineRunner.this.shouldStop = true;
                this.stop();
                NotificationDisplayer.getDefault().notify("Error", NotificationDisplayer.Priority.HIGH.getIcon(), ioe.getLocalizedMessage(), null);
                System.err.println("[error] - " + ioe.getLocalizedMessage());
            }
        }

        public void stop() {
            if (CommandlineRunner.this.console == null) {
                return;
            }
            CommandlineRunner.this.console.destroy(true);
        }
    }
}

