/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.project;

import blue.BlueData;
import blue.BlueSystem;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.projects.BlueProjectManager;
import blue.services.render.CSDRenderService;
import blue.services.render.CsdRenderResult;
import blue.settings.RealtimeRenderSettings;
import blue.ui.core.render.CommandlineRealtimeRenderServiceFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.WindowManager;

public final class GenerateRealtimeCsdToScreenAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        StatusDisplayer.getDefault().setStatusText(BlueSystem.getString((String)"message.generatingCSD"));
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        try {
            double startTime = data.getRenderStartTime();
            double endTime = data.getRenderEndTime();
            boolean isApi = CommandlineRealtimeRenderServiceFactory.class != RealtimeRenderSettings.getInstance().renderServiceFactory.getClass();
            CsdRenderResult result = CSDRenderService.getDefault().generateCSD(data, startTime, endTime, true, isApi);
            String csd = result.getCsdText();
            InfoDialog.showInformationDialog(WindowManager.getDefault().getMainWindow(), csd, BlueSystem.getString((String)"message.generateScore.csdTest"));
        }
        catch (Exception ex) {
            ExceptionDialog.showExceptionDialog(WindowManager.getDefault().getMainWindow(), ex);
            throw new RuntimeException("CSDRender Failed");
        }
    }
}

