/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.orchestra.blueX7.EnvelopePoint;
import blue.ui.core.orchestra.editor.blueX7.EnvelopeEditor;
import blue.ui.core.orchestra.editor.blueX7.PointListener;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EnvelopeGeneratorPanel
extends JComponent
implements PointListener {
    JLabel[] labels = new JLabel[8];
    EnvelopeEditor env = new EnvelopeEditor();

    public EnvelopeGeneratorPanel(String label, String xLabel, String yLabel) {
        JPanel labelPanel = new JPanel(new GridLayout(8, 2));
        Dimension boxSize = new Dimension(50, 27);
        for (int i = 0; i < 8; i += 2) {
            this.labels[i] = new JLabel();
            this.labels[i].setPreferredSize(boxSize);
            this.labels[i + 1] = new JLabel();
            this.labels[i + 1].setPreferredSize(boxSize);
            JLabel xLabelItem = new JLabel(xLabel + (i / 2 + 1) + ": ");
            xLabelItem.setAlignmentX(1.0f);
            JLabel yLabelItem = new JLabel(yLabel + (i / 2 + 1) + ": ");
            yLabelItem.setAlignmentX(1.0f);
            labelPanel.add(xLabelItem);
            labelPanel.add(this.labels[i]);
            labelPanel.add(yLabelItem);
            labelPanel.add(this.labels[i + 1]);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("[ " + label + " ]"), "North");
        this.add((Component)labelPanel, "East");
        this.add((Component)this.env, "Center");
    }

    @Override
    public void updateLabels() {
        EnvelopePoint[] points = this.env.getPoints();
        for (int i = 0; i < 4; ++i) {
            this.labels[i * 2].setText(Integer.toString(points[i].x));
            this.labels[i * 2 + 1].setText(Integer.toString(points[i].y));
        }
    }

    public void setPoints(EnvelopePoint[] points) {
        this.env.setPoints(points);
        this.updateLabels();
    }

    public static void main(String[] args) {
        EnvelopeGeneratorPanel envelopeGeneratorPanel1 = new EnvelopeGeneratorPanel("Envelope Generator", "R", "L");
        GUI.showComponentAsStandalone((Component)envelopeGeneratorPanel1, (String)"EnvelopeGeneratorPanel Test", (boolean)true);
    }
}

