/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.orchestra.blueX7.EnvelopePoint;
import blue.ui.core.orchestra.editor.blueX7.EnvelopeMouseListener;
import blue.ui.core.orchestra.editor.blueX7.PointListener;
import blue.utility.GUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class EnvelopeEditor
extends JComponent {
    EnvelopePoint[] points;
    PointListener pl;

    public EnvelopeEditor() {
        EnvelopeMouseListener eml = new EnvelopeMouseListener(this);
        this.addMouseListener(eml);
        this.addMouseMotionListener(eml);
        this.setBackground(Color.BLACK);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setOpaque(true);
    }

    public void setPointListener(PointListener pl) {
        this.pl = pl;
    }

    public void setPoints(EnvelopePoint[] points) {
        this.points = points;
    }

    public EnvelopePoint[] getPoints() {
        return this.points;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.points != null) {
            g.setColor(this.getForeground());
            int xMaxWidth = this.getWidth() / 4;
            int yMaxHeight = this.getHeight();
            int runningX = 0;
            int lastY = yMaxHeight;
            for (int i = 0; i < this.points.length; ++i) {
                int targetX = runningX + (int)((float)this.points[i].x / 99.0f * (float)xMaxWidth);
                int targetY = (int)((1.0f - (float)this.points[i].y / 99.0f) * (float)yMaxHeight);
                g.drawLine(runningX, lastY, targetX, targetY);
                g.fillRect(targetX - 3, targetY - 3, 7, 7);
                runningX = targetX;
                lastY = targetY;
            }
        }
    }

    public static void main(String[] args) {
        EnvelopeEditor envelopeEditor1 = new EnvelopeEditor();
        envelopeEditor1.points = new EnvelopePoint[4];
        for (int i = 0; i < envelopeEditor1.points.length; ++i) {
            envelopeEditor1.points[i] = new EnvelopePoint();
            envelopeEditor1.points[i].x = 77;
            envelopeEditor1.points[i].y = (i + 1) * 99 / 4;
        }
        GUI.showComponentAsStandalone((Component)envelopeEditor1, (String)"EnvelopEditor Test", (boolean)true);
    }
}

