/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.BlueSystem;
import blue.mixer.Effect;
import blue.ui.core.mixer.EffectCategory;
import blue.utility.ListUtil;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class EffectsLibrary
implements TreeModel {
    private static EffectsLibrary library = null;
    EffectCategory rootEffectCategory = new EffectCategory();
    transient Vector listeners = new Vector();
    transient Vector changeListeners = new Vector();

    private EffectsLibrary() {
        this.rootEffectCategory.setRoot(true);
        this.rootEffectCategory.setCategoryName("Effects Library");
    }

    public static EffectsLibrary getInstance() {
        if (library == null) {
            String effectLibFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "effectsLibrary.xml";
            File f = new File(effectLibFileName);
            if (f.exists()) {
                boolean error = false;
                try {
                    Document doc = new Document(f);
                    library = EffectsLibrary.loadFromXML(doc.getRoot());
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                    error = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = true;
                }
                if (error) {
                    JOptionPane.showMessageDialog(null, "There was an error loading " + f.getAbsolutePath() + "\nPlease fix this file or remove it and restart blue.", "Error", 0);
                    System.exit(0);
                }
            }
            if (library == null) {
                library = new EffectsLibrary();
                System.out.println("Creating new Effects Library");
            }
        }
        return library;
    }

    public EffectCategory getRootEffectCategory() {
        return this.rootEffectCategory;
    }

    public void setRootEffectCategory(EffectCategory rootEffectCategory) {
        this.rootEffectCategory = rootEffectCategory;
    }

    public void addEffect(EffectCategory parent, Effect effect) {
        this.addEffect(parent, -1, effect);
    }

    public void addEffect(EffectCategory parent, int insertIndex, Effect effect) {
        if (insertIndex < 0 || insertIndex >= parent.getEffects().size()) {
            parent.addEffect(effect);
        } else {
            parent.addEffect(insertIndex, effect);
        }
        int index = this.getIndexOfChild(parent, effect);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{effect};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(effect), childIndices, children);
        this.fireNodesInserted(e);
    }

    private Object[] getPathForObject(Object obj) {
        Vector v = new Vector();
        this.getPathForObject(this.getRootEffectCategory(), obj, v);
        Collections.reverse(v);
        return v.toArray();
    }

    private Object getPathForObject(EffectCategory current, Object obj, Vector v) {
        if (current == obj) {
            return v;
        }
        if (ListUtil.containsByRef((List)current.getEffects(), (Object)obj)) {
            v.add(current);
            return v;
        }
        for (EffectCategory cat : current.getSubCategories()) {
            Object pathObj = this.getPathForObject(cat, obj, v);
            if (pathObj == null) continue;
            v.add(current);
            return v;
        }
        return null;
    }

    public void addCategory(EffectCategory parent, EffectCategory cat) {
        parent.addEffectCategory(cat);
        int index = this.getIndexOfChild(parent, cat);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{cat};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(cat), childIndices, children);
        this.fireNodesInserted(e);
    }

    public void removeEffect(Effect effect) {
        EffectCategory parent = this.findParent(this.rootEffectCategory, effect);
        int index = this.getIndexOfChild(parent, effect);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{effect};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(effect), childIndices, children);
        this.rootEffectCategory.removeEffect(effect);
        this.fireNodesRemoved(e);
    }

    public void removeEffectCategory(EffectCategory cat) {
        EffectCategory parent = this.findParent(this.rootEffectCategory, cat);
        int index = this.getIndexOfChild(parent, cat);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{cat};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(cat), childIndices, children);
        this.rootEffectCategory.removeEffectCategory(cat);
        this.fireNodesRemoved(e);
    }

    public static EffectsLibrary loadFromXML(Element data) throws Exception {
        EffectsLibrary iLibrary = new EffectsLibrary();
        iLibrary.setRootEffectCategory(EffectCategory.loadFromXML(data.getElement("effectCategory")));
        return iLibrary;
    }

    public Element saveAsXML() {
        Element retVal = new Element("effectsLibrary");
        retVal.addElement(this.rootEffectCategory.saveAsXML());
        return retVal;
    }

    public void save() {
        String userInstrFileName = BlueSystem.getUserConfigurationDirectory() + File.separator + "effectsLibrary.xml";
        PrintWriter out = null;
        File f = new File(userInstrFileName);
        if (f.exists()) {
            File backup = new File(userInstrFileName + "~");
            if (backup.exists()) {
                backup.delete();
            }
            f.renameTo(backup);
        }
        try {
            out = new PrintWriter(new FileWriter(userInstrFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            String lib = this.saveAsXML().toString();
            out.print(lib);
            out.flush();
            out.close();
            System.out.println("Saved Effect Library: " + userInstrFileName);
        } else {
            System.err.println("Unable to Save Effect Library: " + userInstrFileName);
        }
        this.fireChangeEvent();
    }

    @Override
    public Object getRoot() {
        return this.getRootEffectCategory();
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof Effect) {
            return 0;
        }
        if (parent instanceof EffectCategory) {
            EffectCategory cat = (EffectCategory)parent;
            return cat.getSubCategories().size() + cat.getEffects().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Effect;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object obj = path.getLastPathComponent();
        if (obj instanceof EffectCategory) {
            ((EffectCategory)obj).setCategoryName(newValue.toString());
        } else if (obj instanceof Effect) {
            ((Effect)obj).setName(newValue.toString());
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        this.fireNodesChanged(e);
    }

    private void fireNodesChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesChanged(e);
        }
    }

    private void fireNodesInserted(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesInserted(e);
        }
    }

    private void fireNodesRemoved(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeNodesRemoved(e);
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeStructureChanged(e);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        EffectCategory category = (EffectCategory)parent;
        if (category == null) {
            return null;
        }
        if (index >= category.getSubCategories().size()) {
            return category.getEffects().get(index - category.getSubCategories().size());
        }
        return category.getSubCategories().get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        EffectCategory category = (EffectCategory)parent;
        if (category == null || child == null) {
            return -1;
        }
        int retVal = ListUtil.indexOfByRef((List)category.getSubCategories(), (Object)child);
        if (retVal >= 0) {
            return retVal;
        }
        retVal = ListUtil.indexOfByRef((List)category.getEffects(), (Object)child);
        if (retVal >= 0) {
            return retVal + category.getSubCategories().size();
        }
        return -1;
    }

    private EffectCategory findParent(EffectCategory cat, Object obj) {
        if (ListUtil.containsByRef((List)cat.getEffects(), (Object)obj) || ListUtil.containsByRef((List)cat.getSubCategories(), (Object)obj)) {
            return cat;
        }
        for (EffectCategory c : cat.getSubCategories()) {
            EffectCategory temp = this.findParent(c, obj);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(evt);
        }
    }

    public void importEffect(Effect effect) {
        ArrayList categories = this.rootEffectCategory.getSubCategories();
        for (EffectCategory cat : categories) {
            if (!cat.getCategoryName().equals("Imported Effects")) continue;
            this.addEffect(cat, effect);
            this.save();
            return;
        }
        EffectCategory cat = new EffectCategory();
        cat.setCategoryName("Imported Effects");
        cat.addEffect(effect);
        this.addCategory(this.rootEffectCategory, cat);
        this.save();
    }
}

