/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.mixer.Effect;
import blue.ui.core.mixer.EffectEditor;
import blue.ui.utilities.SimpleDocumentListener;
import blue.utility.GUI;
import electric.xml.Element;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EffectEditorDialog
extends JDialog
implements WindowSettingsSavable {
    private Effect effect = null;
    EffectEditor effectEditor = new EffectEditor();
    private JPanel centerPanel;
    private JButton closeButton;
    private JLabel jLabel1;
    private JTextField nameText;

    public EffectEditorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.centerPanel.add((Component)this.effectEditor, "Center");
        this.nameText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (EffectEditorDialog.this.effect != null) {
                    EffectEditorDialog.this.effect.setName(EffectEditorDialog.this.nameText.getText());
                }
            }
        });
        GUI.centerOnScreen((Component)this);
        WindowSettingManager.getInstance().registerWindow("EffectEditorDialog", this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameText = new JTextField();
        this.centerPanel = new JPanel();
        this.closeButton = new JButton();
        this.setTitle("Edit Effect");
        this.jLabel1.setText("Name:");
        this.nameText.setText("jTextField1");
        this.centerPanel.setLayout(new BorderLayout());
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EffectEditorDialog.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameText, -1, 425, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(419, Short.MAX_VALUE).addComponent(this.closeButton).addContainerGap()).addComponent(this.centerPanel, -1, 515, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centerPanel, -1, 247, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addContainerGap()));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.hide();
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
        this.nameText.setText(this.effect.getName());
        this.effectEditor.setEffect(this.effect);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> new EffectEditorDialog(null, true).setVisible(true));
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, this);
    }

    @Override
    public Element saveWindowSettings() {
        return WindowSettingManager.getBasicSettings(this);
    }
}

