/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.midi;

import blue.gui.TimedKeyListener;
import blue.midi.MidiInputManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class VirtualKeyboardPanel
extends JComponent {
    private static final int KEY_OFFSET = 21;
    private AtomicBoolean[] keyStates = new AtomicBoolean[88];
    private AtomicBoolean[] changedKeyStates = new AtomicBoolean[88];
    private int[] whiteKeys = new int[7];
    private int lastMidiKey = -1;
    private int octave = 5;
    private int channel = 0;
    private int velocity = 127;
    private MidiInputManager midiEngine = MidiInputManager.getInstance();

    public VirtualKeyboardPanel() {
        this.setFocusable(true);
        for (int i = 0; i < 88; ++i) {
            this.keyStates[i] = new AtomicBoolean(false);
            this.changedKeyStates[i] = new AtomicBoolean(false);
        }
        this.whiteKeys[0] = 0;
        this.whiteKeys[1] = 2;
        this.whiteKeys[2] = 4;
        this.whiteKeys[3] = 5;
        this.whiteKeys[4] = 7;
        this.whiteKeys[5] = 9;
        this.whiteKeys[6] = 11;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (SwingUtilities.isLeftMouseButton(me)) {
                    int key = VirtualKeyboardPanel.this.getMIDIKey(me.getX(), me.getY());
                    VirtualKeyboardPanel.this.lastMidiKey = key;
                    VirtualKeyboardPanel.this.keyStates[key].set(true);
                    try {
                        ShortMessage sme = new ShortMessage();
                        sme.setMessage(144, VirtualKeyboardPanel.this.channel, key + 21, VirtualKeyboardPanel.this.velocity);
                        VirtualKeyboardPanel.this.midiEngine.send((MidiMessage)sme, 0L);
                    }
                    catch (InvalidMidiDataException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    VirtualKeyboardPanel.this.requestFocus();
                    VirtualKeyboardPanel.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (SwingUtilities.isLeftMouseButton(me)) {
                    int key = VirtualKeyboardPanel.this.getMIDIKey(me.getX(), me.getY());
                    if (key > 87) {
                        key = 87;
                    }
                    VirtualKeyboardPanel.this.keyStates[key].set(false);
                    VirtualKeyboardPanel.this.keyStates[VirtualKeyboardPanel.this.lastMidiKey].compareAndSet(true, false);
                    VirtualKeyboardPanel.this.lastMidiKey = -1;
                    try {
                        ShortMessage sme = new ShortMessage();
                        sme.setMessage(128, VirtualKeyboardPanel.this.channel, key + 21, VirtualKeyboardPanel.this.velocity);
                        VirtualKeyboardPanel.this.midiEngine.send((MidiMessage)sme, 0L);
                    }
                    catch (InvalidMidiDataException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    VirtualKeyboardPanel.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                if (SwingUtilities.isLeftMouseButton(me)) {
                    int key = VirtualKeyboardPanel.this.getMIDIKey(me.getX(), me.getY());
                    if (key > 87) {
                        key = 87;
                    }
                    if (key != VirtualKeyboardPanel.this.lastMidiKey) {
                        VirtualKeyboardPanel.this.keyStates[VirtualKeyboardPanel.this.lastMidiKey].set(false);
                        VirtualKeyboardPanel.this.keyStates[key].compareAndSet(false, true);
                        try {
                            ShortMessage sme = new ShortMessage();
                            sme.setMessage(128, VirtualKeyboardPanel.this.channel, VirtualKeyboardPanel.this.lastMidiKey + 21, VirtualKeyboardPanel.this.velocity);
                            VirtualKeyboardPanel.this.midiEngine.send((MidiMessage)sme, 0L);
                            sme.setMessage(144, VirtualKeyboardPanel.this.channel, key + 21, VirtualKeyboardPanel.this.velocity);
                            VirtualKeyboardPanel.this.midiEngine.send((MidiMessage)sme, 0L);
                        }
                        catch (InvalidMidiDataException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        VirtualKeyboardPanel.this.lastMidiKey = key;
                        VirtualKeyboardPanel.this.repaint();
                    }
                }
            }
        });
        this.addKeyListener(new TimedKeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: {
                        if (e.isShiftDown()) {
                            if (VirtualKeyboardPanel.this.channel >= 15) break;
                            int oldVal = VirtualKeyboardPanel.this.channel;
                            VirtualKeyboardPanel.this.channel = VirtualKeyboardPanel.this.channel + 1;
                            VirtualKeyboardPanel.this.firePropertyChange("channel", oldVal, VirtualKeyboardPanel.this.channel);
                            break;
                        }
                        if (VirtualKeyboardPanel.this.octave >= 7) break;
                        int oldVal = VirtualKeyboardPanel.this.octave;
                        VirtualKeyboardPanel.this.octave = VirtualKeyboardPanel.this.octave + 1;
                        VirtualKeyboardPanel.this.firePropertyChange("octave", oldVal, VirtualKeyboardPanel.this.octave);
                        break;
                    }
                    case 40: {
                        if (e.isShiftDown()) {
                            if (VirtualKeyboardPanel.this.channel <= 0) break;
                            int oldVal = VirtualKeyboardPanel.this.channel;
                            VirtualKeyboardPanel.this.channel = VirtualKeyboardPanel.this.channel - 1;
                            VirtualKeyboardPanel.this.firePropertyChange("channel", oldVal, VirtualKeyboardPanel.this.channel);
                            break;
                        }
                        if (VirtualKeyboardPanel.this.octave <= 0) break;
                        int oldVal = VirtualKeyboardPanel.this.octave;
                        VirtualKeyboardPanel.this.octave = VirtualKeyboardPanel.this.octave - 1;
                        VirtualKeyboardPanel.this.firePropertyChange("octave", oldVal, VirtualKeyboardPanel.this.octave);
                        break;
                    }
                    default: {
                        super.keyPressed(e);
                    }
                }
            }

            @Override
            public void KeyPressed(KeyEvent e) {
                VirtualKeyboardPanel.this.handleKey(e.getKeyChar(), true);
            }

            @Override
            public void KeyReleased(KeyEvent e) {
                VirtualKeyboardPanel.this.handleKey(e.getKeyChar(), false);
            }
        });
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public int getOctave() {
        return this.octave;
    }

    public void setOctave(int octave) {
        this.octave = octave;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    public void allNotesOff() {
        ShortMessage sme = new ShortMessage();
        for (int i = 0; i < 88; ++i) {
            if (!this.keyStates[i].getAndSet(false)) continue;
            try {
                sme.setMessage(128, this.channel, i + 21, this.velocity);
                this.midiEngine.send((MidiMessage)sme, 0L);
                continue;
            }
            catch (InvalidMidiDataException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int i;
        int whiteKeyHeight = this.getHeight();
        int blackKeyHeight = (int)((double)whiteKeyHeight * 0.625);
        float whiteKeyWidth = (float)this.getWidth() / 52.0f;
        int blackKeyWidth = (int)((double)whiteKeyWidth * 0.8333333);
        int blackKeyOffset = blackKeyWidth / 2;
        float runningX = 0.0f;
        int yval = 0;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.getWidth(), this.getHeight());
        int lineHeight = whiteKeyHeight - 1;
        for (i = 0; i < 88; ++i) {
            if (!this.isWhiteKey(i)) continue;
            int newX = (int)((double)runningX + 0.5);
            if (this.keyStates[i].get()) {
                int newW = (int)((double)(runningX + whiteKeyWidth) + 0.5 - (double)newX);
                g.setColor(Color.BLUE);
                g.fillRect(newX, yval, newW, whiteKeyHeight - 1);
            }
            runningX += whiteKeyWidth;
            g.setColor(Color.BLACK);
            g.drawLine(newX, 0, newX, lineHeight);
        }
        runningX = 0.0f;
        for (i = 0; i < 88; ++i) {
            if (this.isWhiteKey(i)) {
                runningX += whiteKeyWidth;
                continue;
            }
            if (this.keyStates[i].get()) {
                g.setColor(Color.BLUE);
                g.fillRect((int)(runningX - (float)blackKeyOffset), yval, blackKeyWidth, blackKeyHeight);
            } else {
                g.setColor(Color.BLACK);
                g.fillRect((int)(runningX - (float)blackKeyOffset), yval, blackKeyWidth, blackKeyHeight);
            }
            g.setColor(Color.BLACK);
            g.drawRect((int)(runningX - (float)blackKeyOffset), yval, blackKeyWidth, blackKeyHeight);
        }
    }

    int getMidiValForWhiteKey(int whiteKeyNum) {
        if (whiteKeyNum < 2) {
            return whiteKeyNum * 2;
        }
        int adjusted = whiteKeyNum - 2;
        int oct = adjusted / 7;
        int key = adjusted % 7;
        return 3 + oct * 12 + this.whiteKeys[key];
    }

    int getMIDIKey(int x, int y) {
        if (x >= this.getWidth()) {
            return 87;
        }
        if (x < 0) {
            return 0;
        }
        int whiteKeyHeight = this.getHeight();
        int blackKeyHeight = (int)((double)whiteKeyHeight * 0.625);
        float whiteKeyWidth = (float)this.getWidth() / 52.0f;
        float blackKeyWidth = whiteKeyWidth * 0.8333333f;
        float leftKeyBound = blackKeyWidth / 2.0f;
        float rightKeyBound = whiteKeyWidth - leftKeyBound;
        int whiteKey = (int)((float)x / whiteKeyWidth);
        float extra = (float)x - (float)whiteKey * whiteKeyWidth;
        if (whiteKey < 2) {
            if (whiteKey == 0) {
                if (y > blackKeyHeight) {
                    return whiteKey;
                }
                if (extra > rightKeyBound) {
                    return whiteKey + 1;
                }
                return whiteKey;
            }
            if (y > blackKeyHeight) {
                return this.getMidiValForWhiteKey(whiteKey);
            }
            if (extra < leftKeyBound) {
                return this.getMidiValForWhiteKey(whiteKey) - 1;
            }
            return this.getMidiValForWhiteKey(whiteKey);
        }
        int adjustedKey = (whiteKey - 2) % 7;
        if (adjustedKey == 0 || adjustedKey == 3) {
            if (y > blackKeyHeight) {
                return this.getMidiValForWhiteKey(whiteKey);
            }
            if (extra > rightKeyBound) {
                return this.getMidiValForWhiteKey(whiteKey) + 1;
            }
            return this.getMidiValForWhiteKey(whiteKey);
        }
        if (adjustedKey == 2 || adjustedKey == 6) {
            if (y > blackKeyHeight) {
                return this.getMidiValForWhiteKey(whiteKey);
            }
            if (extra < leftKeyBound) {
                return this.getMidiValForWhiteKey(whiteKey) - 1;
            }
            return this.getMidiValForWhiteKey(whiteKey);
        }
        if (y > blackKeyHeight) {
            return this.getMidiValForWhiteKey(whiteKey);
        }
        if (extra < leftKeyBound) {
            return this.getMidiValForWhiteKey(whiteKey) - 1;
        }
        if (extra > rightKeyBound) {
            return this.getMidiValForWhiteKey(whiteKey) + 1;
        }
        return this.getMidiValForWhiteKey(whiteKey);
    }

    boolean isWhiteKey(int key) {
        if (key < 3) {
            return key % 2 == 0;
        }
        int adjustedKey = (key - 3) % 12;
        switch (adjustedKey) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    protected void handleKey(char key, boolean keyDown) {
        int index = -1;
        switch (key) {
            case 'z': {
                index = 0;
                break;
            }
            case 's': {
                index = 1;
                break;
            }
            case 'x': {
                index = 2;
                break;
            }
            case 'd': {
                index = 3;
                break;
            }
            case 'c': {
                index = 4;
                break;
            }
            case 'v': {
                index = 5;
                break;
            }
            case 'g': {
                index = 6;
                break;
            }
            case 'b': {
                index = 7;
                break;
            }
            case 'h': {
                index = 8;
                break;
            }
            case 'n': {
                index = 9;
                break;
            }
            case 'j': {
                index = 10;
                break;
            }
            case 'm': {
                index = 11;
                break;
            }
            case 'q': {
                index = 12;
                break;
            }
            case '2': {
                index = 13;
                break;
            }
            case 'w': {
                index = 14;
                break;
            }
            case '3': {
                index = 15;
                break;
            }
            case 'e': {
                index = 16;
                break;
            }
            case 'r': {
                index = 17;
                break;
            }
            case '5': {
                index = 18;
                break;
            }
            case 't': {
                index = 19;
                break;
            }
            case '6': {
                index = 20;
                break;
            }
            case 'y': {
                index = 21;
                break;
            }
            case '7': {
                index = 22;
                break;
            }
            case 'u': {
                index = 23;
                break;
            }
            case 'i': {
                index = 24;
                break;
            }
            case '9': {
                index = 25;
                break;
            }
            case 'o': {
                index = 26;
                break;
            }
            case '0': {
                index = 27;
                break;
            }
            case 'p': {
                index = 28;
                break;
            }
            default: {
                return;
            }
        }
        if (index < 0) {
            return;
        }
        if ((index = this.octave * 12 + index - 21) < 0 || index > 87) {
            return;
        }
        if (this.keyStates[index].get() != keyDown) {
            this.keyStates[index].set(keyDown);
            try {
                ShortMessage sme = new ShortMessage();
                int state = keyDown ? 144 : 128;
                sme.setMessage(state, this.channel, index + 21, this.velocity);
                this.midiEngine.send((MidiMessage)sme, 0L);
            }
            catch (InvalidMidiDataException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.repaint();
        }
    }
}

