/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.midi;

import blue.BlueData;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.core.midi.MidiInputProcessorPanel;
import java.awt.Container;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JTabbedPane;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="MidiInputPanelTopComponent", persistenceType=0)
public final class MidiInputPanelTopComponent
extends TopComponent {
    private static MidiInputPanelTopComponent instance;
    private JTabbedPane jTabbedPane1;
    private MidiInputProcessorPanel midiInputProcessorPanel1;

    public MidiInputPanelTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(MidiInputPanelTopComponent.class, (String)"CTL_MidiInputPanelTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MidiInputPanelTopComponent.class, (String)"HINT_MidiInputPanelTopComponent"));
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.reinitialize();
    }

    protected void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        BlueData data = null;
        if (project != null) {
            data = project.getData();
            this.midiInputProcessorPanel1.setMidiInputProcessor(data.getMidiInputProcessor());
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.midiInputProcessorPanel1 = new MidiInputProcessorPanel();
        this.jTabbedPane1.addTab(NbBundle.getMessage(MidiInputPanelTopComponent.class, (String)"MidiInputPanelTopComponent.midiInputProcessorPanel1.TabConstraints.tabTitle"), this.midiInputProcessorPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 282, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

