/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare;

import blue.library.Library;
import blue.soundObject.SoundObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.TreeItem;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class LibraryTreeModel
implements TreeModel {
    Library<? extends SoundObject> library;
    List<TreeModelListener> listeners = Collections.synchronizedList(new ArrayList());

    public LibraryTreeModel(Library<? extends SoundObject> library) {
        this.library = library;
        library.getRoot().addEventHandler(TreeItem.childrenModificationEvent(), evt -> {
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(library.getRoot())));
            }
        });
    }

    @Override
    public Object getRoot() {
        return this.library.getRoot();
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeItem node = (TreeItem)parent;
        if (node.isLeaf()) {
            return null;
        }
        return node.getChildren().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        TreeItem node = (TreeItem)parent;
        return node.getChildren().size();
    }

    @Override
    public boolean isLeaf(Object node) {
        TreeItem n = (TreeItem)node;
        return n.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeItem node = (TreeItem)parent;
        return node.getChildren().indexOf(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }
}

