/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare;

import blue.mixer.Effect;
import blue.orchestra.Instrument;
import blue.soundObject.SoundObject;
import blue.tools.blueShare.effects.BlueShareEffectCategory;
import blue.tools.blueShare.effects.EffectOption;
import blue.tools.blueShare.instruments.BlueShareInstrumentCategory;
import blue.tools.blueShare.instruments.InstrumentOption;
import blue.tools.blueShare.soundObjects.BlueShareSoundObjectCategory;
import blue.tools.blueShare.soundObjects.SoundObjectOption;
import blue.utility.ObjectUtilities;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class BlueShareRemoteCaller {
    private static XmlRpcClient xrpc;

    public static void setServer(String server) throws MalformedURLException {
        xrpc = new XmlRpcClient(server);
    }

    public static BlueShareInstrumentCategory[] getInstrumentCategoryTree() throws IOException, XmlRpcException, ParseException {
        Vector v = new Vector();
        String result = (String)xrpc.execute("blueShare.getInstrumentCategoryTree", v);
        Document doc = new Document(result);
        Element root = doc.getRoot();
        return BlueShareRemoteCaller.getSubCategories(root);
    }

    private static BlueShareInstrumentCategory[] getSubCategories(Element parent) {
        Elements categories = parent.getElements();
        BlueShareInstrumentCategory[] iCategories = new BlueShareInstrumentCategory[categories.size()];
        int i = 0;
        while (categories.hasMoreElements()) {
            Element temp = categories.next();
            int catId = Integer.parseInt(temp.getAttribute("instrumentCategoryId").getValue());
            String name = temp.getAttribute("name").getValue();
            BlueShareInstrumentCategory[] tempCategories = BlueShareRemoteCaller.getSubCategories(temp);
            iCategories[i] = new BlueShareInstrumentCategory(catId, name, null, tempCategories);
            ++i;
        }
        return iCategories;
    }

    public static InstrumentOption[] getLatestTenInstruments() throws XmlRpcException, IOException, ParseException {
        String result = (String)xrpc.execute("blueShare.getLatestTen", new Vector());
        Document doc = new Document(result);
        Element root = doc.getRoot();
        Elements instruments = root.getElements("instrument");
        InstrumentOption[] iOptions = new InstrumentOption[instruments.size()];
        int i = 0;
        while (instruments.hasMoreElements()) {
            Element temp = instruments.next();
            int instrumentId = Integer.parseInt(temp.getAttribute("instrumentId").getValue());
            String screenName = temp.getElement("screenName").getTextString();
            String name = temp.getElement("name").getTextString();
            String type = temp.getElement("type").getTextString();
            String description = temp.getElement("description").getTextString();
            String category = temp.getElement("category").getTextString();
            iOptions[i] = new InstrumentOption(instrumentId, BlueShareRemoteCaller.checkNullString(screenName), BlueShareRemoteCaller.checkNullString(name), BlueShareRemoteCaller.checkNullString(type), BlueShareRemoteCaller.checkNullString(description), BlueShareRemoteCaller.checkNullString(category));
            ++i;
        }
        return iOptions;
    }

    public static InstrumentOption[] getInstrumentOptions(BlueShareInstrumentCategory iCategory) throws IOException, XmlRpcException, ParseException {
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(iCategory.getCategoryId()));
        String result = (String)xrpc.execute("blueShare.getInstrumentList", v);
        Document doc = new Document(result);
        Element root = doc.getRoot();
        Elements instruments = root.getElements("instrument");
        InstrumentOption[] iOptions = new InstrumentOption[instruments.size()];
        int i = 0;
        while (instruments.hasMoreElements()) {
            Element temp = instruments.next();
            int instrumentId = Integer.parseInt(temp.getAttribute("instrumentId").getValue());
            String screenName = temp.getElement("screenName").getTextString();
            String name = temp.getElement("name").getTextString();
            String type = temp.getElement("type").getTextString();
            String description = temp.getElement("description").getTextString();
            String category = temp.getElement("category").getTextString();
            iOptions[i] = new InstrumentOption(instrumentId, BlueShareRemoteCaller.checkNullString(screenName), BlueShareRemoteCaller.checkNullString(name), BlueShareRemoteCaller.checkNullString(type), BlueShareRemoteCaller.checkNullString(description), BlueShareRemoteCaller.checkNullString(category));
            ++i;
        }
        return iOptions;
    }

    public static InstrumentOption[] getInstrumentOptionsForUser(String username, String password) throws IOException, XmlRpcException, ParseException {
        Vector<String> v = new Vector<String>();
        v.add(username);
        v.add(password);
        String result = (String)xrpc.execute("blueShare.getInstrumentListForUser", v);
        Document doc = new Document(result);
        Element root = doc.getRoot();
        Elements instruments = root.getElements("instrument");
        InstrumentOption[] iOptions = new InstrumentOption[instruments.size()];
        int i = 0;
        while (instruments.hasMoreElements()) {
            Element temp = instruments.next();
            int instrumentId = Integer.parseInt(temp.getAttribute("instrumentId").getValue());
            String screenName = temp.getElement("screenName").getTextString();
            String name = temp.getElement("name").getTextString();
            String type = temp.getElement("type").getTextString();
            String description = temp.getElement("description").getTextString();
            String category = temp.getElement("category").getTextString();
            iOptions[i] = new InstrumentOption(instrumentId, BlueShareRemoteCaller.checkNullString(screenName), BlueShareRemoteCaller.checkNullString(name), BlueShareRemoteCaller.checkNullString(type), BlueShareRemoteCaller.checkNullString(description), BlueShareRemoteCaller.checkNullString(category));
            ++i;
        }
        return iOptions;
    }

    public static Instrument getInstrument(InstrumentOption iOption) throws IOException, XmlRpcException, ParseException {
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(iOption.getInstrumentId()));
        String result = (String)xrpc.execute("blueShare.getInstrument", v);
        Instrument instrument = null;
        try {
            Document d = new Document(result);
            instrument = (Instrument)ObjectUtilities.loadFromXML((Element)d.getRoot());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return instrument;
    }

    public static boolean submitInstrument(String username, String password, int categoryId, String name, String instrumentType, String description, String instrumentText) throws IOException, XmlRpcException {
        Vector<Object> v = new Vector<Object>();
        v.add(username);
        v.add(password);
        v.add(new Integer(categoryId));
        v.add(name);
        v.add(instrumentType);
        v.add(description);
        v.add(instrumentText);
        String result = (String)xrpc.execute("blueShare.submitInstrument", v);
        return true;
    }

    public static boolean removeInstrument(String username, String password, int instrumentId) throws XmlRpcException, IOException {
        Vector<Object> v = new Vector<Object>();
        v.add(username);
        v.add(password);
        v.add(new Integer(instrumentId));
        return (Boolean)xrpc.execute("blueShare.removeInstrument", v);
    }

    public static BlueShareEffectCategory[] getEffectCategoryTree() throws IOException, XmlRpcException, ParseException {
        Vector v = new Vector();
        String result = (String)xrpc.execute("blueShare.getEffectCategoryTree", v);
        Document doc = new Document(result);
        Element root = doc.getRoot();
        return BlueShareRemoteCaller.getEffectSubCategories(root);
    }

    private static BlueShareEffectCategory[] getEffectSubCategories(Element parent) {
        Elements categories = parent.getElements();
        BlueShareEffectCategory[] iCategories = new BlueShareEffectCategory[categories.size()];
        int i = 0;
        while (categories.hasMoreElements()) {
            Element temp = categories.next();
            int catId = Integer.parseInt(temp.getAttribute("effectCategoryId").getValue());
            String name = temp.getAttribute("name").getValue();
            BlueShareEffectCategory[] tempCategories = BlueShareRemoteCaller.getEffectSubCategories(temp);
            iCategories[i] = new BlueShareEffectCategory(catId, name, null, tempCategories);
            ++i;
        }
        return iCategories;
    }

    public static EffectOption[] getLatestTenEffects() throws XmlRpcException, IOException, ParseException {
        String result = (String)xrpc.execute("blueShare.getLatestTenEffects", new Vector());
        Document doc = new Document(result);
        Element root = doc.getRoot();
        Elements instruments = root.getElements("effect");
        EffectOption[] effectOptions = new EffectOption[instruments.size()];
        int i = 0;
        while (instruments.hasMoreElements()) {
            Element temp = instruments.next();
            int effectId = Integer.parseInt(temp.getAttribute("effectId").getValue());
            String screenName = temp.getElement("screenName").getTextString();
            String name = temp.getElement("name").getTextString();
            String description = temp.getElement("description").getTextString();
            String category = temp.getElement("category").getTextString();
            effectOptions[i] = new EffectOption(effectId, BlueShareRemoteCaller.checkNullString(screenName), BlueShareRemoteCaller.checkNullString(name), BlueShareRemoteCaller.checkNullString(description), BlueShareRemoteCaller.checkNullString(category));
            ++i;
        }
        return effectOptions;
    }

    public static EffectOption[] getEffectOptions(BlueShareEffectCategory iCategory) throws IOException, XmlRpcException, ParseException {
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(iCategory.getCategoryId()));
        String result = (String)xrpc.execute("blueShare.getEffectList", v);
        Document doc = new Document(result);
        Element root = doc.getRoot();
        Elements instruments = root.getElements("effect");
        EffectOption[] effectOptions = new EffectOption[instruments.size()];
        int i = 0;
        while (instruments.hasMoreElements()) {
            Element temp = instruments.next();
            int instrumentId = Integer.parseInt(temp.getAttribute("effectId").getValue());
            String screenName = temp.getElement("screenName").getTextString();
            String name = temp.getElement("name").getTextString();
            String description = temp.getElement("description").getTextString();
            String category = temp.getElement("category").getTextString();
            effectOptions[i] = new EffectOption(instrumentId, BlueShareRemoteCaller.checkNullString(screenName), BlueShareRemoteCaller.checkNullString(name), BlueShareRemoteCaller.checkNullString(description), BlueShareRemoteCaller.checkNullString(category));
            ++i;
        }
        return effectOptions;
    }

    public static EffectOption[] getEffectOptionsForUser(String username, String password) throws IOException, XmlRpcException, ParseException {
        Vector<String> v = new Vector<String>();
        v.add(username);
        v.add(password);
        String result = (String)xrpc.execute("blueShare.getEffectListForUser", v);
        Document doc = new Document(result);
        Element root = doc.getRoot();
        Elements instruments = root.getElements("effect");
        EffectOption[] iOptions = new EffectOption[instruments.size()];
        int i = 0;
        while (instruments.hasMoreElements()) {
            Element temp = instruments.next();
            int effectId = Integer.parseInt(temp.getAttribute("effectId").getValue());
            String screenName = temp.getElement("screenName").getTextString();
            String name = temp.getElement("name").getTextString();
            String description = temp.getElement("description").getTextString();
            String category = temp.getElement("category").getTextString();
            iOptions[i] = new EffectOption(effectId, BlueShareRemoteCaller.checkNullString(screenName), BlueShareRemoteCaller.checkNullString(name), BlueShareRemoteCaller.checkNullString(description), BlueShareRemoteCaller.checkNullString(category));
            ++i;
        }
        return iOptions;
    }

    public static Effect getEffect(EffectOption iOption) throws IOException, XmlRpcException, ParseException {
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(iOption.getInstrumentId()));
        String result = (String)xrpc.execute("blueShare.getEffect", v);
        Effect effect = null;
        try {
            Document d = new Document(result);
            effect = Effect.loadFromXML((Element)d.getRoot());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return effect;
    }

    public static boolean submitEffect(String username, String password, int categoryId, String name, String description, String instrumentText) throws IOException, XmlRpcException {
        Vector<Object> v = new Vector<Object>();
        v.add(username);
        v.add(password);
        v.add(new Integer(categoryId));
        v.add(name);
        v.add(description);
        v.add(instrumentText);
        String result = (String)xrpc.execute("blueShare.submitEffect", v);
        return true;
    }

    public static boolean removeEffect(String username, String password, int effectId) throws XmlRpcException, IOException {
        Vector<Object> v = new Vector<Object>();
        v.add(username);
        v.add(password);
        v.add(new Integer(effectId));
        return (Boolean)xrpc.execute("blueShare.removeEffect", v);
    }

    public static BlueShareSoundObjectCategory[] getSoundObjectCategoryTree() throws IOException, XmlRpcException, ParseException {
        Vector v = new Vector();
        String result = (String)xrpc.execute("blueShare.getSoundObjectCategoryTree", v);
        Document doc = new Document(result);
        Element root = doc.getRoot();
        return BlueShareRemoteCaller.getSoundObjectSubCategories(root);
    }

    private static BlueShareSoundObjectCategory[] getSoundObjectSubCategories(Element parent) {
        Elements categories = parent.getElements();
        BlueShareSoundObjectCategory[] iCategories = new BlueShareSoundObjectCategory[categories.size()];
        int i = 0;
        while (categories.hasMoreElements()) {
            Element temp = categories.next();
            int catId = Integer.parseInt(temp.getAttribute("soundObjectCategoryId").getValue());
            String name = temp.getAttribute("name").getValue();
            BlueShareSoundObjectCategory[] tempCategories = BlueShareRemoteCaller.getSoundObjectSubCategories(temp);
            iCategories[i] = new BlueShareSoundObjectCategory(catId, name, null, tempCategories);
            ++i;
        }
        return iCategories;
    }

    public static SoundObjectOption[] getLatestTenSoundObjects() throws XmlRpcException, IOException, ParseException {
        String result = (String)xrpc.execute("blueShare.getLatestTenSoundObjects", new Vector());
        Document doc = new Document(result);
        Element root = doc.getRoot();
        Elements soundObjects = root.getElements("soundObject");
        SoundObjectOption[] iOptions = new SoundObjectOption[soundObjects.size()];
        int i = 0;
        while (soundObjects.hasMoreElements()) {
            Element temp = soundObjects.next();
            int soundObjectId = Integer.parseInt(temp.getAttribute("soundObjectId").getValue());
            String screenName = temp.getElement("screenName").getTextString();
            String name = temp.getElement("name").getTextString();
            String type = temp.getElement("type").getTextString();
            String description = temp.getElement("description").getTextString();
            String category = temp.getElement("category").getTextString();
            iOptions[i] = new SoundObjectOption(soundObjectId, BlueShareRemoteCaller.checkNullString(screenName), BlueShareRemoteCaller.checkNullString(name), BlueShareRemoteCaller.checkNullString(type), BlueShareRemoteCaller.checkNullString(description), BlueShareRemoteCaller.checkNullString(category));
            ++i;
        }
        return iOptions;
    }

    public static SoundObjectOption[] getSoundObjectOptions(BlueShareSoundObjectCategory iCategory) throws IOException, XmlRpcException, ParseException {
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(iCategory.getCategoryId()));
        String result = (String)xrpc.execute("blueShare.getSoundObjectList", v);
        Document doc = new Document(result);
        Element root = doc.getRoot();
        Elements soundObjects = root.getElements("soundObject");
        SoundObjectOption[] iOptions = new SoundObjectOption[soundObjects.size()];
        int i = 0;
        while (soundObjects.hasMoreElements()) {
            Element temp = soundObjects.next();
            int soundObjectId = Integer.parseInt(temp.getAttribute("soundObjectId").getValue());
            String screenName = temp.getElement("screenName").getTextString();
            String name = temp.getElement("name").getTextString();
            String type = temp.getElement("type").getTextString();
            String description = temp.getElement("description").getTextString();
            String category = temp.getElement("category").getTextString();
            iOptions[i] = new SoundObjectOption(soundObjectId, BlueShareRemoteCaller.checkNullString(screenName), BlueShareRemoteCaller.checkNullString(name), BlueShareRemoteCaller.checkNullString(type), BlueShareRemoteCaller.checkNullString(description), BlueShareRemoteCaller.checkNullString(category));
            ++i;
        }
        return iOptions;
    }

    public static SoundObjectOption[] getSoundObjectOptionsForUser(String username, String password) throws IOException, XmlRpcException, ParseException {
        Vector<String> v = new Vector<String>();
        v.add(username);
        v.add(password);
        String result = (String)xrpc.execute("blueShare.getSoundObjectListForUser", v);
        Document doc = new Document(result);
        Element root = doc.getRoot();
        Elements soundObjects = root.getElements("soundObject");
        SoundObjectOption[] iOptions = new SoundObjectOption[soundObjects.size()];
        int i = 0;
        while (soundObjects.hasMoreElements()) {
            Element temp = soundObjects.next();
            int soundObjectId = Integer.parseInt(temp.getAttribute("soundObjectId").getValue());
            String screenName = temp.getElement("screenName").getTextString();
            String name = temp.getElement("name").getTextString();
            String type = temp.getElement("type").getTextString();
            String description = temp.getElement("description").getTextString();
            String category = temp.getElement("category").getTextString();
            iOptions[i] = new SoundObjectOption(soundObjectId, BlueShareRemoteCaller.checkNullString(screenName), BlueShareRemoteCaller.checkNullString(name), BlueShareRemoteCaller.checkNullString(type), BlueShareRemoteCaller.checkNullString(description), BlueShareRemoteCaller.checkNullString(category));
            ++i;
        }
        return iOptions;
    }

    public static SoundObject getSoundObject(SoundObjectOption iOption) throws IOException, XmlRpcException, ParseException {
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(iOption.getSoundObjectId()));
        String result = (String)xrpc.execute("blueShare.getSoundObject", v);
        SoundObject soundObject = null;
        try {
            Document d = new Document(result);
            soundObject = (SoundObject)ObjectUtilities.loadFromXML((Element)d.getRoot(), new HashMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return soundObject;
    }

    public static boolean submitSoundObject(String username, String password, int categoryId, String name, String soundObjectType, String description, String soundObjectText) throws IOException, XmlRpcException {
        Vector<Object> v = new Vector<Object>();
        v.add(username);
        v.add(password);
        v.add(new Integer(categoryId));
        v.add(name);
        v.add(soundObjectType);
        v.add(description);
        v.add(soundObjectText);
        String result = (String)xrpc.execute("blueShare.submitSoundObject", v);
        return true;
    }

    public static boolean removeSoundObject(String username, String password, int soundObjectId) throws XmlRpcException, IOException {
        Vector<Object> v = new Vector<Object>();
        v.add(username);
        v.add(password);
        v.add(new Integer(soundObjectId));
        return (Boolean)xrpc.execute("blueShare.removeSoundObject", v);
    }

    private static String checkNullString(String stringToCheck) {
        if (stringToCheck == null) {
            return "";
        }
        return stringToCheck;
    }
}

