/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.BlueSystem;
import blue.components.AlphaMarquee;
import blue.event.SelectionEvent;
import blue.event.SelectionListener;
import blue.soundObject.PianoRoll;
import blue.soundObject.editor.pianoRoll.NoteBuffer;
import blue.soundObject.editor.pianoRoll.NoteCanvasMouseListener;
import blue.soundObject.editor.pianoRoll.PianoNoteView;
import blue.soundObject.pianoRoll.PianoNote;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;

public class PianoRollCanvas
extends JLayeredPane
implements Scrollable,
PropertyChangeListener {
    public static final List<PianoNote> NOTE_COPY_BUFFER = new ArrayList<PianoNote>();
    JPopupMenu popup = new JPopupMenu();
    private static final int RIGHT_EXTRA_SPACE = 100;
    int octaves = 16;
    int centerOctave = 8;
    AlphaMarquee marquee = new AlphaMarquee();
    private static Color OCTAVE_COLOR = new Color(198, 226, 255);
    private static Color LINE_COLOR = Color.black;
    protected PianoRoll p;
    public NoteBuffer noteBuffer = new NoteBuffer();
    ComponentListener cl;
    private final NoteCanvasMouseListener nMouse;
    int maxUnitIncrement = 50;

    public PianoRollCanvas() {
        this.setLayout(null);
        this.recalculateSize();
        this.setBackground(Color.black);
        this.nMouse = new NoteCanvasMouseListener(this);
        this.cl = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                PianoRollCanvas.this.recalculateSize();
                PianoRollCanvas.this.repaint();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                PianoRollCanvas.this.recalculateSize();
                PianoRollCanvas.this.repaint();
            }
        };
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof PianoNoteView) {
                    e.getChild().addComponentListener(PianoRollCanvas.this.cl);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() instanceof PianoNoteView) {
                    e.getChild().removeComponentListener(PianoRollCanvas.this.cl);
                }
            }
        });
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "deleteNotes");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteNotes");
        int osCtrlKey = BlueSystem.getMenuShortcutKey();
        inputMap.put(KeyStroke.getKeyStroke(88, osCtrlKey), "cut");
        inputMap.put(KeyStroke.getKeyStroke(67, osCtrlKey), "copy");
        inputMap.put(KeyStroke.getKeyStroke(39, osCtrlKey), "raisePixelSecond");
        inputMap.put(KeyStroke.getKeyStroke(37, osCtrlKey), "lowerPixelSecond");
        inputMap.put(KeyStroke.getKeyStroke(40, osCtrlKey), "raiseHeight");
        inputMap.put(KeyStroke.getKeyStroke(38, osCtrlKey), "lowerHeight");
        inputMap.put(KeyStroke.getKeyStroke(61, osCtrlKey), "raisePixelSecond");
        inputMap.put(KeyStroke.getKeyStroke(45, osCtrlKey), "lowerPixelSecond");
        inputMap.put(KeyStroke.getKeyStroke(61, osCtrlKey | 0x40), "raiseHeight");
        inputMap.put(KeyStroke.getKeyStroke(45, osCtrlKey | 0x40), "lowerHeight");
        AbstractAction deleteNotes = new AbstractAction(BlueSystem.getString((String)"common.remove")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PianoRollCanvas.this.noteBuffer.size() > 0) {
                    PianoRollCanvas.this.removeNotes();
                }
            }
        };
        AbstractAction copyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PianoRollCanvas.this.copy();
            }
        };
        AbstractAction cutAction = new AbstractAction("Cut"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PianoRollCanvas.this.cut();
            }
        };
        actionMap.put("deleteNotes", deleteNotes);
        actionMap.put("cut", cutAction);
        actionMap.put("copy", copyAction);
        JMenuItem remove = new JMenuItem("Remove");
        remove.setAction(deleteNotes);
        JMenuItem cut = new JMenuItem("Cut");
        cut.setAction(cutAction);
        JMenuItem copy = new JMenuItem("Copy");
        copy.setAction(copyAction);
        this.popup.add(cut);
        this.popup.add(copy);
        this.popup.addSeparator();
        this.popup.add(remove);
        actionMap.put("raisePixelSecond", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PianoRollCanvas.this.raisePixelSecond();
            }
        });
        actionMap.put("lowerPixelSecond", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PianoRollCanvas.this.lowerPixelSecond();
            }
        });
        actionMap.put("raiseHeight", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PianoRollCanvas.this.raiseHeight();
            }
        });
        actionMap.put("lowerHeight", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PianoRollCanvas.this.lowerHeight();
            }
        });
    }

    public void cut() {
        this.copy();
        this.removeNotes();
    }

    public void copy() {
        NOTE_COPY_BUFFER.clear();
        for (PianoNoteView pnv : this.noteBuffer) {
            NOTE_COPY_BUFFER.add(new PianoNote(pnv.getPianoNote()));
        }
    }

    protected void removeNotes() {
        for (int i = 0; i < this.noteBuffer.size(); ++i) {
            PianoNoteView noteView = (PianoNoteView)this.noteBuffer.get(i);
            this.p.getNotes().remove(noteView.getPianoNote());
            this.remove(noteView);
        }
        this.nMouse.fireSelectionEvent((SelectionEvent<PianoNoteView>)new SelectionEvent(null, -1));
        this.repaint();
    }

    public void recalculateSize() {
        int h;
        if (this.p == null) {
            return;
        }
        int noteHeight = this.p.getNoteHeight();
        if (this.p.getPchGenerationMethod() == 2) {
            h = 128 * noteHeight;
        } else {
            int notesPerOctave = this.p.getScale().getNumScaleDegrees();
            h = notesPerOctave * this.octaves * noteHeight;
        }
        int maxW = this.getParent().getWidth();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component comp = this.getComponent(i);
            int right = comp.getX() + comp.getWidth() + 100;
            if (right <= maxW) continue;
            maxW = right;
        }
        this.setSize(maxW, h);
        this.setPreferredSize(new Dimension(maxW, h));
    }

    @Override
    public void paintComponent(Graphics g) {
        int notesPerOctave;
        int octaveHeight;
        int h;
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.p == null) {
            return;
        }
        int w = this.getWidth();
        int noteHeight = this.p.getNoteHeight();
        if (this.p.getPchGenerationMethod() == 2) {
            h = 128 * noteHeight;
            octaveHeight = noteHeight * 12;
            notesPerOctave = 12;
        } else {
            notesPerOctave = this.p.getScale().getNumScaleDegrees();
            octaveHeight = notesPerOctave * noteHeight;
            h = this.octaves * octaveHeight;
        }
        for (int i = 0; i < this.octaves; ++i) {
            int lineY = h - i * octaveHeight;
            Color lightColor = new Color(38, 51, 76);
            GradientPaint backgroundPaint = new GradientPaint(0.0f, lineY, Color.BLACK, 1.0f, lineY - octaveHeight, lightColor);
            g2d.setPaint(backgroundPaint);
            g2d.fillRect(0, lineY - octaveHeight, w, octaveHeight);
            g.setColor(OCTAVE_COLOR);
            g.drawLine(0, lineY, w, lineY);
            g.setColor(LINE_COLOR);
            for (int j = 1; j < notesPerOctave; ++j) {
                lineY = h - (i * notesPerOctave + j) * noteHeight;
                g.drawLine(0, lineY, w, lineY);
            }
        }
        if (this.p.isSnapEnabled()) {
            int snapPixels = (int)(this.p.getSnapValue() * (double)this.p.getPixelSecond());
            int x = 0;
            if (snapPixels <= 0) {
                return;
            }
            double snapValue = this.p.getSnapValue();
            int pixelSecond = this.p.getPixelSecond();
            int i = 0;
            while (x < w) {
                x = (int)((double)i * snapValue * (double)pixelSecond);
                g.drawLine(x, 0, x, h);
                ++i;
            }
        }
    }

    public void editPianoRoll(PianoRoll p) {
        if (this.p != null && this.p != p) {
            this.p.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.p != p) {
            p.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.p = p;
        this.noteBuffer.setPianoRoll(p);
        this.removeAll();
        this.add((Component)this.marquee, JLayeredPane.DRAG_LAYER);
        this.marquee.setVisible(false);
        for (PianoNote note : p.getNotes()) {
            this.addNoteView(note);
        }
        this.nMouse.fireSelectionEvent((SelectionEvent<PianoNoteView>)new SelectionEvent(null, -1));
        this.recalculateSize();
        this.revalidate();
        this.repaint();
    }

    public PianoNoteView addNote(double startTime, int y) {
        PianoNote note = new PianoNote();
        note.setNoteTemplate(this.p.getNoteTemplate());
        note.setStart(startTime);
        int[] pch = this.getOctaveScaleDegreeForY(y);
        note.setOctave(pch[0]);
        note.setScaleDegree(pch[1]);
        return this.addNote(note);
    }

    public int[] getOctaveScaleDegreeForY(int y) {
        int[] retVal = new int[2];
        int h = this.getHeight() - y;
        int noteHeight = this.p.getNoteHeight();
        int numScaleDegrees = this.p.getScale().getNumScaleDegrees();
        retVal[0] = (h /= noteHeight) / numScaleDegrees;
        retVal[1] = h % numScaleDegrees;
        return retVal;
    }

    public PianoNoteView addNote(PianoNote note) {
        this.p.getNotes().add(note);
        PianoNoteView n = this.addNoteView(note);
        this.repaint();
        return n;
    }

    private PianoNoteView addNoteView(PianoNote note) {
        PianoNoteView noteView = new PianoNoteView(note, this.p);
        this.add(noteView);
        return noteView;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.p) {
            String propertyName;
            switch (propertyName = evt.getPropertyName()) {
                case "scale": 
                case "pchGenerationMethod": {
                    this.recalculateSize();
                    this.revalidate();
                    this.repaint();
                    break;
                }
                case "snapEnabled": 
                case "snapValue": {
                    this.repaint();
                    break;
                }
                case "timeValue": {
                    break;
                }
                case "pixelSecond": 
                case "noteHeight": {
                    this.editPianoRoll(this.p);
                }
            }
        }
    }

    public void addSelectionListener(SelectionListener<PianoNoteView> listener) {
        this.nMouse.addSelectionListener(listener);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        if (orientation != 0) {
            return this.p.getNoteHeight();
        }
        currentPosition = visibleRect.x;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return this.p.getNoteHeight() * 5;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getNoteHeight() {
        if (this.p == null) {
            return 0;
        }
        return this.p.getNoteHeight();
    }

    public void showPopup(int x, int y) {
        this.popup.show(this, x, y);
    }

    private void lowerHeight() {
        if (this.p == null) {
            return;
        }
        int noteHeight = this.p.getNoteHeight();
        if (noteHeight > 5) {
            this.p.setNoteHeight(--noteHeight);
        }
    }

    private void raiseHeight() {
        if (this.p == null) {
            return;
        }
        int noteHeight = this.p.getNoteHeight();
        if (noteHeight < 25) {
            this.p.setNoteHeight(++noteHeight);
        }
    }

    private void lowerPixelSecond() {
        if (this.p == null) {
            return;
        }
        int pixelSecond = this.p.getPixelSecond();
        if (pixelSecond <= 2) {
            return;
        }
        this.p.setPixelSecond(pixelSecond -= 2);
    }

    private void raisePixelSecond() {
        if (this.p == null) {
            return;
        }
        int pixelSecond = this.p.getPixelSecond() + 2;
        this.p.setPixelSecond(pixelSecond);
    }
}

