/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.BlueSystem;
import blue.event.SelectionEvent;
import blue.event.SelectionListener;
import blue.soundObject.editor.pianoRoll.PianoNoteView;
import blue.soundObject.editor.pianoRoll.PianoRollCanvas;
import blue.soundObject.pianoRoll.PianoNote;
import blue.ui.utilities.UiUtilities;
import blue.utility.ScoreUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class NoteCanvasMouseListener
implements MouseListener,
MouseMotionListener {
    private static final int EDGE = 5;
    private static final int OS_CTRL_KEY = BlueSystem.getMenuShortcutKey();
    private final Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    private final Cursor NORMAL_CURSOR = Cursor.getPredefinedCursor(0);
    private Rectangle scrollRect = new Rectangle(0, 0, 1, 1);
    private PianoRollCanvas canvas;
    private ArrayList<SelectionListener<PianoNoteView>> listeners = new ArrayList();
    private Point start = null;
    private JPopupMenu pasteMenu = new JPopupMenu();
    int pasteX = 0;
    int pasteY = 0;

    public NoteCanvasMouseListener(PianoRollCanvas canvas) {
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        this.addSelectionListener(canvas.noteBuffer);
        this.canvas = canvas;
        this.pasteMenu.add(new AbstractAction("Paste"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PianoRollCanvas.NOTE_COPY_BUFFER.size() > 0) {
                    NoteCanvasMouseListener.this.pasteNotes(NoteCanvasMouseListener.this.pasteX, NoteCanvasMouseListener.this.pasteY);
                }
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.canvas.requestFocus();
        Component comp = this.canvas.getComponentAt(e.getPoint());
        if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
            if (comp instanceof PianoNoteView && this.canvas.noteBuffer.contains(comp)) {
                this.canvas.showPopup(e.getX(), e.getY());
            } else if (!PianoRollCanvas.NOTE_COPY_BUFFER.isEmpty()) {
                this.pasteX = e.getX();
                this.pasteY = e.getY();
                this.pasteMenu.show(this.canvas, this.pasteX, this.pasteY);
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (comp instanceof PianoNoteView) {
                PianoNoteView noteView = (PianoNoteView)comp;
                SelectionEvent selEvt = null;
                if (this.canvas.getCursor() == this.RESIZE_CURSOR) {
                    selEvt = new SelectionEvent((Object)noteView, 0);
                    this.fireSelectionEvent((SelectionEvent<PianoNoteView>)selEvt);
                    this.canvas.noteBuffer.startResize();
                    this.start = new Point(noteView.getX() + noteView.getWidth(), e.getY());
                } else if (this.canvas.noteBuffer.contains(noteView)) {
                    this.start = e.getPoint();
                    this.canvas.noteBuffer.startMove();
                } else {
                    this.start = null;
                    selEvt = e.isShiftDown() && this.canvas.getCursor() == this.NORMAL_CURSOR && this.canvas.noteBuffer.size() > 0 ? new SelectionEvent((Object)noteView, 1) : new SelectionEvent((Object)noteView, 0);
                    this.fireSelectionEvent((SelectionEvent<PianoNoteView>)selEvt);
                }
            } else if ((e.getModifiers() & OS_CTRL_KEY) == OS_CTRL_KEY && !e.isShiftDown()) {
                if (PianoRollCanvas.NOTE_COPY_BUFFER.isEmpty()) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                this.pasteNotes(x, y);
            } else if (e.isShiftDown() && (e.getModifiers() & OS_CTRL_KEY) != OS_CTRL_KEY) {
                this.fireSelectionEvent((SelectionEvent<PianoNoteView>)new SelectionEvent(null, -1));
                int x = e.getX();
                int y = e.getY();
                double startTime = (double)x / (double)this.canvas.p.getPixelSecond();
                double duration = 5.0f / (float)this.canvas.p.getPixelSecond();
                if (this.canvas.p.isSnapEnabled()) {
                    double snapValue = this.canvas.p.getSnapValue();
                    startTime = ScoreUtilities.getSnapValueStart((double)startTime, (double)snapValue);
                    duration = this.canvas.p.getSnapValue();
                }
                PianoNoteView noteView = this.canvas.addNote(startTime, y);
                SelectionEvent selEvt = new SelectionEvent((Object)noteView, 1);
                noteView.getPianoNote().setDuration(duration);
                this.start = new Point(noteView.getX() + noteView.getWidth(), y);
                this.fireSelectionEvent((SelectionEvent<PianoNoteView>)selEvt);
                this.canvas.noteBuffer.startResize();
                this.canvas.setCursor(this.RESIZE_CURSOR);
            } else {
                this.fireSelectionEvent((SelectionEvent<PianoNoteView>)new SelectionEvent(null, -1));
                this.start = null;
                this.canvas.marquee.setStart(e.getPoint());
                this.canvas.marquee.setVisible(true);
            }
        }
    }

    private void pasteNotes(int x, int y) {
        double startTime = (double)x / (double)this.canvas.p.getPixelSecond();
        int[] pchBase = this.canvas.getOctaveScaleDegreeForY(y);
        double timeAdjust = Double.MAX_VALUE;
        int topPitchNum = Integer.MIN_VALUE;
        int bottomPitchNum = Integer.MAX_VALUE;
        int scaleDegrees = this.canvas.p.getScale().getNumScaleDegrees();
        if (this.canvas.p.isSnapEnabled()) {
            double snapValue = this.canvas.p.getSnapValue();
            startTime = ScoreUtilities.getSnapValueStart((double)startTime, (double)snapValue);
        }
        for (PianoNote note : PianoRollCanvas.NOTE_COPY_BUFFER) {
            timeAdjust = Math.min(timeAdjust, note.getStart());
            int pitchNum = note.getOctave() * scaleDegrees + note.getScaleDegree();
            topPitchNum = Math.max(topPitchNum, pitchNum);
            bottomPitchNum = Math.min(bottomPitchNum, pitchNum);
        }
        this.fireSelectionEvent((SelectionEvent<PianoNoteView>)new SelectionEvent(null, -1));
        this.start = null;
        int basePitchNum = pchBase[0] * scaleDegrees + pchBase[1];
        int pitchNumAdjust = basePitchNum - topPitchNum;
        for (PianoNote note : PianoRollCanvas.NOTE_COPY_BUFFER) {
            PianoNote copy = new PianoNote(note);
            copy.setStart(startTime + (copy.getStart() - timeAdjust));
            int pitchNum = copy.getOctave() * scaleDegrees + copy.getScaleDegree();
            copy.setOctave((pitchNum += pitchNumAdjust) / scaleDegrees);
            copy.setScaleDegree(pitchNum % scaleDegrees);
            this.canvas.addNote(copy);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.canvas.marquee.isVisible()) {
            this.endMarquee();
        }
        if (this.start != null) {
            if (!this.canvas.p.isSnapEnabled()) {
                if (this.canvas.getCursor() == this.NORMAL_CURSOR) {
                    this.canvas.noteBuffer.endMove();
                } else {
                    this.canvas.noteBuffer.endResize();
                }
            }
            this.start = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.canvas.marquee.isVisible()) {
            this.canvas.marquee.setDragPoint(e.getPoint());
            this.checkScroll(e);
            return;
        }
        if (this.start == null) {
            return;
        }
        if (this.canvas.getCursor() == this.RESIZE_CURSOR) {
            this.resizeNote(e);
        } else if (this.canvas.getCursor() == this.NORMAL_CURSOR) {
            this.moveNotes(e);
        }
        this.checkScroll(e);
    }

    private void checkScroll(MouseEvent e) {
        Point temp = SwingUtilities.convertPoint(this.canvas, e.getPoint(), this.canvas.getParent());
        this.scrollRect.setLocation(temp);
        ((JViewport)this.canvas.getParent()).scrollRectToVisible(this.scrollRect);
    }

    private void moveNotes(MouseEvent e) {
        int diffX = e.getPoint().x - this.start.x;
        int noteHeight = this.canvas.getNoteHeight();
        int layerDiff = e.getPoint().y / noteHeight - this.start.y / noteHeight;
        if (this.canvas.p.isSnapEnabled()) {
            double initialStartTime = this.canvas.noteBuffer.initialStartTimes[0];
            double timeAdjust = (double)diffX / (double)this.canvas.p.getPixelSecond();
            double tempStart = initialStartTime + timeAdjust;
            if (tempStart < 0.0) {
                timeAdjust = -initialStartTime;
            } else {
                double snappedStart = ScoreUtilities.getSnapValueMove((double)tempStart, (double)this.canvas.p.getSnapValue());
                timeAdjust = snappedStart - initialStartTime;
            }
            this.canvas.noteBuffer.moveByTime(timeAdjust, layerDiff);
        } else {
            this.canvas.noteBuffer.move(diffX, layerDiff);
        }
    }

    private void resizeNote(MouseEvent e) {
        int mouseX = e.getPoint().x;
        if (this.canvas.p.isSnapEnabled()) {
            double minTime;
            double snapValue = this.canvas.p.getSnapValue();
            double endTime = ScoreUtilities.getSnapValueMove((double)((double)mouseX / (double)this.canvas.p.getPixelSecond()), (double)snapValue);
            endTime = endTime < (minTime = ScoreUtilities.getSnapValueMove((double)(this.canvas.noteBuffer.initialStartTimes[0] + snapValue / 2.0), (double)snapValue)) ? minTime : endTime;
            double newDuration = endTime - this.canvas.noteBuffer.initialStartTimes[0];
            this.canvas.noteBuffer.setDuration(newDuration);
        } else {
            int diffX = mouseX - this.start.x;
            this.canvas.noteBuffer.resize(diffX);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component comp = this.canvas.getComponentAt(e.getPoint());
        if (comp instanceof PianoNoteView) {
            if (e.getX() > comp.getX() + comp.getWidth() - 5) {
                this.canvas.setCursor(this.RESIZE_CURSOR);
            } else {
                this.canvas.setCursor(this.NORMAL_CURSOR);
            }
        } else {
            this.canvas.setCursor(this.NORMAL_CURSOR);
        }
    }

    public void endMarquee() {
        this.canvas.marquee.setVisible(false);
        Component[] comps = this.canvas.getComponents();
        this.fireSelectionEvent((SelectionEvent<PianoNoteView>)new SelectionEvent(null, -1));
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof PianoNoteView) || !this.canvas.marquee.intersects((JComponent)comps[i])) continue;
            boolean isFirst = this.canvas.noteBuffer.size() == 0;
            int selectionType = isFirst ? 0 : 1;
            SelectionEvent selectionEvent = new SelectionEvent((Object)((PianoNoteView)comps[i]), selectionType);
            this.fireSelectionEvent((SelectionEvent<PianoNoteView>)selectionEvent);
        }
        this.canvas.marquee.setSize(1, 1);
        this.canvas.marquee.setLocation(-1, -1);
    }

    public void fireSelectionEvent(SelectionEvent<PianoNoteView> se) {
        for (SelectionListener<PianoNoteView> listener : this.listeners) {
            listener.selectionPerformed(se);
        }
    }

    public void addSelectionListener(SelectionListener<PianoNoteView> sl) {
        this.listeners.add(sl);
    }

    public void removeSelectionListener(SelectionListener<PianoNoteView> sl) {
        this.listeners.remove(sl);
    }
}

