/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask.probability;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.TableEditor;
import blue.soundObject.jmask.probability.Gaussian;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GaussianEditor
extends JPanel
implements DurationSettable {
    private Gaussian gaussian = null;
    private ButtonGroup aButtonGroup;
    private ButtonGroup bButtonGroup;
    private JComboBox meanTypeComboBox;
    private JSpinner muSpinner;
    private TableEditor muTableEditor;
    private JSpinner sigmaSpinner;
    private TableEditor sigmaTableEditor;
    private JComboBox sigmaTypeComboBox;

    public GaussianEditor(Gaussian gaussian) {
        this.initComponents();
        this.sigmaTableEditor.setMinMaxEnabled(false);
        this.muTableEditor.setMinMaxEnabled(false);
        this.sigmaTableEditor.setTable(gaussian.getSigmaTable());
        this.muTableEditor.setTable(gaussian.getMuTable());
        this.sigmaSpinner.setModel(new SpinnerNumberModel(gaussian.getSigma(), 0.0, 1.0, 0.1));
        this.muSpinner.setModel(new SpinnerNumberModel(gaussian.getMu(), 0.0, 1.0, 0.1));
        this.sigmaTypeComboBox.setSelectedIndex(gaussian.isSigmaTableEnabled() ? 1 : 0);
        this.meanTypeComboBox.setSelectedIndex(gaussian.isMuTableEnabled() ? 1 : 0);
        this.gaussian = gaussian;
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.sigmaSpinner.setVisible(!this.gaussian.isSigmaTableEnabled());
        this.sigmaTableEditor.setVisible(this.gaussian.isSigmaTableEnabled());
        this.muSpinner.setVisible(!this.gaussian.isMuTableEnabled());
        this.muTableEditor.setVisible(this.gaussian.isMuTableEnabled());
    }

    private void initComponents() {
        this.aButtonGroup = new ButtonGroup();
        this.bButtonGroup = new ButtonGroup();
        this.sigmaSpinner = new JSpinner();
        this.sigmaTableEditor = new TableEditor();
        this.muSpinner = new JSpinner();
        this.muTableEditor = new TableEditor();
        this.sigmaTypeComboBox = new JComboBox();
        this.meanTypeComboBox = new JComboBox();
        this.sigmaSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GaussianEditor.this.sigmaSpinnerStateChanged(evt);
            }
        });
        this.muSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GaussianEditor.this.muSpinnerStateChanged(evt);
            }
        });
        this.sigmaTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Standard Deviation/sigma (Constant)", "Standard Deviation/sigma (Table)"}));
        this.sigmaTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GaussianEditor.this.sigmaTypeComboBoxActionPerformed(evt);
            }
        });
        this.meanTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Mean/mu (Constant)", "Mean/mu (Table)"}));
        this.meanTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GaussianEditor.this.meanTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.meanTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.muSpinner, -2, 84, -2)).addGroup(layout.createSequentialGroup().addComponent(this.sigmaTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sigmaSpinner, -2, 84, -2)).addComponent(this.sigmaTableEditor, -2, 414, Short.MAX_VALUE).addComponent(this.muTableEditor, -2, 414, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.meanTypeComboBox, this.sigmaTypeComboBox);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sigmaTypeComboBox, -2, -1, -2).addComponent(this.sigmaSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sigmaTableEditor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.meanTypeComboBox, -2, -1, -2).addComponent(this.muSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.muTableEditor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void sigmaSpinnerStateChanged(ChangeEvent evt) {
        if (this.gaussian != null) {
            this.gaussian.setSigma(((Double)this.sigmaSpinner.getValue()).doubleValue());
        }
    }

    private void muSpinnerStateChanged(ChangeEvent evt) {
        if (this.gaussian != null) {
            this.gaussian.setMu(((Double)this.muSpinner.getValue()).doubleValue());
        }
    }

    private void sigmaTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.gaussian != null) {
            this.gaussian.setSigmaTableEnabled(this.sigmaTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    private void meanTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.gaussian != null) {
            this.gaussian.setMuTableEnabled(this.meanTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    @Override
    public void setDuration(double duration) {
        this.muTableEditor.setDuration(duration);
        this.sigmaTableEditor.setDuration(duration);
    }
}

