/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.Arrangement;
import blue.BlueData;
import blue.BlueSystem;
import blue.CompileData;
import blue.GlobalOrcSco;
import blue.Tables;
import blue.gui.InfoDialog;
import blue.projects.BlueProjectManager;
import blue.score.ScoreObject;
import blue.soundObject.NoteList;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.udo.OpcodeList;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.openide.util.Exceptions;

public class PolyObjectEditor
extends ScoreObjectEditor {
    PolyObject pObj;
    SoundObjectTableModel sObjTableModel = new SoundObjectTableModel();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel pObjLabel = new JLabel();
    JSplitPane mainSplitPane = new JSplitPane();
    JScrollPane sObjScrollPane = new JScrollPane();
    JTable sObjTable = new JTable();
    JPanel sObjPropPanel = new JPanel();
    MimeTypeEditorComponent sObjScoreDisplay = new MimeTypeEditorComponent("text/x-csound-sco");
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel topPanel = new JPanel();
    JLabel nameLabel = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    JLabel sObjScoreLabel = new JLabel();
    JLabel typeText = new JLabel();
    JLabel typeLabel = new JLabel();
    JLabel nameText = new JLabel();
    List<SoundObject> sObjects;
    JButton testButton = new JButton();

    public PolyObjectEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setLayout(this.borderLayout1);
        this.pObjLabel.setText(BlueSystem.getString((String)"polyObject.browser"));
        this.sObjScrollPane.setBorder(null);
        this.sObjScrollPane.setMinimumSize(new Dimension(0, 0));
        this.sObjTable.setModel(this.sObjTableModel);
        this.sObjScoreDisplay.setText(BlueSystem.getString((String)"polyObject.selectToDisplay"));
        this.sObjScoreDisplay.getJEditorPane().setEditable(false);
        this.sObjPropPanel.setLayout(this.borderLayout2);
        this.sObjPropPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.nameLabel.setToolTipText("");
        this.nameLabel.setText(BlueSystem.getString((String)"soundObjectProperties.name"));
        this.topPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(3);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setVgap(3);
        this.sObjScoreLabel.setText(BlueSystem.getString((String)"polyObject.sObjScore"));
        this.sObjScoreLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.typeLabel.setText(BlueSystem.getString((String)"common.typeLabel"));
        JPanel headerPanel = new JPanel();
        this.testButton.setText(BlueSystem.getString((String)"common.test"));
        this.testButton.addActionListener(e -> this.testSoundObject());
        headerPanel.setLayout(new BorderLayout());
        headerPanel.add((Component)this.pObjLabel, "Center");
        headerPanel.add((Component)this.testButton, "East");
        this.add((Component)headerPanel, "North");
        this.add((Component)this.mainSplitPane, "Center");
        this.mainSplitPane.add((Component)this.sObjScrollPane, "left");
        this.mainSplitPane.add((Component)this.sObjPropPanel, "right");
        this.sObjPropPanel.add((Component)this.sObjScoreDisplay, "Center");
        this.sObjPropPanel.add((Component)this.topPanel, "North");
        this.topPanel.add((Component)this.nameLabel, null);
        this.topPanel.add((Component)this.nameText, null);
        this.topPanel.add((Component)this.typeLabel, null);
        this.topPanel.add((Component)this.typeText, null);
        this.topPanel.add((Component)this.sObjScoreLabel, null);
        this.sObjScrollPane.getViewport().add((Component)this.sObjTable, null);
        this.mainSplitPane.setDividerLocation(300);
        this.sObjTable.getSelectionModel().addListSelectionListener(e -> {
            if (this.pObj == null || e.getValueIsAdjusting()) {
                return;
            }
            int index = this.sObjTable.getSelectedRow();
            if (index != -1) {
                this.populate(this.sObjects.get(index));
            }
        });
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            System.err.println("[PolyObjectEditor::editSoundObject()] ERROR: not an instance of polyObject");
            this.pObj = null;
            this.sObjTableModel.setSoundObjects(null);
            return;
        }
        if (!sObj.getClass().getName().equals("blue.soundObject.PolyObject")) {
            System.err.println("[PolyObjectEditor::editSoundObject()] ERROR: not an instance of polyObject");
            this.pObj = null;
            this.sObjTableModel.setSoundObjects(null);
            return;
        }
        this.pObj = (PolyObject)sObj;
        this.sObjects = this.pObj.getSoundObjects(true);
        this.sObjTableModel.setSoundObjects(this.sObjects);
        this.clear();
    }

    public void populate(SoundObject sObj) {
        this.nameLabel.setText(BlueSystem.getString((String)"soundObjectProperties.name") + " " + sObj.getName());
        this.typeLabel.setText(BlueSystem.getString((String)"common.typeLabel") + " " + sObj.getClass().getName());
        String scoreText = "";
        try {
            scoreText = sObj.generateForCSD(CompileData.createEmptyCompileData(), 0.0, -1.0).toString();
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        this.sObjScoreDisplay.setText(scoreText);
    }

    public void clear() {
        this.nameLabel.setText(BlueSystem.getString((String)"soundObjectProperties.name") + " ");
        this.typeLabel.setText(BlueSystem.getString((String)"common.typeLabel") + " ");
        this.sObjScoreDisplay.setText("");
    }

    public final void testSoundObject() {
        if (this.pObj == null) {
            return;
        }
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        if (data == null) {
            System.err.println("PolyObjectEditor::testSoundObject() - Could not get reference to current BlueData object");
            return;
        }
        Tables tables = new Tables(data.getTableSet());
        Arrangement arrangement = new Arrangement(data.getArrangement());
        PolyObject tempPObj = new PolyObject(this.pObj);
        OpcodeList opcodeList = new OpcodeList(data.getOpcodeList());
        GlobalOrcSco globalOrcSco = new GlobalOrcSco(data.getGlobalOrcSco());
        arrangement.generateFTables(tables);
        CompileData compileData = new CompileData(arrangement, tables);
        NoteList generatedNotes = null;
        try {
            generatedNotes = tempPObj.generateForCSD(compileData, 0.0, -1.0);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return;
        }
        if (generatedNotes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), generatedNotes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }

    static class SoundObjectTableModel
    extends AbstractTableModel {
        List<SoundObject> sObjects;

        public void setSoundObjects(List<SoundObject> sObjects) {
            if (this.sObjects != null) {
                this.fireTableRowsDeleted(0, sObjects.size());
            }
            this.sObjects = sObjects;
            if (this.sObjects != null) {
                this.fireTableRowsInserted(0, sObjects.size());
            }
        }

        @Override
        public String getColumnName(int i) {
            if (i == 0) {
                return BlueSystem.getString((String)"polyObject.soundObject");
            }
            if (i == 1) {
                return BlueSystem.getString((String)"polyObject.startTime");
            }
            if (i == 2) {
                return BlueSystem.getString((String)"polyObject.duration");
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int parm1, int parm2) {
            if (this.sObjects == null) {
                return null;
            }
            SoundObject temp = this.sObjects.get(parm1);
            if (parm2 == 0) {
                return temp.getName();
            }
            if (parm2 == 1) {
                return new Float(temp.getStartTime());
            }
            if (parm2 == 2) {
                return new Float(temp.getObjectiveDuration());
            }
            System.err.println("error in OrchestraTableModel");
            return null;
        }

        @Override
        public int getRowCount() {
            if (this.sObjects == null) {
                return 0;
            }
            return this.sObjects.size();
        }
    }
}

