/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.gui.MyScrollPaneLayout;
import blue.gui.ScrollerButton;
import blue.score.ScoreObject;
import blue.soundObject.NoteList;
import blue.soundObject.PianoRoll;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.soundObject.editor.pianoRoll.NotePropertiesEditor;
import blue.soundObject.editor.pianoRoll.PianoRollCanvas;
import blue.soundObject.editor.pianoRoll.PianoRollCanvasHeader;
import blue.soundObject.editor.pianoRoll.PianoRollPropertiesEditor;
import blue.soundObject.editor.pianoRoll.TimeBar;
import blue.soundObject.editor.pianoRoll.TimelinePropertiesPanel;
import blue.ui.components.IconFactory;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class PianoRollEditor
extends ScoreObjectEditor
implements PropertyChangeListener,
ActionListener {
    PianoRollPropertiesEditor props = new PianoRollPropertiesEditor();
    PianoRollCanvas noteCanvas = new PianoRollCanvas();
    PianoRollCanvasHeader noteHeader = new PianoRollCanvasHeader();
    TimeBar timeBar = new TimeBar();
    TimelinePropertiesPanel timeProperties = new TimelinePropertiesPanel();
    NotePropertiesEditor noteTemplateEditor = new NotePropertiesEditor();
    JScrollPane noteScrollPane;
    JToggleButton snapButton = new JToggleButton();
    private PianoRoll p;

    public PianoRollEditor() {
        this.snapButton.setIcon(IconFactory.getLeftArrowIcon());
        this.snapButton.setSelectedIcon(IconFactory.getRightArrowIcon());
        this.snapButton.setFocusable(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.noteScrollPane = new JScrollPane();
        this.noteScrollPane.setViewportView(this.noteCanvas);
        this.noteScrollPane.setRowHeaderView(this.noteHeader);
        this.noteScrollPane.setColumnHeaderView(this.timeBar);
        this.noteScrollPane.setCorner("UPPER_RIGHT_CORNER", this.snapButton);
        this.noteScrollPane.setAutoscrolls(true);
        this.setupNoteScrollBars(this.noteScrollPane);
        this.timeProperties.setVisible(false);
        this.timeProperties.setPreferredSize(new Dimension(150, 40));
        this.noteCanvas.addSelectionListener(this.noteTemplateEditor);
        this.noteCanvas.addSelectionListener(this.noteHeader);
        JButton testButton = new JButton("Test");
        testButton.addActionListener(evt -> this.generateTest());
        JTabbedPane tabs = new JTabbedPane();
        JPanel notesPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.noteTemplateEditor, "Center");
        topPanel.add((Component)testButton, "East");
        notesPanel.add((Component)topPanel, "North");
        notesPanel.add((Component)this.noteScrollPane, "Center");
        notesPanel.add((Component)this.timeProperties, "East");
        tabs.add(BlueSystem.getString((String)"pianoRoll.notes"), notesPanel);
        tabs.add(BlueSystem.getString((String)"common.properties"), this.props);
        this.props.setNoteBuffer(this.noteCanvas.noteBuffer);
        this.add((Component)tabs, "Center");
        this.centerNoteScrollPane();
        this.snapButton.addActionListener(e -> this.timeProperties.setVisible(!this.timeProperties.isVisible()));
        this.noteCanvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = new Dimension(e.getComponent().getWidth(), 20);
                PianoRollEditor.this.timeBar.setSize(d);
                PianoRollEditor.this.timeBar.setPreferredSize(d);
                PianoRollEditor.this.timeBar.repaint();
            }
        });
        this.noteScrollPane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PianoRollEditor.this.noteCanvas.recalculateSize();
            }
        });
    }

    protected void generateTest() {
        if (this.p == null) {
            return;
        }
        NoteList notes = null;
        try {
            notes = this.p.generateForCSD(null, 0.0, -1.0);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog(SwingUtilities.getRoot(this), e);
        }
        if (notes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), notes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }

    private void setupNoteScrollBars(JScrollPane noteSP) {
        JPanel horizontalViewChanger = new JPanel(new GridLayout(1, 2));
        ScrollerButton plusHorz = new ScrollerButton("+");
        ScrollerButton minusHorz = new ScrollerButton("-");
        plusHorz.setActionCommand("plusHorizontal");
        minusHorz.setActionCommand("minusHorizontal");
        horizontalViewChanger.add(plusHorz);
        horizontalViewChanger.add(minusHorz);
        JPanel verticalViewChanger = new JPanel(new GridLayout(2, 1));
        ScrollerButton plusVert = new ScrollerButton("+");
        ScrollerButton minusVert = new ScrollerButton("-");
        plusVert.setActionCommand("plusVertical");
        minusVert.setActionCommand("minusVertical");
        verticalViewChanger.add(plusVert);
        verticalViewChanger.add(minusVert);
        plusHorz.addActionListener(this);
        minusHorz.addActionListener(this);
        plusVert.addActionListener(this);
        minusVert.addActionListener(this);
        noteSP.setHorizontalScrollBarPolicy(32);
        noteSP.setVerticalScrollBarPolicy(22);
        noteSP.setLayout(new MyScrollPaneLayout());
        noteSP.add((Component)horizontalViewChanger, "HorizontalRight");
        noteSP.add((Component)verticalViewChanger, "VerticalBottom");
    }

    private void centerNoteScrollPane() {
        JScrollBar scrollbar = this.noteScrollPane.getVerticalScrollBar();
        int max = scrollbar.getMaximum();
        scrollbar.setValue(max / 32 * 13);
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            return;
        }
        if (!(sObj instanceof PianoRoll)) {
            return;
        }
        PianoRoll p = (PianoRoll)sObj;
        if (this.p != null) {
            this.p.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.p = p;
        this.p.addPropertyChangeListener((PropertyChangeListener)this);
        this.noteCanvas.editPianoRoll(p);
        this.noteHeader.editPianoRoll(p);
        this.timeBar.editPianoRoll(p);
        this.props.editPianoRoll(p);
        this.timeProperties.setPianoRoll(p);
        this.centerNoteScrollPane();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.p && evt.getPropertyName().equals("scale")) {
            this.centerNoteScrollPane();
        }
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        PianoRollEditor pEditor = new PianoRollEditor();
        pEditor.editScoreObject((ScoreObject)new PianoRoll());
        GUI.showComponentAsStandalone((Component)pEditor, (String)"Piano Roll Editor", (boolean)true);
    }

    private void lowerHeight() {
        if (this.p == null) {
            return;
        }
        int noteHeight = this.p.getNoteHeight();
        if (noteHeight > 5) {
            this.p.setNoteHeight(--noteHeight);
        }
    }

    private void raiseHeight() {
        if (this.p == null) {
            return;
        }
        int noteHeight = this.p.getNoteHeight();
        if (noteHeight < 25) {
            this.p.setNoteHeight(++noteHeight);
        }
    }

    private void lowerPixelSecond() {
        if (this.p == null) {
            return;
        }
        int pixelSecond = this.p.getPixelSecond();
        if (pixelSecond <= 2) {
            return;
        }
        this.p.setPixelSecond(pixelSecond -= 2);
    }

    private void raisePixelSecond() {
        if (this.p == null) {
            return;
        }
        int pixelSecond = this.p.getPixelSecond() + 2;
        this.p.setPixelSecond(pixelSecond);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command;
        switch (command = ae.getActionCommand()) {
            case "plusVertical": {
                this.raiseHeight();
                break;
            }
            case "minusVertical": {
                this.lowerHeight();
                break;
            }
            case "plusHorizontal": {
                this.raisePixelSecond();
                break;
            }
            case "minusHorizontal": {
                this.lowerPixelSecond();
            }
        }
    }
}

