/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.CompileData;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.jfx.BlueFX;
import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import blue.orchestra.editor.blueSynthBuilder.BSBInterfaceEditor;
import blue.score.ScoreObject;
import blue.soundObject.NoteList;
import blue.soundObject.ObjectBuilder;
import blue.soundObject.ObjectBuilderRegistry;
import blue.soundObject.SoundObjectException;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.soundObject.editor.objectBuilder.ObjectBuilderCodeEditor;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.concurrent.CountDownLatch;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class ObjectBuilderEditor
extends ScoreObjectEditor {
    private ObjectBuilder objectBuilder;
    private final BSBInterfaceEditor interfaceEditor = new BSBInterfaceEditor(ObjectBuilderRegistry.getBSBObjects(), false);
    private final ObjectBuilderCodeEditor codeEditor = new ObjectBuilderCodeEditor();
    private TextArea commentTextArea;

    public ObjectBuilderEditor() {
        JTabbedPane tabs = new JTabbedPane();
        tabs.add(BlueSystem.getString((String)"instrument.interface"), this.interfaceEditor);
        tabs.add(BlueSystem.getString((String)"instrument.code"), this.codeEditor);
        JPanel topPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("[ Object Builder ]");
        JButton testButton = new JButton(BlueSystem.getString((String)"common.test"));
        testButton.addActionListener(e -> this.testSoundObject());
        topPanel.add((Component)label, "West");
        topPanel.add((Component)testButton, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)tabs, "Center");
        JFXPanel jfxCommentPanel = new JFXPanel();
        CountDownLatch latch = new CountDownLatch(1);
        BlueFX.runOnFXThread(() -> {
            try {
                this.commentTextArea = new TextArea();
                this.commentTextArea.setWrapText(true);
                Scene scene2 = new Scene((Parent)this.commentTextArea);
                BlueFX.style((Scene)scene2);
                jfxCommentPanel.setScene(scene2);
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        tabs.addTab("Comments", (Component)jfxCommentPanel);
        this.initActions();
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actions = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey()), "testSoundObject");
        actions.put("testSoundObject", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectBuilderEditor.this.testSoundObject();
            }
        });
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null || !(sObj instanceof ObjectBuilder)) {
            this.objectBuilder = null;
            System.err.println("[ERROR] ObjectBuilder::editSoundObject - not instance of ObjectBuilder");
            return;
        }
        if (this.objectBuilder != null) {
            ObjectBuilder temp = this.objectBuilder;
            BlueFX.runOnFXThread(() -> temp.commentProperty().unbind());
        }
        this.objectBuilder = (ObjectBuilder)sObj;
        PresetGroup presetGroup = this.objectBuilder.getPresetGroup();
        BSBGraphicInterface graphicInterface = this.objectBuilder.getGraphicInterface();
        this.interfaceEditor.editInterface(graphicInterface, presetGroup);
        this.codeEditor.editObjectBuilder(this.objectBuilder);
        BlueFX.runOnFXThread(() -> {
            this.commentTextArea.setText(this.objectBuilder.getComment());
            this.objectBuilder.commentProperty().bind((ObservableValue)this.commentTextArea.textProperty());
        });
    }

    public final void testSoundObject() {
        if (this.objectBuilder == null) {
            return;
        }
        NoteList notes = null;
        try {
            notes = this.objectBuilder.generateForCSD(CompileData.createEmptyCompileData(), 0.0, -1.0);
        }
        catch (SoundObjectException e) {
            ExceptionDialog.showExceptionDialog(SwingUtilities.getRoot(this), e);
            notes = null;
        }
        if (notes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), notes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        ObjectBuilderEditor objBuilderEditor = new ObjectBuilderEditor();
        objBuilderEditor.editScoreObject((ScoreObject)new ObjectBuilder());
        GUI.showComponentAsStandalone((Component)objBuilderEditor, (String)"ObjectBuilder Editor", (boolean)true);
    }
}

