/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.score.ScoreObject;
import blue.soundObject.GenericScore;
import blue.soundObject.NoteList;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class GenericScoreEditor
extends ScoreObjectEditor {
    GenericScore sObj;
    MimeTypeEditorComponent scoreEditPane = new MimeTypeEditorComponent("text/x-csound-sco");
    JLabel editorLabel = new JLabel();
    JPanel topPanel = new JPanel();
    JButton testButton = new JButton();
    UndoManager undo = new UndoRedo.Manager();

    public GenericScoreEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.scoreEditPane.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (GenericScoreEditor.this.sObj != null) {
                    GenericScoreEditor.this.sObj.setText(GenericScoreEditor.this.scoreEditPane.getText());
                }
            }
        });
        this.initActions();
        this.editorLabel.setText("GenericScore");
        this.testButton.setText(BlueSystem.getString((String)"common.test"));
        this.testButton.addActionListener(e -> this.testSoundObject());
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.editorLabel, "Center");
        this.topPanel.add((Component)this.testButton, "East");
        this.add((Component)this.scoreEditPane, "Center");
        this.add((Component)this.topPanel, "North");
        this.scoreEditPane.getDocument().addUndoableEditListener(this.undo);
        this.scoreEditPane.setUndoManager(this.undo);
        this.undo.setLimit(1000);
    }

    private void initActions() {
        InputMap inputMap = this.scoreEditPane.getInputMap();
        ActionMap actions = this.scoreEditPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey()), "testSoundObject");
        actions.put("testSoundObject", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericScoreEditor.this.testSoundObject();
            }
        });
    }

    @Override
    public final void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            this.sObj = null;
            this.editorLabel.setText("no editor available");
            this.scoreEditPane.setText("null soundObject");
            this.scoreEditPane.getJEditorPane().setEnabled(false);
            return;
        }
        if (!(sObj instanceof GenericScore)) {
            this.sObj = null;
            this.editorLabel.setText("no editor available");
            this.scoreEditPane.setText("[ERROR] GenericEditor::editSoundObject - not instance of GenericEditable");
            this.scoreEditPane.getJEditorPane().setEnabled(false);
            return;
        }
        this.sObj = (GenericScore)sObj;
        this.scoreEditPane.setText(this.sObj.getText());
        this.scoreEditPane.getJEditorPane().setEnabled(true);
        this.scoreEditPane.getJEditorPane().setCaretPosition(0);
        this.undo.discardAllEdits();
    }

    public final void testSoundObject() {
        if (this.sObj == null) {
            return;
        }
        NoteList notes = null;
        try {
            notes = this.sObj.generateForCSD(null, 0.0, -1.0);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog(SwingUtilities.getRoot(this), e);
        }
        if (notes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), notes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }
}

