/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.score.ScoreObject;
import blue.soundObject.Comment;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class CommentEditor
extends ScoreObjectEditor {
    Comment sObj;
    MimeTypeEditorComponent scoreEditPane = new MimeTypeEditorComponent("text/plain");
    JLabel editorLabel = new JLabel();
    JPanel topPanel = new JPanel();
    UndoManager undo = new UndoRedo.Manager();

    public CommentEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.scoreEditPane.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (CommentEditor.this.sObj != null) {
                    CommentEditor.this.sObj.setText(CommentEditor.this.scoreEditPane.getText());
                }
            }
        });
        this.editorLabel.setText("Comment");
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.editorLabel, "Center");
        this.add((Component)this.scoreEditPane, "Center");
        this.add((Component)this.topPanel, "North");
        this.scoreEditPane.getDocument().addUndoableEditListener(this.undo);
        this.scoreEditPane.setUndoManager(this.undo);
        this.undo.setLimit(1000);
    }

    @Override
    public final void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            this.sObj = null;
            this.editorLabel.setText("no editor available");
            this.scoreEditPane.setText("null soundObject");
            this.scoreEditPane.getJEditorPane().setEnabled(false);
            return;
        }
        if (!(sObj instanceof Comment)) {
            this.sObj = null;
            this.editorLabel.setText("no editor available");
            this.scoreEditPane.setText("[ERROR] GenericEditor::editSoundObject - not instance of GenericEditable");
            this.scoreEditPane.getJEditorPane().setEnabled(false);
            return;
        }
        this.sObj = (Comment)sObj;
        this.scoreEditPane.setText(this.sObj.getText());
        this.scoreEditPane.getJEditorPane().setEnabled(true);
        this.scoreEditPane.getJEditorPane().setCaretPosition(0);
        this.undo.discardAllEdits();
    }
}

