/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.BlueSystem;
import blue.jfx.BlueFX;
import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.BSBGroup;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.BSBObjectEntry;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import blue.orchestra.editor.blueSynthBuilder.BSBGroupItem;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBEditPane;
import blue.orchestra.editor.blueSynthBuilder.jfx.PresetPane;
import blue.orchestra.editor.blueSynthBuilder.jfx.editors.BSBPropertyEditorFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.controlsfx.control.BreadCrumbBar;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.BeanPropertyUtils;
import org.openide.util.Exceptions;

public class BSBInterfaceEditor
extends JComponent {
    private BSBEditPane bsbEditPane = null;
    private TabPane rightPane;
    private PresetPane presetPane;
    private CheckBox editEnabledCheckBox;
    private PropertySheet bsbObjPropSheet;
    private PropertySheet gridPropSheet;
    private BSBGraphicInterface gInterface;
    private double dividerPosition = 0.8;

    public BSBInterfaceEditor(BSBObjectEntry[] bsbObjectEntries, boolean showAutomatable) {
        JFXPanel jfxPanel = new JFXPanel();
        CountDownLatch latch = new CountDownLatch(1);
        BlueFX.runOnFXThread(() -> {
            try {
                this.bsbObjPropSheet = new PropertySheet();
                this.bsbObjPropSheet.setSearchBoxVisible(false);
                this.bsbObjPropSheet.setModeSwitcherVisible(false);
                this.bsbObjPropSheet.setPropertyEditorFactory((Callback)new BSBPropertyEditorFactory());
                this.gridPropSheet = new PropertySheet();
                this.gridPropSheet.setSearchBoxVisible(false);
                this.gridPropSheet.setModeSwitcherVisible(false);
                Tab bsbObjPropTab = new Tab("BSBObject Properties", (Node)this.bsbObjPropSheet);
                bsbObjPropTab.setClosable(false);
                Tab gridTab = new Tab("Grid", (Node)this.gridPropSheet);
                gridTab.setClosable(false);
                this.rightPane = new TabPane(new Tab[]{bsbObjPropTab, gridTab});
                this.rightPane.setPrefWidth(250.0);
                this.bsbEditPane = new BSBEditPane(bsbObjectEntries);
                ScrollPane scrollPane = new ScrollPane((Node)this.bsbEditPane);
                this.bsbEditPane.getSelection().selection.addListener(se -> {
                    if (!this.bsbEditPane.isMarqueeSelecting()) {
                        this.updateBsbObjPropSheet();
                    }
                });
                this.bsbEditPane.marqueeSelectingProperty().addListener((obs, old, newVal) -> {
                    if (!newVal.booleanValue()) {
                        this.updateBsbObjPropSheet();
                    }
                });
                scrollPane.viewportBoundsProperty().addListener((obs, old, newVal) -> {
                    this.bsbEditPane.setMinWidth(newVal.getWidth());
                    this.bsbEditPane.setMinHeight(newVal.getHeight());
                });
                scrollPane.getStyleClass().add((Object)"edge-to-edge");
                this.presetPane = new PresetPane();
                this.editEnabledCheckBox = new CheckBox("Edit Enabled");
                PresetPane.setMargin((Node)this.editEnabledCheckBox, (Insets)new Insets(5.0, 5.0, 5.0, 0.0));
                this.presetPane.getChildren().add((Object)this.editEnabledCheckBox);
                BreadCrumbBar breadCrumbBar = new BreadCrumbBar();
                breadCrumbBar.setAutoNavigationEnabled(false);
                this.bsbEditPane.getGroupsList().addListener(c -> {
                    ObservableList<BSBGroup> groupsList = this.bsbEditPane.getGroupsList();
                    if (groupsList.size() > 0) {
                        TreeItem current = new TreeItem((Object)new BSBGroupItem((BSBGroup)groupsList.get(0), "Root"));
                        for (int i = 1; i < groupsList.size(); ++i) {
                            BSBGroup bsbGroup = (BSBGroup)groupsList.get(i);
                            TreeItem next = new TreeItem((Object)new BSBGroupItem(bsbGroup, bsbGroup.getGroupName()));
                            current.getChildren().add((Object)next);
                            current = next;
                        }
                        breadCrumbBar.setSelectedCrumb(current);
                    }
                });
                breadCrumbBar.setOnCrumbAction(item -> {
                    BSBGroupItem groupItem = (BSBGroupItem)item.getSelectedCrumb().getValue();
                    ObservableList<BSBGroup> groups = this.bsbEditPane.getGroupsList();
                    int index = groups.indexOf((Object)groupItem.bsbGroup) + 1;
                    if (index < groups.size()) {
                        groups.remove(index, groups.size());
                    }
                });
                VBox topBox = new VBox();
                topBox.getChildren().addAll((Object[])new Node[]{this.presetPane, breadCrumbBar});
                SplitPane editAreaPane = new SplitPane(new Node[]{scrollPane});
                BorderPane mainPane = new BorderPane();
                mainPane.setTop((Node)topBox);
                mainPane.setCenter((Node)editAreaPane);
                Scene scene = new Scene((Parent)mainPane);
                BlueFX.style((Scene)scene);
                jfxPanel.setScene(scene);
                this.editEnabledCheckBox.selectedProperty().addListener((obs, old, newVal) -> {
                    ObservableList items = editAreaPane.getItems();
                    if (newVal.booleanValue()) {
                        if (!items.contains((Object)this.rightPane)) {
                            items.add((Object)this.rightPane);
                            editAreaPane.setDividerPosition(0, this.dividerPosition);
                        }
                        if (!topBox.getChildren().contains((Object)breadCrumbBar)) {
                            topBox.getChildren().add((Object)breadCrumbBar);
                        }
                    } else {
                        if (items.contains((Object)this.rightPane)) {
                            this.dividerPosition = editAreaPane.getDividerPositions()[0];
                            items.remove((Object)this.rightPane);
                        }
                        if (topBox.getChildren().contains((Object)breadCrumbBar)) {
                            topBox.getChildren().remove((Object)breadCrumbBar);
                        }
                    }
                });
                this.bsbEditPane.requestFocus();
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)jfxPanel, "Center");
        this.initActions();
    }

    private void initActions() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(69, BlueSystem.getMenuShortcutKey()), "switchEditMode");
        this.getActionMap().put("switchEditMode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlueFX.runOnFXThread(() -> {
                    if (BSBInterfaceEditor.this.gInterface != null) {
                        BSBInterfaceEditor.this.gInterface.setEditEnabled(!BSBInterfaceEditor.this.gInterface.isEditEnabled());
                    }
                });
            }
        });
    }

    public void editInterface(BSBGraphicInterface gInterface, PresetGroup pGroup) {
        BlueFX.runOnFXThread(() -> {
            if (this.gInterface == gInterface) {
                return;
            }
            if (this.gInterface != null) {
                this.editEnabledCheckBox.selectedProperty().unbindBidirectional((Property)this.gInterface.editEnabledProperty());
                this.rightPane.visibleProperty().unbind();
            }
            this.gInterface = gInterface;
            this.gridPropSheet.getItems().clear();
            this.bsbObjPropSheet.getItems().clear();
            if (gInterface != null) {
                this.editEnabledCheckBox.selectedProperty().bindBidirectional((Property)this.gInterface.editEnabledProperty());
                this.rightPane.visibleProperty().bind((ObservableValue)this.gInterface.editEnabledProperty());
                this.gridPropSheet.getItems().addAll((Collection)BeanPropertyUtils.getProperties((Object)this.gInterface.getGridSettings()));
            }
            this.bsbEditPane.editBSBGraphicInterface(gInterface);
            this.presetPane.setBSBInterface(gInterface);
            this.presetPane.setPresetGroup(pGroup);
            this.editEnabledCheckBox.setDisable(gInterface == null);
        });
    }

    private void updateBsbObjPropSheet() {
        ObservableSet<BSBObject> set = this.bsbEditPane.getSelection().selection;
        this.bsbObjPropSheet.getItems().clear();
        if (set.size() == 1) {
            this.bsbObjPropSheet.getItems().addAll((Collection)BeanPropertyUtils.getProperties(set.iterator().next()));
        }
    }
}

