/*
 * Decompiled with CFR 0.152.
 */
package blue.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.TreeSet;
import javax.swing.Timer;

public class TimedKeyListener
implements KeyListener,
ActionListener {
    private final TreeSet<Integer> set = new TreeSet();
    private final Timer timer;
    private KeyEvent releaseEvent;
    private boolean gameModus = false;

    private void fireKeyReleased(KeyEvent e) {
        if (this.set.remove(new Integer(e.getKeyCode()))) {
            this.KeyReleased(e);
        }
    }

    public TimedKeyListener() {
        this(false);
    }

    public TimedKeyListener(boolean gameModus) {
        this.gameModus = gameModus;
        this.timer = new Timer(0, this);
    }

    public void KeyPressed(KeyEvent e) {
    }

    public void KeyReleased(KeyEvent e) {
    }

    public void KeyTyped(KeyEvent e) {
    }

    public int getPressedCount() {
        return this.set.size();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        } else if (this.set.add(new Integer(e.getKeyCode())) && this.gameModus) {
            this.KeyPressed(e);
            return;
        }
        if (!this.gameModus) {
            this.KeyPressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.fireKeyReleased(e);
        } else {
            this.releaseEvent = e;
            this.timer.restart();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.KeyTyped(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.timer.stop();
        this.fireKeyReleased(this.releaseEvent);
    }
}

