/*
 * Decompiled with CFR 0.152.
 */
package blue.gui;

import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.openide.util.ImageUtilities;

class FileListCellRenderer
extends JLabel
implements ListCellRenderer<File> {
    private static ImageIcon dirIcon = new ImageIcon(ImageUtilities.loadImage((String)"blue/resources/images/Directory.gif"));
    private File selectedDir;

    public FileListCellRenderer() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void setSelectedDir(File dir) {
        this.selectedDir = dir;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends File> list, File f, int index, boolean isSelected, boolean hasCellFocus) {
        File parentDir = this.selectedDir.getParentFile();
        if (f == this.selectedDir) {
            this.setText(".");
        } else if (this.selectedDir != null && parentDir != null && f.toString().equals(parentDir.toString())) {
            this.setText("..");
        } else {
            this.setText(f.getName());
        }
        if (f.isDirectory()) {
            this.setIcon(dirIcon);
        } else {
            this.setIcon(null);
        }
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        return this;
    }
}

