/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.score.ScoreObjectEvent;
import blue.score.ScoreObjectListener;
import blue.score.TimeState;
import blue.score.layers.audio.core.AudioClip;
import blue.score.layers.audio.core.FadeType;
import blue.score.layers.audio.ui.FadeHandle;
import blue.score.layers.audio.ui.FadeRenderer;
import blue.score.layers.audio.ui.FadeTypePopup;
import blue.ui.core.score.ScoreObjectView;
import blue.ui.core.score.ScoreTopComponent;
import blue.ui.utilities.BlueGradientFactory;
import blue.ui.utilities.RedispatchMouseAdapter;
import blue.ui.utilities.audio.AudioWaveformCache;
import blue.ui.utilities.audio.AudioWaveformData;
import blue.ui.utilities.audio.AudioWaveformListener;
import blue.ui.utilities.audio.AudioWaveformUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.function.BiConsumer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.WindowManager;

public class AudioClipPanel
extends JPanel
implements PropertyChangeListener,
ScoreObjectListener,
ScoreObjectView<AudioClip>,
LookupListener,
ChangeListener<Number> {
    protected static final AudioWaveformCache waveformCache = AudioWaveformCache.getInstance();
    private final AudioClip audioClip;
    private final TimeState timeState;
    boolean selected = false;
    boolean showFadeHandles = false;
    protected static Color selectedBgColor = new Color(255, 255, 255, 128);
    protected static Color selectedBorder1 = selectedBgColor.brighter().brighter();
    protected static Color selectedBorder2 = selectedBgColor.darker().darker();
    protected static Color selectedFontColor = Color.black;
    protected static Color fadeLightColor = new Color(255, 255, 255, 64);
    protected static Color fadeDarkColor = new Color(0, 0, 0, 64);
    Lookup.Result<AudioClip> result = null;
    AudioWaveformData waveData = null;
    private final FadeHandle leftFadeHandle;
    private final FadeHandle rightFadeHandle;
    private final BiConsumer<AudioClip, Double> splitHandler;
    ChangeListener<Number> fadeListener = (obs, o, n) -> {
        this.updateFadeHandleLocations();
        this.repaint();
    };
    ChangeListener<FadeType> fadeTypeListener = (obs, o, n) -> this.repaint();
    MouseAdapter releaseOutsideAdapter = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), AudioClipPanel.this);
            if (!AudioClipPanel.this.contains(p)) {
                AudioClipPanel.this.leftFadeHandle.setVisible(false);
                AudioClipPanel.this.rightFadeHandle.setVisible(false);
            }
        }
    };
    MouseAdapter mouseAdapter = new RedispatchMouseAdapter(){
        boolean active = false;
        int startX = 0;
        private double initialStartTime = 0.0;

        public void mouseEntered(MouseEvent e) {
            Color bgColor;
            bgColor = AudioClipPanel.this.selected ? selectedFontColor : (AudioClipPanel.this.isBright(bgColor = AudioClipPanel.this.audioClip.getBackgroundColor()) ? Color.BLACK : Color.WHITE);
            AudioClipPanel.this.leftFadeHandle.setBackground(bgColor);
            AudioClipPanel.this.rightFadeHandle.setBackground(bgColor);
            AudioClipPanel.this.leftFadeHandle.setVisible(true);
            AudioClipPanel.this.rightFadeHandle.setVisible(true);
        }

        public void mouseExited(MouseEvent e) {
            if (!(AudioClipPanel.this.leftFadeHandle.isAdjustingFade() || AudioClipPanel.this.leftFadeHandle.contains(SwingUtilities.convertPoint(AudioClipPanel.this, e.getPoint(), AudioClipPanel.this.leftFadeHandle)) || AudioClipPanel.this.rightFadeHandle.isAdjustingFade() || AudioClipPanel.this.rightFadeHandle.contains(SwingUtilities.convertPoint(AudioClipPanel.this, e.getPoint(), AudioClipPanel.this.rightFadeHandle)))) {
                AudioClipPanel.this.leftFadeHandle.setVisible(false);
                AudioClipPanel.this.rightFadeHandle.setVisible(false);
                Component pane = SwingUtilities.getRootPane(AudioClipPanel.this).getGlassPane();
                pane.setCursor(null);
                pane.setVisible(false);
            }
        }

        public void mouseMoved(MouseEvent e) {
            Component pane = SwingUtilities.getRootPane(AudioClipPanel.this).getGlassPane();
            if (e.isAltDown() && e.isShiftDown()) {
                pane.setCursor(Cursor.getPredefinedCursor(1));
                pane.setVisible(true);
            } else {
                pane.setCursor(null);
                pane.setVisible(false);
            }
            this.redispatchEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.active) {
                int xDiff = e.getX() - this.startX;
                if (xDiff == 0) {
                    AudioClipPanel.this.audioClip.setFileStartTime(this.initialStartTime);
                } else {
                    double newTime = this.initialStartTime - (double)xDiff / (double)AudioClipPanel.this.timeState.getPixelSecond();
                    newTime = Math.max(0.0, newTime);
                    newTime = Math.min(AudioClipPanel.this.audioClip.getAudioDuration() - AudioClipPanel.this.audioClip.getDuration(), newTime);
                    AudioClipPanel.this.audioClip.setFileStartTime(newTime);
                }
                e.consume();
            } else {
                this.redispatchEvent(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.active) {
                e.consume();
                this.active = false;
                this.startX = -1;
                this.initialStartTime = -1.0;
            } else {
                this.redispatchEvent(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                int x = e.getX();
                if (x < AudioClipPanel.this.leftFadeHandle.getX()) {
                    FadeTypePopup popup = FadeTypePopup.getInstance();
                    popup.setup(AudioClipPanel.this.audioClip, true);
                    popup.show(AudioClipPanel.this, x, e.getY());
                } else if (x > AudioClipPanel.this.rightFadeHandle.getX() - AudioClipPanel.this.rightFadeHandle.getWidth()) {
                    FadeTypePopup popup = FadeTypePopup.getInstance();
                    popup.setup(AudioClipPanel.this.audioClip, false);
                    popup.show(AudioClipPanel.this, x, e.getY());
                } else {
                    this.redispatchEvent(e);
                    this.active = false;
                }
            } else if (e.isAltDown()) {
                if (e.isShiftDown()) {
                    double time = (double)e.getX() / (double)AudioClipPanel.this.timeState.getPixelSecond();
                    AudioClipPanel.this.splitHandler.accept(AudioClipPanel.this.audioClip, time);
                } else {
                    this.active = true;
                    this.startX = e.getX();
                    this.initialStartTime = AudioClipPanel.this.audioClip.getFileStartTime();
                }
                e.consume();
            } else {
                this.redispatchEvent(e);
                this.active = false;
            }
        }
    };

    public AudioClipPanel(AudioClip audioClip, TimeState timeState, BiConsumer<AudioClip, Double> splitHandler) {
        this.audioClip = audioClip;
        this.timeState = timeState;
        this.splitHandler = splitHandler;
        this.setOpaque(false);
        this.setBackground(Color.DARK_GRAY);
        this.setForeground(Color.WHITE);
        this.setLayout(null);
        this.leftFadeHandle = new FadeHandle(audioClip, timeState, true);
        this.leftFadeHandle.setSize(5, 5);
        this.leftFadeHandle.setVisible(false);
        this.rightFadeHandle = new FadeHandle(audioClip, timeState, false);
        this.rightFadeHandle.setSize(5, 5);
        this.rightFadeHandle.setVisible(false);
        this.add(this.leftFadeHandle);
        this.add(this.rightFadeHandle);
        this.reset();
        this.updateFadeHandleLocations();
    }

    protected void updateFadeHandleLocations() {
        int leftHandleX = (int)(this.audioClip.getFadeIn() * (double)this.timeState.getPixelSecond());
        int rightHandleX = (int)(this.audioClip.getFadeOut() * (double)this.timeState.getPixelSecond());
        rightHandleX = this.getWidth() - rightHandleX - 5;
        this.leftFadeHandle.setLocation(leftHandleX, 2);
        this.leftFadeHandle.addMouseListener(this.releaseOutsideAdapter);
        this.rightFadeHandle.setLocation(rightHandleX, 2);
        this.rightFadeHandle.addMouseListener(this.releaseOutsideAdapter);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.audioClip.addScoreObjectListener((ScoreObjectListener)this);
        this.audioClip.fileStartTimeProperty().addListener((ChangeListener)this);
        this.audioClip.fadeInProperty().addListener(this.fadeListener);
        this.audioClip.fadeInTypeProperty().addListener(this.fadeTypeListener);
        this.audioClip.fadeOutProperty().addListener(this.fadeListener);
        this.audioClip.fadeOutTypeProperty().addListener(this.fadeTypeListener);
        this.timeState.addPropertyChangeListener((PropertyChangeListener)this);
        ScoreTopComponent scoreTopComponent = (ScoreTopComponent)WindowManager.getDefault().findTopComponent("ScoreTopComponent");
        this.result = scoreTopComponent.getLookup().lookupResult(AudioClip.class);
        this.result.addLookupListener((LookupListener)this);
        Collection soundObjects = this.result.allInstances();
        this.setSelected(soundObjects.contains(this.audioClip));
        this.updateWaveformData();
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void removeNotify() {
        this.audioClip.removeScoreObjectListener((ScoreObjectListener)this);
        this.audioClip.fileStartTimeProperty().removeListener((ChangeListener)this);
        this.audioClip.fadeInProperty().removeListener(this.fadeListener);
        this.audioClip.fadeInTypeProperty().removeListener(this.fadeTypeListener);
        this.audioClip.fadeOutProperty().removeListener(this.fadeListener);
        this.audioClip.fadeOutTypeProperty().removeListener(this.fadeTypeListener);
        this.timeState.removePropertyChangeListener((PropertyChangeListener)this);
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
        this.waveData = null;
        this.removeMouseListener(this.mouseAdapter);
        this.removeMouseMotionListener(this.mouseAdapter);
        super.removeNotify();
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    private boolean isBright(Color c) {
        return c.getRed() + c.getGreen() + c.getBlue() > 384;
    }

    private void paintFade(Graphics g, int xOffset, FadeType fadeType, double fadeTime, boolean fadeIn) {
        int len = (int)(fadeTime * (double)this.timeState.getPixelSecond());
        double dlen = len;
        if (len < 2) {
            return;
        }
        int[] polyX = new int[len + 3];
        int[] polyY = new int[len + 3];
        int h = this.getHeight() - 4;
        if (fadeIn) {
            polyX[len] = xOffset + len;
            polyY[len] = 0;
            polyX[len + 1] = xOffset;
            polyY[len + 1] = 0;
            polyX[len + 2] = xOffset;
            polyY[len + 2] = h;
        } else {
            polyX[len] = xOffset + len;
            polyY[len] = h;
            polyX[len + 1] = xOffset + len;
            polyY[len + 1] = 0;
            polyX[len + 2] = xOffset;
            polyY[len + 2] = 0;
        }
        for (int i = 0; i < len; ++i) {
            double x = (double)i / dlen;
            double fadeY = FadeRenderer.getValue(x, fadeType, fadeIn);
            polyX[i] = i + xOffset;
            polyY[i] = (int)((1.0 - fadeY) * (double)h);
        }
        g.fillPolygon(polyX, polyY, len + 3);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Color waveColor;
        Color fadeColor;
        Color fontColor;
        Color border2;
        Color border1;
        Color bgColor;
        Graphics2D g = (Graphics2D)graphics;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isSelected()) {
            bgColor = selectedBgColor;
            border1 = selectedBorder1;
            border2 = selectedBorder2;
            fontColor = selectedFontColor;
            fadeColor = fadeDarkColor;
            waveColor = bgColor.brighter().brighter();
        } else {
            Color bg = this.audioClip.getBackgroundColor();
            bgColor = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 194);
            border1 = bgColor.brighter().brighter();
            border2 = bgColor.darker().darker();
            fontColor = this.isBright(bgColor) ? Color.BLACK : Color.WHITE;
            fadeColor = this.isBright(bgColor) ? fadeDarkColor : fadeLightColor;
            waveColor = bg;
            waveColor = this.isBright(bg) ? waveColor.darker().darker() : waveColor.brighter().brighter();
        }
        g.setPaint(BlueGradientFactory.getGradientPaint((Color)bgColor));
        g.fillRect(0, 2, w, h - 4);
        g.setColor(waveColor);
        g.translate(1, 2);
        int audioFileStart = (int)(this.audioClip.getFileStartTime() * (double)this.timeState.getPixelSecond());
        AudioWaveformUI.paintWaveForm((Graphics2D)g, (int)(this.getHeight() - 4), (AudioWaveformData)this.waveData, (int)audioFileStart);
        if (this.audioClip.getFadeIn() > 0.0) {
            g.setColor(fadeColor);
            this.paintFade(graphics, 0, this.audioClip.getFadeInType(), this.audioClip.getFadeIn(), true);
        }
        if (this.audioClip.getFadeOut() > 0.0) {
            g.setColor(fadeColor);
            this.paintFade(graphics, this.rightFadeHandle.getX() + 5, this.audioClip.getFadeOutType(), this.audioClip.getFadeOut(), false);
        }
        g.translate(-1, -2);
        g.setColor(fontColor);
        g.drawString(this.audioClip.getName(), 5, 15);
        g.setColor(border1);
        g.drawLine(0, 2, w - 1, 2);
        g.drawLine(0, 2, 0, h - 4);
        g.setColor(border2);
        g.drawLine(0, h - 3, w, h - 3);
        g.drawLine(w - 1, h - 3, w - 1, 2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.timeState) {
            switch (evt.getPropertyName()) {
                case "pixelSecond": {
                    if (this.timeState.getPixelSecond() != this.waveData.pixelSeconds) {
                        this.updateWaveformData();
                    }
                    this.reset();
                }
            }
        }
    }

    private void updateWaveformData() {
        String absFilePath = this.audioClip.getAudioFile().getAbsolutePath();
        this.waveData = waveformCache.getAudioWaveformData(absFilePath, this.timeState.getPixelSecond());
        if (this.waveData.percentLoadingComplete < 1.0) {
            waveformCache.addAudioWaveformListener(new AudioWaveformListener(absFilePath, (JComponent)this));
        }
    }

    protected void reset() {
        int pixelSecond = this.timeState.getPixelSecond();
        double x = this.audioClip.getStartTime() * (double)pixelSecond;
        double width = this.audioClip.getSubjectiveDuration() * (double)pixelSecond;
        this.setBounds((int)x, this.getY(), (int)width, this.getHeight());
        this.updateFadeHandleLocations();
    }

    public AudioClip getScoreObject() {
        return this.audioClip;
    }

    public void resultChanged(LookupEvent ev) {
        Collection soundObjects = this.result.allInstances();
        boolean newSelected = soundObjects.contains(this.audioClip);
        this.setSelected(newSelected);
    }

    public void scoreObjectChanged(ScoreObjectEvent event) {
        if (event.getScoreObject() == this.audioClip) {
            switch (event.getPropertyChanged()) {
                case 1: 
                case 2: {
                    this.reset();
                }
            }
        }
    }

    public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.repaint();
    }
}

