/*
 * Decompiled with CFR 0.152.
 */
package blue.clojure.project;

import blue.clojure.project.ClojureLibraryEntry;
import blue.clojure.project.ClojureProjectData;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;

public class ClojureProjectDataEditorController
implements Initializable {
    @FXML
    TableView<ClojureLibraryEntry> table;
    @FXML
    Button addButton;
    @FXML
    Button removeButton;
    @FXML
    Button pushUpButton;
    @FXML
    Button pushDownButton;
    private ClojureProjectData data = null;

    public void initialize(URL location, ResourceBundle resources) {
        TableView.TableViewSelectionModel model = this.table.getSelectionModel();
        this.pushUpButton.disableProperty().bind((ObservableValue)model.selectedItemProperty().isNull().or((ObservableBooleanValue)model.selectedIndexProperty().isEqualTo(0)));
        this.pushDownButton.disableProperty().bind((ObservableValue)model.selectedItemProperty().isNull());
        this.removeButton.disableProperty().bind((ObservableValue)model.selectedItemProperty().isNull());
        this.table.setEditable(true);
        TableColumn col1 = new TableColumn("Library Coordinates");
        col1.setCellValueFactory((Callback)new PropertyValueFactory("dependencyCoordinates"));
        col1.setCellFactory(TextFieldTableCell.forTableColumn());
        col1.setOnEditCommit(cet -> ((ClojureLibraryEntry)cet.getRowValue()).setDependencyCoordinates((String)cet.getNewValue()));
        col1.setEditable(true);
        col1.setPrefWidth(300.0);
        TableColumn col2 = new TableColumn("Version");
        col2.setCellValueFactory((Callback)new PropertyValueFactory("version"));
        col2.setCellFactory(TextFieldTableCell.forTableColumn());
        col2.setOnEditCommit(cet -> ((ClojureLibraryEntry)cet.getRowValue()).setVersion((String)cet.getNewValue()));
        col2.setEditable(true);
        this.table.getColumns().clear();
        this.table.getColumns().addAll((Object[])new TableColumn[]{col1, col2});
    }

    public void setClojureProjectData(ClojureProjectData data) {
        this.data = data;
        this.table.setItems(data.libraryList());
    }

    @FXML
    public void addEntry() {
        if (this.data == null) {
            return;
        }
        this.data.libraryList().add((Object)new ClojureLibraryEntry());
    }

    @FXML
    public void removeEntry() {
        if (this.data == null) {
            return;
        }
        ClojureLibraryEntry item = (ClojureLibraryEntry)this.table.getSelectionModel().getSelectedItem();
        this.data.libraryList().remove((Object)item);
    }

    @FXML
    public void pushUpEntry() {
        if (this.data == null) {
            return;
        }
        int index = this.table.getSelectionModel().getSelectedIndex();
        ClojureLibraryEntry item = (ClojureLibraryEntry)this.data.libraryList().remove(index);
        this.data.libraryList().add(index - 1, (Object)item);
    }

    @FXML
    public void pushDownEntry() {
        if (this.data == null) {
            return;
        }
        int index = this.table.getSelectionModel().getSelectedIndex();
        ClojureLibraryEntry item = (ClojureLibraryEntry)this.data.libraryList().remove(index);
        this.data.libraryList().add(index + 1, (Object)item);
    }
}

