/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.csound.orc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class OpcodeDocumentation {
    public static URL getOpcodeDocumentationUrl(String opcodeName) {
        File manualDir = InstalledFileLocator.getDefault().locate("csoundManual", "csound-manual", false);
        String filename = manualDir.getAbsolutePath() + "/" + opcodeName + ".html";
        File docFile = new File(filename);
        if (docFile.exists()) {
            try {
                return docFile.toURL();
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    public static String getOpcodeDocumentation(String opcodeName) {
        StringBuffer buffer = new StringBuffer();
        File manualDir = InstalledFileLocator.getDefault().locate("csoundManual", "csound-manual", false);
        String filename = manualDir.getAbsolutePath() + "/" + opcodeName + ".html";
        File docFile = new File(filename);
        if (!(docFile.exists() && docFile.isFile() && docFile.canRead())) {
            return null;
        }
        boolean appending = false;
        String imgDir = "src=\"file://" + manualDir + "/images";
        try (BufferedReader br = new BufferedReader(new FileReader(docFile));){
            String line;
            while ((line = br.readLine().trim()) != null) {
                line = line.replace("src=\"images", imgDir);
                if (appending) {
                    if (line.startsWith("<div class=\"navfooter\">")) {
                        break;
                    }
                    buffer.append(line).append("\n");
                    continue;
                }
                if (line.startsWith("<div class=\"refentry\"")) {
                    buffer.append(line).append("\n");
                    continue;
                }
                if (!line.startsWith("<div class=\"refnamediv\">")) continue;
                appending = true;
                buffer.append(line).append("\n");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return buffer.toString();
    }
}

