/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.blueSynthBuilder;

import blue.ui.editor.blueSynthBuilder.BSBTokenId;
import csound.manual.CsoundManualUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class BSBHLexer
implements Lexer<BSBTokenId> {
    private static final Map<String, BSBTokenId> keywords = new HashMap<String, BSBTokenId>();
    private static final Set<String> opcodeNames = CsoundManualUtilities.getOpcodeNames();
    private static final int EOF = -1;
    private LexerRestartInfo<BSBTokenId> info;
    private LexerInput input;
    TokenFactory<BSBTokenId> tokenFactory;

    private static final void addKeyword(BSBTokenId id) {
        keywords.put(id.getFixedText(), id);
    }

    public BSBHLexer(LexerRestartInfo<BSBTokenId> info) {
        this.info = info;
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
    }

    public Token<BSBTokenId> nextToken() {
        int ch = this.input.read();
        switch (ch) {
            case 34: {
                while (true) {
                    switch (this.input.read()) {
                        case 92: {
                            this.input.read();
                            break;
                        }
                        case 34: {
                            return this.token(BSBTokenId.STRING);
                        }
                        case -1: 
                        case 10: {
                            return this.token(BSBTokenId.ERROR);
                        }
                    }
                }
            }
            case 123: {
                if (this.input.read() == 123) {
                    while (true) {
                        switch (this.input.read()) {
                            case 125: {
                                if (this.input.read() == 125) {
                                    return this.token(BSBTokenId.STRING);
                                }
                                this.input.backup(1);
                                break;
                            }
                            case -1: {
                                return this.token(BSBTokenId.ERROR);
                            }
                        }
                    }
                }
                this.input.backup(1);
                return this.token(BSBTokenId.ERROR);
            }
            case 37: 
            case 42: 
            case 43: 
            case 45: {
                return this.token(BSBTokenId.OPERATOR);
            }
            case 47: {
                switch (this.input.read()) {
                    case 47: {
                        while (true) {
                            switch (this.input.read()) {
                                case 13: {
                                    this.input.consumeNewline();
                                }
                                case -1: 
                                case 10: {
                                    return this.token(BSBTokenId.SL_COMMENT);
                                }
                            }
                        }
                    }
                    case 42: {
                        do {
                            ch = this.input.read();
                            while (ch == 42) {
                                ch = this.input.read();
                                if (ch == 47) {
                                    return this.token(BSBTokenId.ML_COMMENT);
                                }
                                if (ch != -1) continue;
                                return this.token(BSBTokenId.ML_COMMENT_INCOMPLETE);
                            }
                        } while (ch != -1);
                        return this.token(BSBTokenId.ML_COMMENT_INCOMPLETE);
                    }
                }
                this.input.backup(1);
                return this.token(BSBTokenId.OPERATOR);
            }
            case 59: {
                while (true) {
                    switch (this.input.read()) {
                        case 13: {
                            this.input.consumeNewline();
                        }
                        case -1: 
                        case 10: {
                            return this.token(BSBTokenId.SL_COMMENT);
                        }
                    }
                }
            }
            case 40: {
                return this.token(BSBTokenId.LPAREN);
            }
            case 41: {
                return this.token(BSBTokenId.RPAREN);
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.finishIntOrFloatLiteral(ch);
            }
            case -1: {
                return null;
            }
        }
        if (Character.isWhitespace((char)ch)) {
            ch = this.input.read();
            while (ch != -1 && Character.isWhitespace((char)ch)) {
                ch = this.input.read();
            }
            this.input.backup(1);
            return this.token(BSBTokenId.WS);
        }
        if (Character.isLetter((char)ch)) {
            while (true) {
                if (ch == -1 || !Character.isLetter((char)ch) && !Character.isDigit((char)ch) && ch != 95) {
                    this.input.backup(1);
                    CharSequence word = this.input.readText();
                    BSBTokenId id = keywords.get(word);
                    if (id == null) {
                        id = opcodeNames.contains(word) ? BSBTokenId.OPCODE : BSBTokenId.CHAR;
                    }
                    return this.token(id);
                }
                ch = this.input.read();
            }
        }
        return this.token(BSBTokenId.CHAR);
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    private Token<BSBTokenId> finishIntOrFloatLiteral(int ch) {
        boolean floatLiteral = false;
        boolean inExponent = false;
        while (true) {
            switch (ch) {
                case 46: {
                    if (floatLiteral) {
                        return this.token(BSBTokenId.MYFLOAT);
                    }
                    floatLiteral = true;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                case 69: 
                case 101: {
                    if (inExponent) {
                        return this.token(BSBTokenId.MYFLOAT);
                    }
                    floatLiteral = true;
                    inExponent = true;
                    break;
                }
                default: {
                    this.input.backup(1);
                    return this.token(floatLiteral ? BSBTokenId.MYFLOAT : BSBTokenId.INT);
                }
            }
            ch = this.input.read();
        }
    }

    private Token<BSBTokenId> token(BSBTokenId id) {
        return id.getFixedText() != null ? this.tokenFactory.getFlyweightToken((TokenId)id, id.getFixedText()) : this.tokenFactory.createToken((TokenId)id);
    }

    static {
        BSBHLexer.addKeyword(BSBTokenId.INSTR_START);
        BSBHLexer.addKeyword(BSBTokenId.INSTR_END);
        BSBHLexer.addKeyword(BSBTokenId.OPCODE_START);
        BSBHLexer.addKeyword(BSBTokenId.OPCODE_END);
    }
}

