/*
 * Decompiled with CFR 0.152.
 */
package blue.undo;

import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TabWatchingUndoableEditGenerator {
    JTabbedPane jTabbedPane;
    int currentTab;
    private final UndoManager undo;
    private boolean processingUndoRedo = false;

    public TabWatchingUndoableEditGenerator(JTabbedPane tabs, UndoManager undoManager) {
        this.jTabbedPane = tabs;
        this.currentTab = tabs.getSelectedIndex();
        this.undo = undoManager;
        tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!TabWatchingUndoableEditGenerator.this.processingUndoRedo) {
                    TabWatchingUndoableEditGenerator.this.undo.addEdit(new TabSwitchUndoableEdit(TabWatchingUndoableEditGenerator.this.jTabbedPane, TabWatchingUndoableEditGenerator.this.currentTab, TabWatchingUndoableEditGenerator.this.jTabbedPane.getSelectedIndex()));
                    TabWatchingUndoableEditGenerator.this.currentTab = TabWatchingUndoableEditGenerator.this.jTabbedPane.getSelectedIndex();
                }
            }
        });
    }

    class TabSwitchUndoableEdit
    extends AbstractUndoableEdit {
        private final int previousTab;
        private final int nextTab;
        private final JTabbedPane tabs;

        public TabSwitchUndoableEdit(JTabbedPane tabs, int previousTab, int nextTab) {
            this.tabs = tabs;
            this.previousTab = previousTab;
            this.nextTab = nextTab;
        }

        @Override
        public void undo() throws CannotUndoException {
            TabWatchingUndoableEditGenerator.this.processingUndoRedo = true;
            this.tabs.setSelectedIndex(this.previousTab);
            TabWatchingUndoableEditGenerator.this.processingUndoRedo = false;
        }

        @Override
        public void redo() throws CannotRedoException {
            TabWatchingUndoableEditGenerator.this.processingUndoRedo = true;
            this.tabs.setSelectedIndex(this.nextTab);
            TabWatchingUndoableEditGenerator.this.processingUndoRedo = false;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }
    }
}

