/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.tracker;

import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.tracker.Column;
import blue.soundObject.tracker.TrackerNote;
import blue.utility.TextUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class Track
implements TableModel {
    private static final MessageFormat COL_NAME = new MessageFormat("<{0}>");
    public static final String NAME = "name";
    private String name = "track";
    private String noteTemplate = "i <INSTR_ID> <START> <DUR> <pch> <db>";
    private String instrumentId = "1";
    ArrayList<Column> columns = new ArrayList();
    ArrayList<TrackerNote> trackerNotes = new ArrayList();
    private transient Vector listeners = null;
    private transient Vector tableListeners = null;

    public Track() {
        this(true);
    }

    private Track(boolean init) {
        if (init) {
            this.addColumn(new Column.PitchColumn());
            this.addColumn(new Column.AmpColumn());
        }
    }

    public Track(Track track) {
        this.name = track.name;
        this.noteTemplate = track.noteTemplate;
        this.instrumentId = track.instrumentId;
        for (Column col : track.columns) {
            this.addColumn(new Column(col));
        }
        for (TrackerNote n : track.trackerNotes) {
            this.trackerNotes.add(new TrackerNote(n));
        }
    }

    public void resizeSteps(int steps) {
        if (steps < this.trackerNotes.size()) {
            for (int i = this.trackerNotes.size() - 1; i >= steps; --i) {
                this.trackerNotes.remove(i);
            }
        } else {
            int numToAdd = steps - this.trackerNotes.size();
            for (int i = 0; i < numToAdd; ++i) {
                this.trackerNotes.add(this.createNewNote());
            }
        }
    }

    private TrackerNote createNewNote() {
        TrackerNote note = new TrackerNote();
        for (int i = 0; i < this.columns.size(); ++i) {
            note.addColumn();
        }
        return note;
    }

    public Column getColumn(int index) {
        Column retVal = null;
        switch (index) {
            case 0: {
                retVal = null;
            }
        }
        retVal = this.columns.get(index - 1);
        return retVal;
    }

    public int getNumColumns() {
        return 1 + this.columns.size();
    }

    public int getNumSteps() {
        return this.trackerNotes.size();
    }

    public TrackerNote getTrackerNote(int rowIndex) {
        return this.trackerNotes.get(rowIndex);
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange(NAME, oldName, this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getNoteTemplate() {
        return this.noteTemplate;
    }

    public void setNoteTemplate(String noteTemplate) {
        this.noteTemplate = noteTemplate;
    }

    public String getInstrumentId() {
        return this.instrumentId;
    }

    public void setInstrumentId(String instrumentId) {
        this.instrumentId = instrumentId;
    }

    public void pushUpColumn(int index) {
        if (index < 1 || index >= this.columns.size()) {
            return;
        }
        Column obj = this.columns.remove(index - 1);
        this.columns.add(index, obj);
        for (TrackerNote trNote : this.trackerNotes) {
            String val1 = trNote.getValue(index);
            String val2 = trNote.getValue(index + 1);
            trNote.setValue(index, val2);
            trNote.setValue(index + 1, val1);
        }
        this.fireTableDataChanged();
    }

    public void pushDownColumn(int index) {
        if (index < 0 || index > this.columns.size() - 2) {
            return;
        }
        Column obj = this.columns.remove(index + 1);
        this.columns.add(index, obj);
        for (TrackerNote trNote : this.trackerNotes) {
            String val1 = trNote.getValue(index + 1);
            String val2 = trNote.getValue(index + 2);
            trNote.setValue(index + 1, val2);
            trNote.setValue(index + 2, val1);
        }
        this.fireTableDataChanged();
    }

    public void addColumn(Column col) {
        this.columns.add(col);
        for (TrackerNote trNote : this.trackerNotes) {
            trNote.addColumn();
        }
        this.fireTableDataChanged();
    }

    public void removeColumn(Column col) {
        int index = this.columns.indexOf(col);
        if (index < 0) {
            return;
        }
        if (this.columns.contains(col)) {
            for (TrackerNote trNote : this.trackerNotes) {
                trNote.removeColumn(index);
            }
            this.columns.remove(col);
            this.fireTableDataChanged();
        }
    }

    public NoteList generateNotes() throws NoteParseException {
        NoteList retVal = new NoteList();
        String instrId = this.getInstrumentId();
        try {
            Double.parseDouble(instrId);
        }
        catch (NumberFormatException nfe) {
            instrId = "\"" + instrId + "\"";
        }
        String noteTemplate = TextUtilities.replaceAll(this.getNoteTemplate(), "<INSTR_ID>", instrId);
        noteTemplate = TextUtilities.replaceAll(noteTemplate, "<INSTR_NAME>", this.getInstrumentId());
        for (int i = 0; i < this.trackerNotes.size(); ++i) {
            TrackerNote temp;
            TrackerNote trNote = this.trackerNotes.get(i);
            if (!trNote.isActive() || trNote.isOff()) continue;
            String noteStr = noteTemplate;
            int dur = 1;
            for (int j = i + 1; j < this.trackerNotes.size() && !(temp = this.trackerNotes.get(j)).isActive() && !temp.isOff(); ++j) {
                ++dur;
            }
            String durStr = trNote.isTied() ? "-" + dur : Integer.toString(dur);
            noteStr = TextUtilities.replaceAll(noteStr, "<START>", Integer.toString(i));
            noteStr = TextUtilities.replaceAll(noteStr, "<DUR>", durStr);
            Object[] colNameArg = new Object[1];
            for (int j = 1; j < this.getNumColumns(); ++j) {
                Column col = this.getColumn(j);
                colNameArg[0] = col.getName();
                String colNameStr = COL_NAME.format(colNameArg);
                String newValue = trNote.getValue(j);
                if (col.getType() == 1 && col.isOutputFrequency()) {
                    String[] parts = newValue.split("\\.");
                    int octave = Integer.parseInt(parts[0]);
                    int scaleDegree = Integer.parseInt(parts[1]);
                    double freq = col.getScale().getFrequency(octave, scaleDegree);
                    newValue = Double.toString(freq);
                }
                noteStr = TextUtilities.replaceAll(noteStr, colNameStr, newValue);
            }
            Note note = Note.createNote(noteStr);
            retVal.add(note);
        }
        return retVal;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pcl);
    }

    public void removeAllPropertyChangeListeners() {
        this.listeners.clear();
    }

    public void firePropertyChange(String propertyName, double oldVal, double newVal) {
        this.firePropertyChange(propertyName, new Double(oldVal), new Double(newVal));
    }

    public void firePropertyChange(String propertyName, boolean oldVal, boolean newVal) {
        this.firePropertyChange(propertyName, (Object)oldVal, (Object)newVal);
    }

    public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldVal, newVal);
        for (PropertyChangeListener pcl : this.listeners) {
            pcl.propertyChange(pce);
        }
    }

    @Override
    public int getRowCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Name";
        }
        return "Type";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Column col = this.columns.get(rowIndex);
        if (columnIndex == 0) {
            return col.getName();
        }
        return Column.TYPES[col.getType()];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return;
        }
        Column col = this.columns.get(rowIndex);
        if (!col.getName().equals(aValue)) {
            col.setName((String)aValue);
            this.fireTableDataChanged();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.tableListeners == null) {
            this.tableListeners = new Vector();
        }
        this.tableListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.tableListeners == null) {
            return;
        }
        this.tableListeners.remove(l);
    }

    private void fireTableDataChanged() {
        if (this.tableListeners == null) {
            return;
        }
        TableModelEvent tme = new TableModelEvent(this);
        for (TableModelListener listener : this.tableListeners) {
            listener.tableChanged(tme);
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public Element saveAsXML() {
        Element retVal = new Element("track");
        retVal.addElement(NAME).setText(this.name);
        retVal.addElement("noteTemplate").setText(this.noteTemplate);
        retVal.addElement("instrumentId").setText(this.instrumentId);
        Element colElement = new Element("columns");
        retVal.addElement(colElement);
        for (Column col : this.columns) {
            colElement.addElement(col.saveAsXML());
        }
        Element trNotesElement = new Element("trackerNotes");
        retVal.addElement(trNotesElement);
        for (TrackerNote note : this.trackerNotes) {
            trNotesElement.addElement(note.saveAsXML());
        }
        return retVal;
    }

    public static Track loadFromXML(Element data) {
        Track retVal = new Track(false);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "name": {
                    retVal.name = node.getTextString();
                    if (retVal.name != null) break;
                    retVal.name = "";
                    break;
                }
                case "noteTemplate": {
                    retVal.noteTemplate = node.getTextString();
                    if (retVal.noteTemplate != null) break;
                    retVal.noteTemplate = "";
                    break;
                }
                case "instrumentId": {
                    retVal.instrumentId = node.getTextString();
                    if (retVal.instrumentId != null) break;
                    retVal.instrumentId = "";
                    break;
                }
                case "columns": {
                    Elements nodes2 = node.getElements();
                    while (nodes2.hasMoreElements()) {
                        retVal.addColumn(Column.loadFromXML(nodes2.next()));
                    }
                    break;
                }
                case "trackerNotes": {
                    Elements nodes2 = node.getElements();
                    while (nodes2.hasMoreElements()) {
                        retVal.trackerNotes.add(TrackerNote.loadFromXML(nodes2.next()));
                    }
                    break;
                }
            }
        }
        return retVal;
    }

    public void clearNotes() {
        for (TrackerNote note : this.trackerNotes) {
            note.clear();
        }
        this.fireTableDataChanged();
    }

    public void insertNote(int start) {
        this.trackerNotes.add(start, this.createNewNote());
        this.trackerNotes.remove(this.trackerNotes.size() - 1);
    }

    public void removeNote(int start) {
        this.trackerNotes.remove(start);
        this.trackerNotes.add(this.createNewNote());
    }
}

