/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.pianoRoll;

import blue.utility.TextUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Scale {
    private String scaleName = "";
    private double[] ratios;
    private double baseFrequency = 261.625565;
    private double octave = 2.0;

    private Scale() {
    }

    public Scale(Scale scale) {
        this.scaleName = scale.scaleName;
        this.ratios = (double[])scale.ratios.clone();
        this.baseFrequency = scale.baseFrequency;
        this.octave = scale.octave;
    }

    public static Scale loadScale(File scalaFile) {
        ArrayList lines;
        Scale scale = new Scale();
        scale.setScaleName(scalaFile.getName());
        try {
            lines = TextUtilities.getLinesFromFile(scalaFile, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        int lineCount = 0;
        int pitchCount = 0;
        int index = 0;
        int count = lines.size();
        for (int i = 0; i < count; ++i) {
            String line = (String)lines.get(i);
            if (line.startsWith("!")) continue;
            if (lineCount != 0) {
                if (lineCount == 1) {
                    pitchCount = Integer.parseInt(line);
                    scale.ratios = new double[pitchCount];
                    scale.ratios[0] = 1.0;
                    ++index;
                } else if (scale.ratios != null) {
                    if (index == scale.ratios.length) {
                        scale.octave = Scale.getMultiplier(line);
                    } else {
                        scale.ratios[index] = Scale.getMultiplier(line);
                        ++index;
                    }
                }
            }
            ++lineCount;
        }
        return scale;
    }

    public static Scale get12TET() {
        Scale retrVal = new Scale();
        retrVal.scaleName = "12TET";
        retrVal.ratios = new double[12];
        double ratio = Math.pow(2.0, 0.08333333333333333);
        for (int i = 0; i < retrVal.ratios.length; ++i) {
            retrVal.ratios[i] = Math.pow(ratio, i);
        }
        return retrVal;
    }

    private static double getMultiplier(String lineInput) {
        double multiplier = 0.0;
        String line = Scale.removeComments(lineInput);
        if (line.indexOf(47) > -1) {
            String[] vals = line.split("/");
            multiplier = Double.parseDouble(vals[0]) / Double.parseDouble(vals[1]);
        } else if (line.indexOf(46) > -1) {
            double cents = Double.parseDouble(line);
            multiplier = Math.pow(2.0, cents / 1200.0);
        } else {
            multiplier = Double.parseDouble(line);
        }
        return multiplier;
    }

    private static String removeComments(String line) {
        if (line.indexOf(32) > -1) {
            return line.substring(0, line.indexOf(32));
        }
        if (line.indexOf(9) > -1) {
            return line.substring(0, line.indexOf(9));
        }
        return line;
    }

    public int getNumScaleDegrees() {
        return this.ratios.length;
    }

    public double getFrequency(int octave, int scaleDegree) {
        int oct = octave;
        int pitchIndex = scaleDegree;
        if (pitchIndex >= this.ratios.length) {
            oct += pitchIndex / this.ratios.length;
            pitchIndex %= this.ratios.length;
        }
        double multiplier = oct - 8;
        multiplier = Math.pow(this.octave, multiplier);
        double newBase = multiplier * this.baseFrequency;
        return newBase * this.ratios[pitchIndex];
    }

    public static Scale loadFromXML(Element data) {
        Scale scale = new Scale();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "scaleName": {
                    scale.scaleName = node.getTextString();
                    break;
                }
                case "baseFrequency": {
                    scale.baseFrequency = Double.parseDouble(node.getTextString());
                    break;
                }
                case "octave": {
                    scale.octave = Double.parseDouble(node.getTextString());
                    break;
                }
                case "ratios": {
                    Elements ratioNodes = node.getElements();
                    scale.ratios = new double[ratioNodes.size()];
                    int i = 0;
                    while (ratioNodes.hasMoreElements()) {
                        Element ratioNode = ratioNodes.next();
                        scale.ratios[i] = Double.parseDouble(ratioNode.getTextString());
                        ++i;
                    }
                    break;
                }
            }
        }
        return scale;
    }

    public Element saveAsXML() {
        Element retVal = new Element("scale");
        retVal.addElement("scaleName").setText(this.scaleName);
        retVal.addElement("baseFrequency").setText(Double.toString(this.baseFrequency));
        retVal.addElement("octave").setText(Double.toString(this.octave));
        Element ratiosNode = retVal.addElement("ratios");
        for (int i = 0; i < this.ratios.length; ++i) {
            Element node = new Element("ratio").setText(Double.toString(this.ratios[i]));
            ratiosNode.addElement(node);
        }
        return retVal;
    }

    public String getScaleName() {
        return this.scaleName;
    }

    public void setScaleName(String scaleName) {
        this.scaleName = scaleName;
    }

    public double getBaseFrequency() {
        return this.baseFrequency;
    }

    public void setBaseFrequency(double baseFrequency) {
        this.baseFrequency = baseFrequency;
    }

    public void copyValues(Scale scale) {
        this.octave = scale.octave;
        this.ratios = scale.ratios;
        this.scaleName = scale.scaleName;
        this.baseFrequency = scale.baseFrequency;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return this.getScaleName();
    }
}

