/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.pattern;

import electric.xml.Element;
import electric.xml.Elements;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Pattern {
    public boolean[] values;
    String patternName = "pattern";
    String patternScore = "";
    boolean muted = false;
    boolean solo = false;

    public Pattern(int beats) {
        this.values = new boolean[beats];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = false;
        }
    }

    public Pattern(Pattern p) {
        this.values = (boolean[])p.values.clone();
        this.patternName = p.patternName;
        this.patternScore = p.patternScore;
        this.muted = p.muted;
        this.solo = p.solo;
    }

    public String getPatternName() {
        return this.patternName;
    }

    public void setPatternName(String patternName) {
        this.patternName = patternName;
    }

    public String getPatternScore() {
        return this.patternScore;
    }

    public void setPatternScore(String patternString) {
        this.patternScore = patternString;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public boolean isSolo() {
        return this.solo;
    }

    public void setSolo(boolean solo) {
        this.solo = solo;
    }

    public Element saveAsXML() {
        Element retVal = new Element("pattern");
        retVal.addElement("patternName").setText(this.patternName);
        retVal.addElement("patternScore").setText(this.patternScore);
        retVal.addElement("muted").setText(Boolean.toString(this.muted));
        retVal.addElement("solo").setText(Boolean.toString(this.solo));
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i]) {
                buffer.append("1");
                continue;
            }
            buffer.append("0");
        }
        retVal.addElement("values").setText(buffer.toString());
        return retVal;
    }

    public static Pattern loadFromXML(Element data) {
        String name = "";
        String score = "";
        boolean muted = false;
        boolean solo = false;
        boolean[] values = new boolean[16];
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "patternName": {
                    name = node.getTextString();
                    break;
                }
                case "patternScore": {
                    score = node.getTextString();
                    break;
                }
                case "muted": {
                    muted = node.getTextString().equals("true");
                    break;
                }
                case "solo": {
                    solo = node.getTextString().equals("true");
                    break;
                }
                case "values": {
                    String valStr = node.getTextString();
                    values = new boolean[valStr.length()];
                    for (int i = 0; i < valStr.length(); ++i) {
                        values[i] = valStr.charAt(i) == '1';
                    }
                    break;
                }
            }
        }
        Pattern retVal = new Pattern(values.length);
        retVal.setPatternName(name);
        retVal.setPatternScore(score);
        retVal.setMuted(muted);
        retVal.setSolo(solo);
        retVal.values = values;
        return retVal;
    }

    public boolean equals(Object object) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)object, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

