/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.notation;

import blue.soundObject.notation.NotationEditPoint;
import blue.soundObject.notation.NotationNote;
import blue.soundObject.notation.NotationStaff;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class NotationStaffRenderer
extends JComponent {
    public static final Color BACKGROUND_COLOR = Color.black;
    public static final Color NOTATION_COLOR = Color.white;
    public static final Color EDIT_COLOR = Color.orange;
    public static final int LINE_HEIGHT = 8;
    public static final int HALF_SPACE_HEIGHT = 4;
    public static final int TOP_MARGIN = 150;
    public static final int SIDE_MARGIN = 30;
    public static final int STAFF_NAME_WIDTH = 100;
    public static final int SIXTY_FOURTH_WIDTH = 10;
    public static final int DOT_WIDTH = 5;
    public static final int SPACE_BETWEEN_NOTES = 1;
    private NotationStaff staffData = null;
    private NotationEditPoint notationEditPoint = null;

    public NotationStaffRenderer() {
        this.setPreferredSize(new Dimension(400, 100));
    }

    public void setNotationEditPoint(NotationEditPoint notationEditPoint) {
        this.notationEditPoint = notationEditPoint;
    }

    public void setNotationStaff(NotationStaff staffData) {
        this.staffData = staffData;
    }

    @Override
    public void paint(Graphics g) {
        int centerPitchValue;
        int centerPitchY;
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.staffData == null) {
            return;
        }
        g.setColor(NOTATION_COLOR);
        g.drawString(this.staffData.getStaffName(), 30, 166);
        for (int i = 0; i < 5; ++i) {
            int line_y = 150 + i * 8;
            g.drawLine(130, line_y, this.getWidth() - 30, line_y);
        }
        int totalX = 130;
        totalX += 60;
        if (this.staffData.getClef() == 0) {
            centerPitchY = 190;
            centerPitchValue = 60;
        } else {
            centerPitchY = 170;
            centerPitchValue = 48;
        }
        int size = this.staffData.size();
        for (int i = 0; i < size + 1; ++i) {
            int spaceX = 0;
            if (i != size) {
                NotationNote note = this.staffData.getNotationNote(i);
                int noteY = (centerPitchValue - note.getMidiPitch()) * 4;
                g.fillOval(totalX + 1, centerPitchY + noteY - 4, 10, 8);
                if (note.getNoteDuration() > 5) {
                    g.setColor(BACKGROUND_COLOR);
                    g.fillOval(totalX + 1, centerPitchY + noteY - 2, 10, 4);
                    g.setColor(NOTATION_COLOR);
                }
                if (note.getNoteDuration() < 7) {
                    int stemHeight = Math.abs(noteY - centerPitchY);
                    int x = totalX + 8 + 2;
                    int y1 = centerPitchY + noteY;
                    int y2 = centerPitchY;
                    if (stemHeight < 40) {
                        stemHeight = 40;
                        y2 = (y2 = y1 - y2) > 0 ? y1 - stemHeight : y1 + stemHeight;
                    }
                    g.drawLine(x, y1, x, y2);
                }
                spaceX = 2 + 10 * note.getNoteDuration();
            }
            if (this.notationEditPoint != null && this.notationEditPoint.getIndex() == i) {
                g.setColor(EDIT_COLOR);
                int editY = (centerPitchValue - this.notationEditPoint.getMidiPch()) * 4;
                g.fillRect(totalX, centerPitchY + editY - 2, 10, 4);
                g.setColor(NOTATION_COLOR);
            }
            totalX += spaceX;
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public static void main(String[] args) {
        NotationStaff staff = new NotationStaff();
        staff.setClef(0);
        for (int i = 0; i < 7; ++i) {
            NotationNote n = new NotationNote();
            n.setMidiPitch(60 + i);
            n.setNoteDuration(i + 1);
            staff.addNotationNote(n);
        }
        NotationStaffRenderer notationStaff1 = new NotationStaffRenderer();
        notationStaff1.setNotationStaff(staff);
        NotationEditPoint nep = new NotationEditPoint();
        nep.setMidiPch(72);
        nep.setIndex(2);
        notationStaff1.setNotationEditPoint(nep);
        JFrame mFrame = new JFrame();
        mFrame.setSize(800, 600);
        mFrame.getContentPane().add(notationStaff1);
        mFrame.show();
        mFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

