/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask.probability;

import blue.soundObject.jmask.Table;
import blue.soundObject.jmask.probability.ProbabilityGenerator;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;

public class Cauchy
implements ProbabilityGenerator {
    private double alpha;
    private double mu;
    private boolean alphaTableEnabled = false;
    private boolean muTableEnabled = false;
    private Table alphaTable;
    private Table muTable;

    public Cauchy() {
        this.alpha = 0.1;
        this.mu = 0.5;
        this.alphaTable = new Table();
        this.muTable = new Table();
        this.alphaTable.getPoint(0).setValue(0.1);
        this.alphaTable.getPoint(1).setValue(0.1);
        this.muTable.getPoint(0).setValue(0.5);
        this.muTable.getPoint(1).setValue(0.5);
    }

    public Cauchy(Cauchy cauchy) {
        this.alpha = cauchy.alpha;
        this.mu = cauchy.mu;
        this.alphaTableEnabled = cauchy.alphaTableEnabled;
        this.muTableEnabled = cauchy.muTableEnabled;
        this.alphaTable = new Table(cauchy.alphaTable);
        this.muTable = new Table(cauchy.muTable);
    }

    public static ProbabilityGenerator loadFromXML(Element data) {
        Cauchy retVal = new Cauchy();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            block7 : switch (nodeName = node.getName()) {
                case "alpha": {
                    retVal.alpha = XMLUtilities.readDouble(node);
                    break;
                }
                case "mu": {
                    retVal.mu = XMLUtilities.readDouble(node);
                    break;
                }
                case "alphaTableEnabled": {
                    retVal.alphaTableEnabled = XMLUtilities.readBoolean(node);
                    break;
                }
                case "muTableEnabled": {
                    retVal.muTableEnabled = XMLUtilities.readBoolean(node);
                    break;
                }
                case "table": {
                    String tableId;
                    switch (tableId = node.getAttributeValue("tableId")) {
                        case "alphaTable": {
                            retVal.alphaTable = Table.loadFromXML(node);
                            break block7;
                        }
                        case "muTable": {
                            retVal.muTable = Table.loadFromXML(node);
                        }
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("probabilityGenerator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(XMLUtilities.writeDouble("alpha", this.alpha));
        retVal.addElement(XMLUtilities.writeDouble("mu", this.mu));
        retVal.addElement(XMLUtilities.writeBoolean("alphaTableEnabled", this.alphaTableEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("muTableEnabled", this.muTableEnabled));
        Element alphaTableNode = this.alphaTable.saveAsXML();
        alphaTableNode.setAttribute("tableId", "alphaTable");
        Element muTableNode = this.muTable.saveAsXML();
        muTableNode.setAttribute("tableId", "muTable");
        retVal.addElement(alphaTableNode);
        retVal.addElement(muTableNode);
        return retVal;
    }

    @Override
    public String getName() {
        return "Cauchy";
    }

    @Override
    public double getValue(double time, Random rnd) {
        double e;
        double x;
        double localAlpha = this.alphaTableEnabled ? this.alphaTable.getValue(time) : this.alpha;
        double localMu = this.muTableEnabled ? this.muTable.getValue(time) : this.mu;
        while ((x = rnd.nextDouble()) == 0.5 || (e = localAlpha * Math.tan(x * Math.PI) + localMu) > 1.0 || e < 0.0) {
        }
        return e;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double mu) {
        this.mu = mu;
    }

    public boolean isAlphaTableEnabled() {
        return this.alphaTableEnabled;
    }

    public void setAlphaTableEnabled(boolean alphaTableEnabled) {
        this.alphaTableEnabled = alphaTableEnabled;
    }

    public boolean isMuTableEnabled() {
        return this.muTableEnabled;
    }

    public void setMuTableEnabled(boolean muTableEnabled) {
        this.muTableEnabled = muTableEnabled;
    }

    public Table getAlphaTable() {
        return this.alphaTable;
    }

    public void setAlphaTable(Table alphaTable) {
        this.alphaTable = alphaTable;
    }

    public Table getMuTable() {
        return this.muTable;
    }

    public void setMuTable(Table muTable) {
        this.muTable = muTable;
    }

    @Override
    public Cauchy deepCopy() {
        return new Cauchy(this);
    }
}

