/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Accumulatable;
import blue.soundObject.jmask.Accumulator;
import blue.soundObject.jmask.Generator;
import blue.soundObject.jmask.Mask;
import blue.soundObject.jmask.Maskable;
import blue.soundObject.jmask.Quantizable;
import blue.soundObject.jmask.Quantizer;
import blue.utility.ObjectUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Random;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Parameter {
    private boolean visible = true;
    private Generator generator = null;
    private Mask mask = null;
    private Quantizer quantizer = null;
    private Accumulator accumulator = null;
    private transient PropertyChangeSupport propSupport = null;
    private String name = "";

    public Parameter() {
    }

    public Parameter(Parameter param) {
        this.visible = param.visible;
        if (param.generator != null) {
            this.generator = (Generator)param.generator.deepCopy();
        }
        if (param.mask != null) {
            this.mask = new Mask(param.mask);
        }
        if (param.quantizer != null) {
            this.quantizer = new Quantizer(param.quantizer);
        }
        if (param.accumulator != null) {
            this.accumulator = new Accumulator(param.accumulator);
        }
        this.name = param.name;
    }

    public static Parameter create(Generator generator) {
        Parameter param = new Parameter();
        param.setGenerator(generator);
        if (generator instanceof Maskable) {
            param.setMask(new Mask());
        }
        if (generator instanceof Accumulatable) {
            param.setAccumulator(new Accumulator());
        }
        if (generator instanceof Quantizable) {
            param.setQuantizer(new Quantizer());
        }
        return param;
    }

    public double getValue(double time, Random rnd) {
        double val = this.generator.getValue(time, rnd);
        if (this.mask != null && this.mask.isEnabled()) {
            val = this.mask.getValue(time, val);
        }
        if (this.quantizer != null && this.quantizer.isEnabled()) {
            val = this.quantizer.getValue(time, val);
        }
        if (this.accumulator != null && this.accumulator.isEnabled()) {
            val = this.accumulator.getValue(time, val);
        }
        return val;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        this.mask = mask;
    }

    public Quantizer getQuantizer() {
        return this.quantizer;
    }

    public void setQuantizer(Quantizer quantizer) {
        this.quantizer = quantizer;
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(Accumulator accumulator) {
        this.accumulator = accumulator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldName) {
        this.name = fieldName;
    }

    public static Parameter loadFromXML(Element data) throws Exception {
        Parameter parameter = new Parameter();
        if (data.getAttributeValue("visible") != null) {
            boolean visible = Boolean.valueOf(data.getAttributeValue("visible"));
            parameter.setVisible(visible);
        }
        if (data.getAttributeValue("name") != null) {
            parameter.setName(data.getAttributeValue("name"));
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "generator": {
                    parameter.generator = (Generator)ObjectUtilities.loadFromXML(node);
                    break;
                }
                case "mask": {
                    parameter.mask = Mask.loadFromXML(node);
                    break;
                }
                case "quantizer": {
                    parameter.quantizer = Quantizer.loadFromXML(node);
                    break;
                }
                case "accumulator": {
                    parameter.accumulator = Accumulator.loadFromXML(node);
                }
            }
        }
        return parameter;
    }

    public Element saveAsXML() {
        Element retVal = new Element("parameter");
        retVal.setAttribute("visible", Boolean.toString(this.visible));
        retVal.setAttribute("name", this.getName());
        retVal.addElement(this.generator.saveAsXML());
        if (this.mask != null) {
            retVal.addElement(this.mask.saveAsXML());
        }
        if (this.quantizer != null) {
            retVal.addElement(this.quantizer.saveAsXML());
        }
        if (this.accumulator != null) {
            retVal.addElement(this.accumulator.saveAsXML());
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void initialize(double duration) {
        this.generator.initialize(duration);
        if (this.mask != null) {
            this.mask.setDuration(duration);
        }
        if (this.quantizer != null) {
            this.quantizer.setDuration(duration);
        }
        if (this.accumulator != null) {
            this.accumulator.setDuration(duration);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        if (this.propSupport != null) {
            this.propSupport.firePropertyChange("visible", !visible, visible);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        for (PropertyChangeListener listener : this.propSupport.getPropertyChangeListeners()) {
            if (listener != pcl) continue;
            return;
        }
        this.propSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propSupport != null) {
            this.propSupport.removePropertyChangeListener(pcl);
        }
    }
}

