/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.BSBObject;
import electric.xml.Element;
import electric.xml.Elements;
import java.rmi.dgc.VMID;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Preset
implements Comparable<Preset> {
    private String presetName = "";
    private HashMap<String, String> valuesMap = new HashMap();
    private String uniqueId;

    public Preset() {
        this.uniqueId = Integer.toString(new VMID().hashCode());
    }

    public Preset(Preset preset) {
        this.presetName = preset.presetName;
        this.uniqueId = preset.uniqueId;
        this.valuesMap = new HashMap<String, String>(preset.valuesMap);
    }

    public static Preset createPreset(BSBGraphicInterface bsbInterface) {
        Preset preset = new Preset();
        for (BSBObject bsbObj : bsbInterface.getAllSet()) {
            String val;
            String objectName = bsbObj.getObjectName();
            if (objectName == null || objectName.length() == 0 || (val = bsbObj.getPresetValue()) == null) continue;
            preset.valuesMap.put(objectName, val);
        }
        return preset;
    }

    public void updatePresets(BSBGraphicInterface bsbInterface) {
        this.valuesMap.clear();
        for (BSBObject bsbObj : bsbInterface.getAllSet()) {
            String val;
            String objectName = bsbObj.getObjectName();
            if (objectName == null || objectName.length() == 0 || (val = bsbObj.getPresetValue()) == null) continue;
            this.valuesMap.put(objectName, val);
        }
    }

    public static Preset loadFromXML(Element data) {
        Preset p = new Preset();
        p.setPresetName(data.getAttributeValue("name"));
        String uniqueId = data.getAttributeValue("uniqueId");
        if (uniqueId != null && uniqueId.length() > 0) {
            p.uniqueId = uniqueId;
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            if (!node.getName().equals("setting")) continue;
            String name = node.getAttributeValue("name");
            String val = node.getTextString();
            p.addSetting(name, val);
        }
        return p;
    }

    public Element saveAsXML() {
        Element retVal = new Element("preset");
        retVal.setAttribute("name", this.presetName);
        retVal.setAttribute("uniqueId", this.uniqueId);
        Object[] keys = this.valuesMap.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            String val = this.valuesMap.get(key);
            retVal.addElement("setting").setAttribute("name", (String)key).setText(val);
        }
        return retVal;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void addSetting(String objectName, String objectVal) {
        this.valuesMap.put(objectName, objectVal);
    }

    public String getSetting(String objectName) {
        return this.valuesMap.get(objectName);
    }

    public String getPresetName() {
        return this.presetName;
    }

    public void setPresetName(String name) {
        this.presetName = name;
    }

    public String toString() {
        return this.getPresetName();
    }

    @Override
    public int compareTo(Preset b) {
        return this.getPresetName().compareTo(b.getPresetName());
    }

    public void setInterfaceValues(BSBGraphicInterface graphicInterface) {
        for (BSBObject bsbObj : graphicInterface.getAllSet()) {
            String objName = bsbObj.getObjectName();
            String setting = this.getSetting(objName);
            if (setting == null) continue;
            bsbObj.setPresetValue(setting);
        }
    }

    public void synchronizeWithInterface(BSBGraphicInterface graphicInterface) {
        String objName;
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (BSBObject bsbObj : graphicInterface.getAllSet()) {
            objName = bsbObj.getObjectName();
            nameMap.put(objName, objName);
        }
        Iterator<Map.Entry<String, String>> iter = this.valuesMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String key = entry.getKey();
            if (nameMap.containsKey(key)) continue;
            System.out.println("Removing preset with objectName: " + key);
            iter.remove();
        }
        for (BSBObject bsbObj : graphicInterface.getAllSet()) {
            String val;
            objName = bsbObj.getObjectName();
            if (objName == null || objName.length() == 0 || this.valuesMap.containsKey(objName) || (val = bsbObj.getPresetValue()) == null) continue;
            System.out.println("adding preset for objectName: " + objName);
            this.valuesMap.put(objName, val);
        }
    }
}

