/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;

public class GridSettings {
    private IntegerProperty width = new SimpleIntegerProperty(10);
    private IntegerProperty height = new SimpleIntegerProperty(10);
    private ObjectProperty<GridStyle> gridStyle = new SimpleObjectProperty((Object)GridStyle.DOT);
    private BooleanProperty snapEnabled = new SimpleBooleanProperty(true);

    public GridSettings() {
    }

    public GridSettings(GridSettings settings) {
        this.setWidth(settings.getWidth());
        this.setHeight(settings.getHeight());
        this.setGridStyle(settings.getGridStyle());
        this.setSnapEnabled(settings.isSnapEnabled());
    }

    public final void setWidth(int value) {
        this.width.set(value);
    }

    public final int getWidth() {
        return this.width.get();
    }

    public final IntegerProperty widthProperty() {
        return this.width;
    }

    public final void setHeight(int value) {
        this.height.set(value);
    }

    public final int getHeight() {
        return this.height.get();
    }

    public final IntegerProperty heightProperty() {
        return this.height;
    }

    public final void setSnapEnabled(boolean value) {
        this.snapEnabled.set(value);
    }

    public final boolean isSnapEnabled() {
        return this.snapEnabled.get();
    }

    public final BooleanProperty snapEnabledProperty() {
        return this.snapEnabled;
    }

    public final void setGridStyle(GridStyle gridStyle) {
        this.gridStyle.set((Object)gridStyle);
    }

    public final GridStyle getGridStyle() {
        return (GridStyle)((Object)this.gridStyle.get());
    }

    public final ObjectProperty<GridStyle> gridStyleProperty() {
        return this.gridStyle;
    }

    public static GridSettings loadFromXML(Element data) throws Exception {
        GridSettings gridSettings = new GridSettings();
        Elements giNodes = data.getElements();
        while (giNodes.hasMoreElements()) {
            String name;
            Element node = giNodes.next();
            switch (name = node.getName()) {
                case "width": {
                    gridSettings.setWidth(XMLUtilities.readInt(node));
                    break;
                }
                case "height": {
                    gridSettings.setHeight(XMLUtilities.readInt(node));
                    break;
                }
                case "gridStyle": {
                    gridSettings.setGridStyle(GridStyle.valueOf(node.getTextString()));
                    break;
                }
                case "snapGridEnabled": {
                    gridSettings.setSnapEnabled(XMLUtilities.readBoolean(node));
                }
            }
        }
        return gridSettings;
    }

    public Element saveAsXML() {
        Element retVal = new Element("gridSettings");
        retVal.addElement(XMLUtilities.writeInt("width", this.getWidth()));
        retVal.addElement(XMLUtilities.writeInt("height", this.getHeight()));
        retVal.addElement(new Element("gridStyle").setText(this.getGridStyle().toString()));
        retVal.addElement(XMLUtilities.writeBoolean("snapGridEnabled", this.isSnapEnabled()));
        return retVal;
    }

    public static enum GridStyle {
        NONE,
        DOT,
        LINE;

    }
}

