/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.components.lines.LineUtils;
import blue.orchestra.blueSynthBuilder.ClampedValueListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ClampedValue {
    private DoubleProperty value;
    private DoubleProperty min;
    private DoubleProperty max;
    private ObjectProperty<BigDecimal> resolution;
    List<ClampedValueListener> listeners = null;

    public ClampedValue() {
        this(0.0, 1.0, 0.5, new BigDecimal(-1.0));
    }

    public ClampedValue(ClampedValue cv) {
        this(cv.getMin(), cv.getMax(), cv.getValue(), cv.getResolution());
    }

    public ClampedValue(double minVal, double maxVal, double val, BigDecimal res) {
        this.min = new DoublePropertyBase(minVal){

            protected void invalidated() {
                if (this.get() > ClampedValue.this.getMax()) {
                    ClampedValue.this.setMax(this.get());
                }
                ClampedValue.this.adjustValue();
            }

            public Object getBean() {
                return ClampedValue.this;
            }

            public String getName() {
                return "min";
            }
        };
        this.max = new DoublePropertyBase(maxVal){

            protected void invalidated() {
                if (this.get() < ClampedValue.this.getMin()) {
                    ClampedValue.this.setMin(this.get());
                }
                ClampedValue.this.adjustValue();
            }

            public Object getBean() {
                return ClampedValue.this;
            }

            public String getName() {
                return "max";
            }
        };
        this.value = new DoublePropertyBase(val){

            protected void invalidated() {
                ClampedValue.this.adjustValue();
            }

            public Object getBean() {
                return ClampedValue.this;
            }

            public String getName() {
                return "value";
            }
        };
        this.resolution = new SimpleObjectProperty((Object)res);
    }

    protected void adjustValue() {
        double v = this.getValue();
        double min = this.getMin();
        double max = this.getMax();
        BigDecimal resolution = this.getResolution();
        double newV = Math.max(min, Math.min(max, v));
        if (resolution.doubleValue() > 0.0) {
            newV = LineUtils.snapToResolution(newV, min, max, resolution);
        }
        this.setValue(newV);
    }

    public final void randomizeValue() {
        this.setNormalizedValue(Math.random());
    }

    public void setNormalizedValue(double value) {
        double min = this.getMin();
        double max = this.getMax();
        BigDecimal resolution = this.getResolution();
        double range = this.getMax() - min;
        double newVal = range * value + min;
        if (resolution.doubleValue() > 0.0) {
            newVal = LineUtils.snapToResolution(newVal, min, max, resolution);
        }
        this.setValue(newVal);
    }

    public double getNormalizedValue() {
        double min = this.getMin();
        double range = this.getMax() - min;
        double newVal = (this.getValue() - min) / range;
        return newVal;
    }

    public final void setValue(double val) {
        double v = Math.max(this.getMin(), Math.min(this.getMax(), val));
        if (this.getResolution().doubleValue() > 0.0) {
            v = LineUtils.snapToResolution(v, this.getMin(), this.getMax(), this.getResolution());
        }
        this.value.set(val);
        this.notifyListeners(ClampedValueListener.PropertyType.VALUE, ClampedValueListener.BoundaryType.NONE);
    }

    public final double getValue() {
        return this.value.get();
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final void setMin(double value) {
        if (value >= this.getMax()) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Error: Min value can not be set greater or equals to Max value.", "Error", 0));
            } else {
                JOptionPane.showMessageDialog(null, "Error: Min value can not be set greater or equals to Max value.", "Error", 0);
            }
            return;
        }
        double oldMin = this.getMin();
        double oldValue = this.getValue();
        this.min.set(value);
        this.setValue(LineUtils.rescale(oldValue, oldMin, this.getMax(), value, this.getMax(), this.getResolution()));
        this.notifyListeners(ClampedValueListener.PropertyType.MIN, ClampedValueListener.BoundaryType.SCALE);
    }

    public final double getMin() {
        return this.min.get();
    }

    public final DoubleProperty minProperty() {
        return this.min;
    }

    public final void setMax(double value) {
        if (value <= this.getMin()) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Error: Max value can not be set less than or equal to Min value.", "Error", 0));
            } else {
                JOptionPane.showMessageDialog(null, "Error: Max value can not be set less than or equal to Min value.", "Error", 0);
            }
            return;
        }
        double oldMax = this.getMax();
        double oldValue = this.getValue();
        this.max.set(value);
        this.setValue(LineUtils.rescale(oldValue, this.getMin(), oldMax, this.getMin(), value, this.getResolution()));
        this.notifyListeners(ClampedValueListener.PropertyType.MAX, ClampedValueListener.BoundaryType.SCALE);
    }

    public final double getMax() {
        return this.max.get();
    }

    public final DoubleProperty maxProperty() {
        return this.max;
    }

    public final void setResolution(BigDecimal value) {
        this.resolution.set((Object)value);
        this.adjustValue();
        this.notifyListeners(ClampedValueListener.PropertyType.RESOLUTION, ClampedValueListener.BoundaryType.NONE);
    }

    public final BigDecimal getResolution() {
        return (BigDecimal)this.resolution.get();
    }

    public final ObjectProperty<BigDecimal> resolutionProperty() {
        return this.resolution;
    }

    public void addListener(ClampedValueListener cvl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ClampedValueListener>();
        }
        this.listeners.add(cvl);
    }

    public void removeListener(ClampedValueListener cvl) {
        if (this.listeners != null) {
            this.listeners.remove(cvl);
        }
    }

    public void notifyListeners(ClampedValueListener.PropertyType pType, ClampedValueListener.BoundaryType bType) {
        if (this.listeners != null) {
            for (ClampedValueListener listener : this.listeners) {
                listener.propertyChanged(pType, bType);
            }
        }
    }
}

