/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.automation.ParameterList;
import blue.orchestra.blueSynthBuilder.AutomatableBSBObject;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.BSBSubChannelDropdown;
import blue.orchestra.blueSynthBuilder.Randomizable;
import blue.orchestra.blueSynthBuilder.StringChannel;
import blue.orchestra.blueSynthBuilder.StringChannelProvider;
import blue.orchestra.blueSynthBuilder.UniqueNameCollection;
import blue.orchestra.blueSynthBuilder.UniqueNameManager;
import blue.utility.ObjectUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.scene.paint.Color;

public class BSBGroup
extends BSBObject
implements Iterable<BSBObject>,
UniqueNameCollection,
Randomizable {
    private transient ParameterList parameterList;
    private transient ObservableSet<BSBObject> allSet;
    private StringProperty groupName = new SimpleStringProperty("Group");
    private ObjectProperty<Color> backgroundColor = new SimpleObjectProperty((Object)new Color(0.0, 0.0, 0.0, 0.2));
    private ObjectProperty<Color> borderColor = new SimpleObjectProperty((Object)Color.BLACK);
    private ObjectProperty<Color> labelTextColor = new SimpleObjectProperty((Object)Color.WHITE);
    private BooleanProperty titleEnabled = new SimpleBooleanProperty(true);
    private final IntegerProperty width = new SimpleIntegerProperty(20);
    private final IntegerProperty height = new SimpleIntegerProperty(20);
    private Set<BSBObject> backingSet = new HashSet<BSBObject>(){

        @Override
        public boolean add(BSBObject bsbObj) {
            String objName = bsbObj.getObjectName();
            if (objName != null && objName.length() != 0 && BSBGroup.this.unm != null && !BSBGroup.this.unm.isUniquelyNamed(bsbObj)) {
                BSBGroup.this.unm.setUniqueName(bsbObj);
            }
            if (bsbObj instanceof BSBGroup) {
                if (BSBGroup.this.unm != null) {
                    UniqueNameManager tempUNM = new UniqueNameManager();
                    HashSet additionalNames = new HashSet();
                    tempUNM.setUniqueNameCollection(() -> {
                        HashSet<String> temp = new HashSet<String>();
                        temp.addAll(additionalNames);
                        if (BSBGroup.this.unm.getUniqueNameCollection() != null) {
                            temp.addAll(BSBGroup.this.unm.getUniqueNameCollection().getNames());
                        }
                        return temp;
                    });
                    ((BSBGroup)bsbObj).makeNamesUnique(tempUNM, additionalNames);
                }
                ((BSBGroup)bsbObj).setParameterList(BSBGroup.this.parameterList);
            }
            bsbObj.setUniqueNameManager(BSBGroup.this.unm);
            return super.add(bsbObj);
        }
    };
    private ObservableSet<BSBObject> interfaceItems = FXCollections.observableSet(this.backingSet);
    SetChangeListener<BSBObject> itemsListener = change -> {
        if (this.allSet != null) {
            if (change.wasAdded()) {
                BSBObject bsbObj = (BSBObject)change.getElementAdded();
                this.allSet.add((Object)bsbObj);
                if (bsbObj instanceof BSBGroup) {
                    ((BSBGroup)bsbObj).setAllSet(this.allSet);
                    ((BSBGroup)bsbObj).setParameterList(this.parameterList);
                }
                if (bsbObj instanceof AutomatableBSBObject) {
                    ((AutomatableBSBObject)bsbObj).setParameterList(this.parameterList);
                }
                bsbObj.setUniqueNameManager(this.unm);
            } else if (change.wasRemoved()) {
                BSBObject bsbObj = (BSBObject)change.getElementRemoved();
                this.allSet.remove((Object)bsbObj);
                if (bsbObj instanceof BSBGroup) {
                    ((BSBGroup)bsbObj).setAllSet(null);
                    ((BSBGroup)bsbObj).removeParameters();
                } else if (bsbObj instanceof AutomatableBSBObject) {
                    ((AutomatableBSBObject)bsbObj).setAutomationAllowed(false);
                }
            }
        }
    };

    public BSBGroup() {
        this.interfaceItems.addListener(this.itemsListener);
    }

    public BSBGroup(BSBGroup group) {
        super(group);
        for (BSBObject bsbObj : group.interfaceItems) {
            this.interfaceItems.add(bsbObj.deepCopy());
        }
        this.interfaceItems.addListener(this.itemsListener);
        this.setGroupName(group.getGroupName());
        this.setBackgroundColor(group.getBackgroundColor());
        this.setBorderColor(group.getBorderColor());
        this.setLabelTextColor(group.getLabelTextColor());
        this.setTitleEnabled(group.isTitleEnabled());
        this.setWidth(group.getWidth());
        this.setHeight(group.getHeight());
    }

    public ObservableSet<BSBObject> interfaceItemsProperty() {
        return this.interfaceItems;
    }

    public Color getBackgroundColor() {
        return (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor.set((Object)c);
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return (Color)this.borderColor.get();
    }

    public void setBorderColor(Color c) {
        this.borderColor.set((Object)c);
    }

    public ObjectProperty<Color> borderColorProperty() {
        return this.borderColor;
    }

    public Color getLabelTextColor() {
        return (Color)this.labelTextColor.get();
    }

    public void setLabelTextColor(Color c) {
        this.labelTextColor.set((Object)c);
    }

    public ObjectProperty<Color> labelTextColorProperty() {
        return this.labelTextColor;
    }

    public final boolean isTitleEnabled() {
        return this.titleEnabled.get();
    }

    public final void setTitleEnabled(boolean enabled) {
        this.titleEnabled.set(enabled);
    }

    public final BooleanProperty titleEnabledProperty() {
        return this.titleEnabled;
    }

    public void addBSBObject(BSBObject bsbObj) {
        if (bsbObj != null) {
            this.interfaceItems.add((Object)bsbObj);
        }
    }

    @Override
    public Iterator<BSBObject> iterator() {
        return this.interfaceItems.iterator();
    }

    public int size() {
        return this.interfaceItems.size();
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        for (BSBObject bsbObj : this.interfaceItems) {
            bsbObj.setupForCompilation(compilationUnit);
        }
    }

    @Override
    public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>();
        for (BSBObject bsbObj : this.interfaceItems) {
            if (bsbObj instanceof BSBGroup) {
                names.addAll(((BSBGroup)bsbObj).getNames());
                continue;
            }
            String[] replacementKeys = bsbObj.getReplacementKeys();
            if (replacementKeys == null) continue;
            names.addAll(Arrays.asList(replacementKeys));
        }
        return names;
    }

    public static BSBGroup loadFromXML(Element data) throws Exception {
        BSBGroup bsbGroup = new BSBGroup();
        BSBGroup.initBasicFromXML(data, bsbGroup);
        String groupName = data.getAttributeValue("groupName");
        if (groupName != null) {
            bsbGroup.setGroupName(groupName);
        }
        Elements elems = data.getElements();
        while (elems.hasMoreElements()) {
            String name;
            Element node = elems.next();
            switch (name = node.getName()) {
                case "groupName": {
                    bsbGroup.setGroupName(node.getTextString());
                    break;
                }
                case "backgroundColor": {
                    bsbGroup.setBackgroundColor(Color.valueOf((String)node.getTextString()));
                    break;
                }
                case "borderColor": {
                    bsbGroup.setBorderColor(Color.valueOf((String)node.getTextString()));
                    break;
                }
                case "labelTextColor": {
                    bsbGroup.setLabelTextColor(Color.valueOf((String)node.getTextString()));
                    break;
                }
                case "bsbObject": {
                    Object obj = ObjectUtilities.loadFromXML(node);
                    bsbGroup.addBSBObject((BSBObject)obj);
                    break;
                }
                case "titleEnabled": {
                    bsbGroup.setTitleEnabled(XMLUtilities.readBoolean(node));
                    break;
                }
                case "width": {
                    bsbGroup.setWidth(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "height": {
                    bsbGroup.setHeight(Integer.parseInt(node.getTextString()));
                }
            }
        }
        return bsbGroup;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBObject.getBasicXML(this);
        retVal.addElement("groupName").setText(this.getGroupName());
        retVal.addElement("backgroundColor").setText(this.getBackgroundColor().toString());
        retVal.addElement("borderColor").setText(this.getBorderColor().toString());
        retVal.addElement("labelTextColor").setText(this.getLabelTextColor().toString());
        retVal.addElement(XMLUtilities.writeBoolean("titleEnabled", this.isTitleEnabled()));
        retVal.addElement("width").setText(Integer.toString(this.getWidth()));
        retVal.addElement("height").setText(Integer.toString(this.getHeight()));
        for (BSBObject bsbObj : this.interfaceItems) {
            retVal.addElement(bsbObj.saveAsXML());
        }
        return retVal;
    }

    @Override
    public String getPresetValue() {
        return null;
    }

    @Override
    public void setPresetValue(String val) {
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBGroup(this);
    }

    @Override
    public void randomize() {
        for (BSBObject bsbObj : this.interfaceItems) {
            Randomizable randomizable;
            if (!(bsbObj instanceof Randomizable) || !(randomizable = (Randomizable)((Object)bsbObj)).isRandomizable()) continue;
            randomizable.randomize();
        }
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void setRandomizable(boolean randomizable) {
    }

    @Override
    public void setUniqueNameManager(UniqueNameManager unm) {
        this.unm = unm;
        if (unm != null) {
            for (BSBObject bsbObj : this.interfaceItems) {
                bsbObj.setUniqueNameManager(unm);
            }
        }
    }

    public void resetSubChannels() {
        for (BSBObject bsbObj : this.interfaceItems) {
            if (bsbObj instanceof BSBSubChannelDropdown) {
                ((BSBSubChannelDropdown)bsbObj).setChannelOutput("Master");
                continue;
            }
            if (!(bsbObj instanceof BSBGroup)) continue;
            ((BSBGroup)bsbObj).resetSubChannels();
        }
    }

    public void getStringChannels(ArrayList<StringChannel> stringChannels) {
        for (BSBObject bsbObj : this.interfaceItems) {
            StringChannelProvider provider;
            if (bsbObj instanceof BSBGroup) {
                ((BSBGroup)bsbObj).getStringChannels(stringChannels);
                continue;
            }
            if (!(bsbObj instanceof StringChannelProvider) || !(provider = (StringChannelProvider)((Object)bsbObj)).isStringChannelEnabled()) continue;
            stringChannels.add(provider.getStringChannel());
        }
    }

    public void setParameterList(ParameterList paramList) {
        this.parameterList = paramList;
        for (BSBObject bsbObj : this.interfaceItems) {
            if (bsbObj instanceof BSBGroup) {
                ((BSBGroup)bsbObj).setParameterList(paramList);
                continue;
            }
            if (!(bsbObj instanceof AutomatableBSBObject)) continue;
            ((AutomatableBSBObject)bsbObj).setParameterList(paramList);
        }
    }

    public void setAllSet(ObservableSet<BSBObject> allSet) {
        if (allSet == null && this.allSet != null) {
            this.allSet.remove((Object)this);
            this.allSet.removeAll(this.interfaceItems);
        }
        this.allSet = allSet;
        if (allSet != null) {
            allSet.add((Object)this);
            allSet.addAll(this.interfaceItems);
        }
        for (BSBObject bsbObj : this.interfaceItems) {
            if (!(bsbObj instanceof BSBGroup)) continue;
            ((BSBGroup)bsbObj).setAllSet(allSet);
        }
    }

    protected void removeParameters() {
        for (BSBObject bsbObj : this.interfaceItemsProperty()) {
            if (bsbObj instanceof BSBGroup) {
                ((BSBGroup)bsbObj).removeParameters();
                continue;
            }
            if (!(bsbObj instanceof AutomatableBSBObject)) continue;
            ((AutomatableBSBObject)bsbObj).setAutomationAllowed(false);
        }
    }

    public final void setGroupName(String value) {
        this.groupName.set((Object)value);
    }

    public final String getGroupName() {
        return (String)this.groupName.get();
    }

    public final StringProperty groupNameProperty() {
        return this.groupName;
    }

    public final void setWidth(int value) {
        this.width.set(value);
    }

    public final int getWidth() {
        return this.width.get();
    }

    public final IntegerProperty widthProperty() {
        return this.width;
    }

    public final void setHeight(int value) {
        this.height.set(value);
    }

    public final int getHeight() {
        return this.height.get();
    }

    public final IntegerProperty heightProperty() {
        return this.height;
    }

    public boolean contains(BSBObject bsbObj) {
        return this.interfaceItems.contains((Object)bsbObj);
    }

    private void makeNamesUnique(UniqueNameManager unm, Set<String> additionalNames) {
        if (unm == null) {
            return;
        }
        for (BSBObject bsbObj : this.interfaceItems) {
            if (bsbObj instanceof BSBGroup) {
                ((BSBGroup)bsbObj).makeNamesUnique(unm, additionalNames);
                continue;
            }
            String objName = bsbObj.getObjectName();
            if (objName == null || objName.length() == 0 || unm == null || unm.isUniquelyNamed(bsbObj)) continue;
            unm.setUniqueName(bsbObj);
            additionalNames.addAll(Arrays.asList(bsbObj.getReplacementKeys()));
        }
    }
}

