/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra;

import blue.orchestra.Instrument;
import blue.utility.ListUtil;
import blue.utility.ObjectUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class InstrumentCategory {
    private String categoryName = "New Instrument Category";
    private List<InstrumentCategory> subCategories = new Vector<InstrumentCategory>();
    private List<Instrument> instruments = new Vector<Instrument>();
    private boolean isRoot = false;

    public InstrumentCategory() {
    }

    public InstrumentCategory(InstrumentCategory ec) {
        this.categoryName = ec.categoryName;
        this.isRoot = ec.isRoot;
        for (InstrumentCategory ic : ec.subCategories) {
            this.subCategories.add(new InstrumentCategory(ic));
        }
        for (Instrument instr : ec.instruments) {
            this.instruments.add((Instrument)instr.deepCopy());
        }
    }

    public String toString() {
        return this.getCategoryName();
    }

    public boolean removeInstrument(Instrument instr) {
        int index = ListUtil.indexOfByRef(this.instruments, instr);
        if (index >= 0) {
            this.instruments.remove(index);
            return true;
        }
        for (InstrumentCategory category : this.subCategories) {
            if (!category.removeInstrument(instr)) continue;
            return true;
        }
        return false;
    }

    public boolean removeInstrumentCategory(InstrumentCategory category) {
        int index = ListUtil.indexOfByRef(this.subCategories, category);
        if (index >= 0) {
            this.subCategories.remove(index);
            return true;
        }
        for (InstrumentCategory tempCategory : this.subCategories) {
            if (!tempCategory.removeInstrumentCategory(category)) continue;
            return true;
        }
        return false;
    }

    public void addInstrumentCategory(InstrumentCategory category) {
        this.subCategories.add(category);
    }

    public void addInstrument(int insertIndex, Instrument instrument) {
        this.instruments.add(insertIndex, instrument);
    }

    public void addInstrument(Instrument instrument) {
        this.instruments.add(instrument);
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public List getInstruments() {
        return this.instruments;
    }

    public void setInstruments(ArrayList<Instrument> instruments) {
        this.instruments = instruments;
    }

    public List getSubCategories() {
        return this.subCategories;
    }

    public void setSubCategories(ArrayList<InstrumentCategory> subCategories) {
        this.subCategories = subCategories;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public static InstrumentCategory loadFromXML(Element data) throws Exception {
        InstrumentCategory instrCat = new InstrumentCategory();
        instrCat.setCategoryName(data.getAttributeValue("categoryName"));
        instrCat.setRoot(Boolean.valueOf(data.getAttributeValue("isRoot")));
        Elements subCatNodes = data.getElements("instrumentCategory");
        while (subCatNodes.hasMoreElements()) {
            instrCat.addInstrumentCategory(InstrumentCategory.loadFromXML(subCatNodes.next()));
        }
        Elements instruments = data.getElements("instrument");
        while (instruments.hasMoreElements()) {
            instrCat.addInstrument((Instrument)ObjectUtilities.loadFromXML(instruments.next()));
        }
        return instrCat;
    }

    public Element saveAsXML() {
        Element retVal = new Element("instrumentCategory");
        retVal.setAttribute("categoryName", this.getCategoryName());
        retVal.setAttribute("isRoot", Boolean.toString(this.isRoot()));
        for (InstrumentCategory tempCat : this.subCategories) {
            retVal.addElement(tempCat.saveAsXML());
        }
        for (Instrument instr : this.instruments) {
            retVal.addElement(instr.saveAsXML());
        }
        return retVal;
    }

    public String getInstrumentId(Instrument instr) {
        if (ListUtil.containsByRef(this.instruments, instr)) {
            return Integer.toString(ListUtil.indexOfByRef(this.instruments, instr));
        }
        int counter = 0;
        for (InstrumentCategory cat : this.subCategories) {
            String instrId = cat.getInstrumentId(instr);
            if (instrId != null) {
                return counter + ":" + instrId;
            }
            ++counter;
        }
        return null;
    }

    public Instrument getInstrumentById(int[] idArray, int index) {
        if (index == idArray.length - 1) {
            return this.instruments.get(idArray[index]);
        }
        InstrumentCategory cat = this.subCategories.get(idArray[index]);
        return cat.getInstrumentById(idArray, index + 1);
    }
}

