/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.noteProcessor.Code;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.scripting.PythonProxy;
import blue.soundObject.NoteList;
import electric.xml.Element;
import org.python.core.PyException;

public class PythonProcessor
implements NoteProcessor {
    private Code code;

    public PythonProcessor() {
        this.code = new Code();
    }

    public PythonProcessor(PythonProcessor pp) {
        this.code = new Code(pp.code);
    }

    @Override
    public void processNotes(NoteList in) throws NoteProcessorException {
        try {
            PythonProxy.processPythonNoteProcessor(in, this.code.getCode());
        }
        catch (PyException pyEx) {
            String msg = "Python NoteProcessor Error:\n" + pyEx.toString();
            throw new NoteProcessorException(this, msg);
        }
    }

    public String toString() {
        return "[python]";
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public static NoteProcessor loadFromXML(Element data) {
        PythonProcessor ap = new PythonProcessor();
        ap.getCode().setCode(data.getTextString("code"));
        return ap;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("code").setText(this.getCode().getCode());
        return retVal;
    }

    @Override
    public PythonProcessor deepCopy() {
        return new PythonProcessor(this);
    }
}

