/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.noteProcessor.ValueTimeMapper;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import electric.xml.Element;

public class LineMultiplyProcessor
implements NoteProcessor {
    private String lineMultiplyString = "0 0";
    private int pfield = 4;

    public LineMultiplyProcessor() {
    }

    public LineMultiplyProcessor(LineMultiplyProcessor lmp) {
        this.lineMultiplyString = lmp.lineMultiplyString;
        this.pfield = lmp.pfield;
    }

    @Override
    public void processNotes(NoteList in) throws NoteProcessorException {
        double oldVal = 0.0;
        double multiplyVal = 0.0;
        ValueTimeMapper tm = ValueTimeMapper.createValueTimeMapper(this.lineMultiplyString);
        if (tm == null) {
            throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.lineMultStringErr"), this.pfield);
        }
        for (int i = 0; i < in.size(); ++i) {
            Note temp = (Note)in.get(i);
            try {
                oldVal = Double.parseDouble(temp.getPField(this.pfield));
                multiplyVal = tm.getValueForBeat(temp.getStartTime());
            }
            catch (NumberFormatException ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.pfieldNotDouble"), this.pfield);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
            if (Double.isNaN(multiplyVal)) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.noteBeatErr"), this.pfield);
            }
            temp.setPField(Double.toString(oldVal * multiplyVal), this.pfield);
        }
    }

    public String toString() {
        return "[line multiply]";
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i + " 1 3 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        LineMultiplyProcessor lmp = new LineMultiplyProcessor();
        lmp.setLineMultiplyString("0 0 5 1 9 0");
        try {
            lmp.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        this.pfield = Integer.parseInt(pfield);
    }

    public String getLineMultiplyString() {
        return this.lineMultiplyString;
    }

    public void setLineMultiplyString(String string) {
        this.lineMultiplyString = string;
    }

    public static NoteProcessor loadFromXML(Element data) {
        LineMultiplyProcessor lmp = new LineMultiplyProcessor();
        lmp.setPfield(data.getElement("pfield").getTextString());
        lmp.setLineMultiplyString(data.getElement("lineMultiplyString").getTextString());
        return lmp;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(this.getPfield());
        retVal.addElement("lineMultiplyString").setText(this.getLineMultiplyString());
        return retVal;
    }

    @Override
    public LineMultiplyProcessor deepCopy() {
        return new LineMultiplyProcessor(this);
    }
}

