/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.TranslateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.controlsfx.control.ToggleSwitch;

public class ToggleSwitchSkin
extends SkinBase<ToggleSwitch> {
    private final StackPane thumb = new StackPane();
    private final StackPane thumbArea = new StackPane();
    private final Label label = new Label();
    private final StackPane labelContainer = new StackPane();
    private final TranslateTransition transition = new TranslateTransition(Duration.millis((double)this.getThumbMoveAnimationTime()), (Node)this.thumb);
    private DoubleProperty thumbMoveAnimationTime = null;
    private static final CssMetaData<ToggleSwitch, Number> THUMB_MOVE_ANIMATION_TIME = new CssMetaData<ToggleSwitch, Number>("-thumb-move-animation-time", SizeConverter.getInstance(), (Number)200){

        public boolean isSettable(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return skin.thumbMoveAnimationTime == null || !skin.thumbMoveAnimationTime.isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return (StyleableProperty)skin.thumbMoveAnimationTimeProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public ToggleSwitchSkin(ToggleSwitch control) {
        super((Control)control);
        this.label.textProperty().bind((ObservableValue)control.textProperty());
        this.getChildren().addAll((Object[])new Node[]{this.labelContainer, this.thumbArea, this.thumb});
        this.labelContainer.getChildren().addAll((Object[])new Node[]{this.label});
        StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER_LEFT);
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumbArea.getStyleClass().setAll((Object[])new String[]{"thumb-area"});
        this.thumbArea.setOnMouseReleased(event -> this.mousePressedOnToggleSwitch(control));
        this.thumb.setOnMouseReleased(event -> this.mousePressedOnToggleSwitch(control));
        control.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() != oldValue.booleanValue()) {
                this.selectedStateChanged();
            }
        });
    }

    private void selectedStateChanged() {
        if (this.transition != null) {
            this.transition.stop();
        }
        double thumbAreaWidth = this.snapSize(this.thumbArea.prefWidth(-1.0));
        double thumbWidth = this.snapSize(this.thumb.prefWidth(-1.0));
        double distance = thumbAreaWidth - thumbWidth;
        if (!((ToggleSwitch)this.getSkinnable()).isSelected()) {
            this.thumb.setLayoutX(this.thumbArea.getLayoutX());
            this.transition.setFromX(distance);
            this.transition.setToX(0.0);
        } else {
            this.thumb.setTranslateX(this.thumbArea.getLayoutX());
            this.transition.setFromX(0.0);
            this.transition.setToX(distance);
        }
        this.transition.setCycleCount(1);
        this.transition.play();
    }

    private void mousePressedOnToggleSwitch(ToggleSwitch toggleSwitch) {
        toggleSwitch.setSelected(!toggleSwitch.isSelected());
    }

    private DoubleProperty thumbMoveAnimationTimeProperty() {
        if (this.thumbMoveAnimationTime == null) {
            this.thumbMoveAnimationTime = new StyleableDoubleProperty(200.0){

                public Object getBean() {
                    return ToggleSwitchSkin.this;
                }

                public String getName() {
                    return "thumbMoveAnimationTime";
                }

                public CssMetaData<ToggleSwitch, Number> getCssMetaData() {
                    return THUMB_MOVE_ANIMATION_TIME;
                }
            };
        }
        return this.thumbMoveAnimationTime;
    }

    private double getThumbMoveAnimationTime() {
        return this.thumbMoveAnimationTime == null ? 200.0 : this.thumbMoveAnimationTime.get();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        ToggleSwitch toggleSwitch = (ToggleSwitch)this.getSkinnable();
        double thumbWidth = this.snapSize(this.thumb.prefWidth(-1.0));
        double thumbHeight = this.snapSize(this.thumb.prefHeight(-1.0));
        this.thumb.resize(thumbWidth, thumbHeight);
        if (this.transition != null) {
            this.transition.stop();
        }
        this.thumb.setTranslateX(0.0);
        double thumbAreaY = this.snapPosition(contentY);
        double thumbAreaWidth = this.snapSize(this.thumbArea.prefWidth(-1.0));
        double thumbAreaHeight = this.snapSize(this.thumbArea.prefHeight(-1.0));
        this.thumbArea.resize(thumbAreaWidth, thumbAreaHeight);
        this.thumbArea.setLayoutX(contentWidth - thumbAreaWidth);
        this.thumbArea.setLayoutY(thumbAreaY);
        this.labelContainer.resize(contentWidth - thumbAreaWidth, thumbAreaHeight);
        this.labelContainer.setLayoutY(thumbAreaY);
        if (!toggleSwitch.isSelected()) {
            this.thumb.setLayoutX(this.thumbArea.getLayoutX());
        } else {
            this.thumb.setLayoutX(this.thumbArea.getLayoutX() + thumbAreaWidth - thumbWidth);
        }
        this.thumb.setLayoutY(thumbAreaY + (thumbAreaHeight - thumbHeight) / 2.0);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.prefWidth(-1.0) + this.thumbArea.prefWidth(-1.0) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.prefWidth(-1.0) + 20.0 + this.thumbArea.prefWidth(-1.0) + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + bottomInset;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ToggleSwitchSkin.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<ToggleSwitch, Number>> styleables = new ArrayList<CssMetaData<ToggleSwitch, Number>>(SkinBase.getClassCssMetaData());
        styleables.add(THUMB_MOVE_ANIMATION_TIME);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

