/*
 * Decompiled with CFR 0.152.
 */
package blue.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextUtilities {
    public static String replace(String string, String oldSubstring, String newSubstring) {
        String result = string;
        if (string != null && string.length() > 0 && oldSubstring != null && oldSubstring.length() > 0 && newSubstring != null) {
            int pos = string.indexOf(oldSubstring);
            result = string.substring(0, pos) + newSubstring + string.substring(pos + oldSubstring.length());
        }
        return result;
    }

    public static String replaceAll(String string, String oldSubstring, String newSubstring) {
        String result = string;
        if (result != null && result.length() > 0 && result.contains(oldSubstring) && oldSubstring.length() > 0 && !oldSubstring.equals(newSubstring) && newSubstring != null) {
            while (result.contains(oldSubstring)) {
                result = TextUtilities.replace(result, oldSubstring, newSubstring);
            }
        }
        return result;
    }

    public static String removeAll(String inputString, String removeString) {
        StringBuilder updateString = new StringBuilder();
        for (int a = 0; a < inputString.length(); ++a) {
            String tmpString = inputString.substring(a, a + 1);
            if (tmpString.equals(removeString)) continue;
            updateString.append(tmpString);
        }
        return updateString.toString();
    }

    public static String getTextFromFile(File textFile) throws FileNotFoundException, IOException {
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(textFile));){
            String line;
            while ((line = br.readLine()) != null) {
                buffer.append(line).append("\n");
            }
        }
        return buffer.toString();
    }

    public static ArrayList<String> getLinesFromFile(File textFile, boolean trim) throws FileNotFoundException, IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(textFile));){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(trim ? line.trim() : line);
            }
        }
        return lines;
    }

    public static String getTextFromSystemResource(String resource) {
        try {
            String buffer;
            BufferedReader br = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(resource)));
            StringBuilder text = new StringBuilder();
            while ((buffer = br.readLine()) != null) {
                text.append(buffer).append("\n");
            }
            return text.toString();
        }
        catch (Exception e) {
            return "Error getting resource: " + resource;
        }
    }

    public static String getTextBetweenTags(String tag, String searchText) {
        String startTag = "<" + tag + ">";
        String endTag = "</" + tag + ">";
        int index1 = searchText.indexOf(startTag);
        int index2 = searchText.indexOf(endTag);
        if (index1 == -1 || index2 == -1) {
            return null;
        }
        return searchText.substring(index1 += startTag.length(), index2);
    }

    public static String[] splitStringWithQuotes(String in) {
        char[] chars = in.trim().toCharArray();
        int state = 0;
        ArrayList<String> wordList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        block6: for (int i = 0; i < chars.length; ++i) {
            switch (state) {
                case 0: {
                    if (chars[i] == '\t' || chars[i] == ' ') continue block6;
                    if (chars[i] == '\"') {
                        state = 2;
                        continue block6;
                    }
                    if (chars[i] == '{') {
                        state = 3;
                        continue block6;
                    }
                    buffer.append(chars[i]);
                    state = 1;
                    continue block6;
                }
                case 1: {
                    if (chars[i] == ' ' || chars[i] == '\t') {
                        wordList.add(buffer.toString());
                        buffer = new StringBuffer();
                        state = 0;
                        continue block6;
                    }
                    buffer.append(chars[i]);
                    continue block6;
                }
                case 2: {
                    if (chars[i] == '\"') {
                        wordList.add(buffer.toString());
                        buffer = new StringBuffer();
                        state = 0;
                        continue block6;
                    }
                    buffer.append(chars[i]);
                    continue block6;
                }
                case 3: {
                    if (chars[i] == '}') {
                        wordList.add(buffer.toString());
                        buffer = new StringBuffer();
                        state = 0;
                        continue block6;
                    }
                    buffer.append(chars[i]);
                }
            }
        }
        wordList.add(buffer.toString());
        String[] retVal = new String[wordList.size()];
        wordList.toArray(retVal);
        return retVal;
    }

    public static String stripSingleLineComments(String in) {
        String retVal = in.replaceAll("(//|;).*", "");
        return retVal;
    }

    public static String stripMultiLineComments(String in) {
        Pattern p = Pattern.compile("/\\*.*\\*/", 40);
        Matcher m = p.matcher(in);
        String retVal = m.replaceAll("\n");
        return retVal;
    }

    public static String replaceOpcodeNames(Map<String, String> replacementValues, String input) {
        String retVal = input;
        for (Map.Entry<String, String> entry : replacementValues.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            retVal = retVal.replaceAll("(^|\\s)" + key + "($|\\s)", "$1" + value + "$2");
        }
        return retVal;
    }
}

