/*
 * Decompiled with CFR 0.152.
 */
package blue.jfx.binding;

import blue.jfx.BlueFX;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.TextField;

public class DoubleBinder<T> {
    AtomicBoolean committing = new AtomicBoolean(false);
    private final WeakReference<TextField> textField;
    private WeakReference<DoubleProperty> doubleProperty = null;
    private BiFunction<T, Double, Double> filter;
    ChangeListener<? super Number> cl;
    private WeakReference<T> bean = null;

    public DoubleBinder(TextField tf) {
        this(tf, null);
    }

    public DoubleBinder(TextField tf, BiFunction<T, Double, Double> filter) {
        this.textField = new WeakReference<TextField>(tf);
        this.filter = filter;
        tf.focusedProperty().addListener((obs, o, n) -> {
            if (o.booleanValue() && !n.booleanValue()) {
                BlueFX.runOnFXThread(() -> this.updateValueFromTextFieldOrReset());
            }
        });
        tf.setOnAction(evt -> BlueFX.runOnFXThread(() -> this.updateValueFromTextFieldOrReset()));
        this.cl = (obs, oldVal, newVal) -> {
            TextField text = (TextField)this.textField.get();
            if (text != null) {
                BlueFX.runOnFXThread(() -> text.setText(newVal.toString()));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValueFromTextFieldOrReset() {
        TextField tf;
        DoubleProperty fp;
        if (this.doubleProperty == null || (fp = (DoubleProperty)this.doubleProperty.get()) == null || (tf = (TextField)this.textField.get()) == null) {
            return;
        }
        boolean inCommit = this.committing.getAndSet(true);
        try {
            if (!inCommit) {
                Double f = Double.parseDouble(tf.getText());
                if (this.filter != null) {
                    f = this.filter.apply(this.bean.get(), f);
                }
                if (f != null) {
                    fp.setValue((Number)f);
                } else {
                    tf.setText(fp.getValue().toString());
                }
            }
        }
        catch (Exception e) {
            tf.setText(fp.getValue().toString());
        }
        finally {
            this.committing.set(false);
        }
    }

    public void setDoubleProperty(T bean, DoubleProperty prop) {
        DoubleProperty fp = this.doubleProperty == null ? null : (DoubleProperty)this.doubleProperty.get();
        TextField tf = (TextField)this.textField.get();
        if (tf == null) {
            return;
        }
        if (fp != null) {
            fp.removeListener(this.cl);
        }
        this.doubleProperty = null;
        BlueFX.runOnFXThread(() -> tf.setText(prop.getValue().toString()));
        this.doubleProperty = new WeakReference<DoubleProperty>(prop);
        prop.addListener(this.cl);
        this.bean = new WeakReference<T>(bean);
    }
}

