/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.ceciliaModule;

import blue.Arrangement;
import blue.BlueSystem;
import blue.GlobalOrcSco;
import blue.Tables;
import blue.orchestra.GenericInstrument;
import blue.orchestra.Instrument;
import blue.soundObject.CeciliaModule;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.ceciliaModule.CFileIn;
import blue.soundObject.ceciliaModule.CGraph;
import blue.soundObject.ceciliaModule.CGraphPoint;
import blue.soundObject.ceciliaModule.CSlider;
import blue.soundObject.ceciliaModule.CToggle;
import blue.soundObject.ceciliaModule.CeciliaObject;
import blue.soundObject.ceciliaModule.TCLScoreCompiler;
import blue.soundObject.ceciliaModule.cybil.CybilCompiler;
import blue.utility.ScoreUtilities;
import blue.utility.TextUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CeciliaModuleCompilationUnit {
    private static long uniqueIDCount = 0L;
    private long uniqueID;
    String globalOrc = "";
    HashMap instruments = new LinkedHashMap();
    HashMap instrIDMap = new HashMap();
    Instrument magicInstrument = null;
    HashMap ftables = new HashMap();
    HashMap ftableNumMap = new HashMap();
    HashMap<String, String> ceciliaVariables = new HashMap();
    ArrayList magicInstrument_instr = new ArrayList();
    ArrayList magicInstrument_tables = new ArrayList();
    ArrayList magicInstrument_gen_nums = new ArrayList();
    int magicInstrId = Integer.MIN_VALUE;
    NoteList notes = new NoteList();
    private static Pattern sinfoPattern = null;
    private CeciliaModule cm;

    private static long generateUniqueID() {
        return uniqueIDCount++;
    }

    public CeciliaModuleCompilationUnit(CeciliaModule cm) {
        this.cm = cm;
        this.uniqueID = CeciliaModuleCompilationUnit.generateUniqueID();
        String orch = this.getOrchestraByVersion(cm);
        this.parseStateData(cm);
        this.parseOrchestra(orch);
    }

    private void parseStateData(CeciliaModule cm) {
        HashMap stateData = cm.getStateData();
        StringBuffer orcBuffer = new StringBuffer();
        for (CeciliaObject stateObj : stateData.values()) {
            if (stateObj instanceof CToggle) {
                orcBuffer.append(((CToggle)stateObj).generateToggleText());
                continue;
            }
            if (stateObj instanceof CGraph) {
                CGraph graph = (CGraph)stateObj;
                String optext = "gk" + graph.getObjectName() + "_" + this.uniqueID + " oscil1i 0, 1, p3, f#";
                String ftext = this.createMagicInstrumentTable(graph, Integer.parseInt(cm.getGenSize()));
                this.magicInstrument_instr.add(optext);
                this.magicInstrument_tables.add(ftext);
                this.magicInstrument_gen_nums.add(Integer.toString(graph.getGen()));
                String initText = "gk" + graph.getObjectName();
                initText = initText + " init ";
                CGraphPoint point = graph.getPoints().get(0);
                double max = graph.getMax();
                double min = graph.getMax();
                double range = max - min;
                double val = point.value * range + min;
                initText = initText + val + "\n";
                orcBuffer.append(initText);
                continue;
            }
            if (stateObj instanceof CSlider) {
                CSlider slider = (CSlider)stateObj;
                orcBuffer.append(slider.generateSliderText());
                this.ceciliaVariables.put(slider.getObjectName(), slider.getValueAsString());
                continue;
            }
            if (!(stateObj instanceof CFileIn)) continue;
            CFileIn cfileIn = (CFileIn)stateObj;
            this.ceciliaVariables.put(cfileIn.getObjectName(), cfileIn.getFileName());
            if (!cfileIn.isAudioFile()) continue;
            double val = (float)cfileIn.getOffset() / 10.0f;
            this.ceciliaVariables.put("off" + cfileIn.getObjectName(), Double.toString(val));
        }
        String totalTime = Double.toString(cm.getSubjectiveDuration());
        this.ceciliaVariables.put("total_time", totalTime);
        this.ceciliaVariables.put("duree_totale", totalTime);
        this.globalOrc = this.globalOrc + orcBuffer.toString();
    }

    private String createMagicInstrumentTable(CGraph graph, int genSize) {
        ArrayList<CGraphPoint> points = graph.getPoints();
        double range = graph.getMax() - graph.getMin();
        double min = graph.getMin();
        StringBuffer tableString = new StringBuffer();
        boolean firstPoint = true;
        double runningTime = 0.0;
        for (CGraphPoint point : points) {
            if (firstPoint) {
                double value = point.value * range + min;
                tableString.append(value);
                firstPoint = false;
                continue;
            }
            double time = point.time * (double)genSize;
            double value = point.value * range + min;
            tableString.append(" ").append(time - runningTime).append(" ").append(value);
            runningTime = time;
        }
        tableString.append(" ;");
        tableString.append(graph.getLabel());
        return tableString.toString();
    }

    public void generateGlobals(GlobalOrcSco globalOrcSco) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.globalOrc);
        for (String line : this.magicInstrument_instr) {
            buffer.append(line).append("\n");
        }
        globalOrcSco.appendGlobalOrc(this.setGlobalUnique(this.globalOrc));
    }

    private String setGlobalUnique(String string) {
        String output = string.replaceAll("(g[ika]\\w*)", "$1_" + this.uniqueID);
        return output;
    }

    private String setFtableUnique(String text) {
        String retVal = text;
        ArrayList keyset = new ArrayList(this.ftableNumMap.keySet());
        Collections.sort(keyset, (o1, o2) -> Integer.parseInt((String)o1) - Integer.parseInt((String)o2));
        for (int i = keyset.size() - 1; i >= 0; --i) {
            String oldNum = (String)keyset.get(i);
            String newNum = (String)this.ftableNumMap.get(oldNum);
            retVal = TextUtilities.replaceAll((String)retVal, (String)("ftable" + oldNum), (String)newNum);
        }
        return retVal;
    }

    public void generateFTables(CeciliaModule cm, Tables tables) {
        int newNum;
        StringBuffer newTableText = new StringBuffer();
        for (String oldNum : this.ftables.keySet()) {
            String tableText = (String)this.ftables.get(oldNum);
            newNum = tables.getOpenFTableNumber();
            newTableText.append("f");
            newTableText.append(Integer.toString(newNum));
            newTableText.append("\t");
            newTableText.append(tableText);
            newTableText.append("\n");
            this.ftableNumMap.put(oldNum, Integer.toString(newNum));
        }
        for (int i = 0; i < this.magicInstrument_tables.size(); ++i) {
            String tableText = (String)this.magicInstrument_tables.get(i);
            String instrTextLine = (String)this.magicInstrument_instr.get(i);
            newNum = tables.getOpenFTableNumber();
            String newNumText = Integer.toString(newNum);
            newTableText.append("f");
            newTableText.append(newNumText);
            newTableText.append(" 0 ");
            newTableText.append(cm.getGenSize());
            newTableText.append(" -7 ");
            newTableText.append("\t");
            newTableText.append(tableText);
            newTableText.append("\n");
            instrTextLine = TextUtilities.replace((String)instrTextLine, (String)"f#", (String)newNumText);
            this.magicInstrument_instr.set(i, instrTextLine);
            String genNum = (String)this.magicInstrument_gen_nums.get(i);
            if (genNum.equals("-1")) continue;
            this.ftableNumMap.put(genNum, newNumText);
        }
        tables.setTables(tables.getTables() + "\n" + newTableText.toString());
    }

    public void generateInstruments(Arrangement arrangement) {
        Instrument magicInstrument = this.getMagicInstrument();
        if (magicInstrument != null) {
            this.magicInstrId = arrangement.addInstrument(magicInstrument);
        }
        for (String key : this.instruments.keySet()) {
            GenericInstrument instr = (GenericInstrument)this.instruments.get(key);
            instr.setText(this.setGlobalUnique(instr.getText()));
            instr.setText(this.setFtableUnique(instr.getText()));
            instr.setText(this.replaceCeciliaVariables(instr.getText()));
            int newNum = arrangement.addInstrument((Instrument)instr);
            String newId = Integer.toString(newNum);
            this.instrIDMap.put(key.trim(), newId);
        }
    }

    private String replaceCeciliaVariables(String text) {
        String retVal = text;
        this.appendSinfoVariables(retVal);
        for (String key : this.ceciliaVariables.keySet()) {
            String val = this.ceciliaVariables.get(key);
            retVal = TextUtilities.replaceAll((String)retVal, (String)("[" + key + "]"), (String)val);
            retVal = TextUtilities.replaceAll((String)retVal, (String)("$value(" + key + ")"), (String)val);
        }
        return retVal;
    }

    private void appendSinfoVariables(String retVal) {
        Matcher matcher = sinfoPattern.matcher(retVal);
        if (sinfoPattern != null) {
            block14: while (matcher.find()) {
                CFileIn cfilein;
                String key = matcher.group();
                String result = key.substring(1, key.length() - 1);
                String objectName = matcher.group(1);
                String prop = matcher.group(2);
                try {
                    cfilein = (CFileIn)this.cm.getStateData().get(objectName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
                String val = null;
                switch (prop) {
                    case "sr": {
                        val = Double.toString(cfilein.getSampleRate());
                        break;
                    }
                    case "frames": {
                        val = Integer.toString(cfilein.getFrames());
                        break;
                    }
                    case "dur": {
                        val = Double.toString(cfilein.getDuration());
                        break;
                    }
                    case "chn": {
                        val = Integer.toString(cfilein.getChannels());
                        break;
                    }
                    default: {
                        String errMessage = "[" + BlueSystem.getString((String)"message.error") + "] - " + BlueSystem.getString((String)"ceciliaModule.propNotFound") + " ";
                        System.err.println(errMessage + prop);
                        break block14;
                    }
                }
                if (val == null) {
                    String errMessage = "[" + BlueSystem.getString((String)"message.error") + "] - " + BlueSystem.getString((String)"ceciliaModule.valueNotFound") + " ";
                    System.err.println(errMessage + prop);
                    break;
                }
                this.ceciliaVariables.put(result, val);
            }
        }
    }

    private Instrument getMagicInstrument() {
        if (this.magicInstrument_instr.size() == 0) {
            return null;
        }
        GenericInstrument instr = new GenericInstrument();
        StringBuffer instrText = new StringBuffer();
        for (String line : this.magicInstrument_instr) {
            instrText.append(line).append("\n");
        }
        instr.setText(instrText.toString());
        instr.setName("CeciliaModule Magic Instrument");
        return instr;
    }

    public NoteList generateNotes(CeciliaModule cm) throws NoteParseException {
        this.parseScore(cm, cm.getModuleDefinition().score.trim());
        NoteList nl = new NoteList();
        if (this.magicInstrId != Integer.MIN_VALUE) {
            String magicNote = "i" + Integer.toString(this.magicInstrId) + " 0 " + cm.getSubjectiveDuration();
            nl.add((Object)Note.createNote((String)magicNote));
        }
        for (Note note : this.notes) {
            String id = note.getPField(1).trim();
            String newId = (String)this.instrIDMap.get(id);
            note.setPField(newId, 1);
            nl.add((Object)note);
        }
        ScoreUtilities.applyTimeBehavior((NoteList)nl, (int)0, (double)cm.getSubjectiveDuration(), (double)cm.getRepeatPoint());
        ScoreUtilities.setScoreStart((NoteList)nl, (double)cm.getStartTime());
        return nl;
    }

    private void parseScore(CeciliaModule cm, String scoreText) throws NoteParseException {
        if (scoreText.startsWith("#min")) {
            String noteLine = "i1 0 " + Double.toString(cm.getSubjectiveDuration());
            this.notes.add((Object)Note.createNote((String)noteLine));
        } else if (scoreText.startsWith("#cyb")) {
            scoreText = this.replaceCeciliaVariables(scoreText);
            scoreText = CybilCompiler.compile(scoreText, cm);
            this.parseFlatScore(scoreText);
        } else if (scoreText.startsWith("#tcl")) {
            scoreText = this.replaceCeciliaVariables(scoreText);
            System.out.println(scoreText);
            scoreText = TCLScoreCompiler.compile(scoreText);
            this.parseFlatScore(scoreText);
        } else {
            this.parseFlatScore(scoreText);
        }
    }

    private void parseFlatScore(String scoreText) throws NoteParseException {
        StringTokenizer st = new StringTokenizer(scoreText, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (line.startsWith("i")) {
                line = this.replaceCeciliaVariables(line);
                this.notes.add((Object)Note.createNote((String)line));
                continue;
            }
            if (line.startsWith("f")) {
                line = line.substring(1).trim();
                String tableNum = this.getFTableNum(line);
                String strippedTable = line.substring(tableNum.length());
                this.ftables.put(tableNum, strippedTable);
                continue;
            }
            System.err.println(BlueSystem.getString((String)"ceciliaModule.lineNotUsed") + " " + line);
        }
    }

    private String getFTableNum(String line) {
        int index = 0;
        String tableNum = "";
        while (line.charAt(index) != ' ' && line.charAt(index) != '\t' && line.charAt(index) != '\n') {
            tableNum = tableNum + line.charAt(index);
            ++index;
        }
        return tableNum;
    }

    private void parseOrchestra(String orch) {
        StringTokenizer st = new StringTokenizer(orch, "\n");
        StringBuffer globalBuffer = new StringBuffer();
        StringBuffer instrBuffer = new StringBuffer();
        String instrID = "";
        int mode = 0;
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            switch (mode) {
                case 0: {
                    if (line.startsWith("instr")) {
                        int index = line.indexOf(59);
                        if (index != -1) {
                            line = line.substring(0, index);
                        }
                        line = line.substring(line.indexOf("instr") + 5);
                        instrID = line.trim();
                        mode = 1;
                        break;
                    }
                    if (line.startsWith("kr") || line.startsWith("sr") || line.startsWith("ksmps") || line.startsWith("nchnls")) break;
                    globalBuffer.append(line).append("\n");
                    break;
                }
                case 1: {
                    if (line.startsWith("endin")) {
                        GenericInstrument instr = new GenericInstrument();
                        instr.setText(instrBuffer.toString());
                        if (instrID.indexOf(",") > 0) {
                            StringTokenizer idTokenizer = new StringTokenizer(instrID, ",");
                            while (idTokenizer.hasMoreElements()) {
                                String id = idTokenizer.nextToken();
                                this.instruments.put(id, instr.deepCopy());
                            }
                        } else {
                            this.instruments.put(instrID, instr);
                        }
                        instrID = "";
                        instrBuffer = new StringBuffer();
                        mode = 0;
                        break;
                    }
                    instrBuffer.append(line).append("\n");
                }
            }
        }
        this.globalOrc = this.globalOrc + globalBuffer.toString();
    }

    private String getOrchestraByVersion(CeciliaModule cm) {
        String orch = "";
        switch (cm.getOrchestraVersion()) {
            case 0: {
                orch = cm.getModuleDefinition().mono;
                break;
            }
            case 1: {
                orch = cm.getModuleDefinition().stereo;
                break;
            }
            case 2: {
                orch = cm.getModuleDefinition().quad;
            }
        }
        return orch;
    }

    static {
        try {
            sinfoPattern = Pattern.compile("\\[sinfo\\s+(\\w+)\\s+(\\w+)\\]");
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
        }
    }
}

