/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class ProcCmd
implements Command {
    ProcCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 4) {
            throw new TclNumArgsException(interp, 1, objv, "name args body");
        }
        String fullName = objv[1].toString();
        NamespaceCmd.Namespace[] nsArr = new NamespaceCmd.Namespace[1];
        NamespaceCmd.Namespace[] altNsArr = new NamespaceCmd.Namespace[1];
        NamespaceCmd.Namespace[] cxtNsArr = new NamespaceCmd.Namespace[1];
        String[] procNameArr = new String[1];
        NamespaceCmd.getNamespaceForQualName(interp, fullName, null, 0, nsArr, altNsArr, cxtNsArr, procNameArr);
        NamespaceCmd.Namespace ns = nsArr[0];
        NamespaceCmd.Namespace altNs = altNsArr[0];
        NamespaceCmd.Namespace cxtNs = cxtNsArr[0];
        String procName = procNameArr[0];
        if (ns == null) {
            throw new TclException(interp, "can't create procedure \"" + fullName + "\": unknown namespace");
        }
        if (procName == null) {
            throw new TclException(interp, "can't create procedure \"" + fullName + "\": bad procedure name");
        }
        if (ns != NamespaceCmd.getGlobalNamespace(interp) && procName != null && procName.length() > 0 && procName.charAt(0) == ':') {
            throw new TclException(interp, "can't create procedure \"" + procName + "\" in non-global namespace with name starting with \":\"");
        }
        Procedure proc = new Procedure(interp, ns, procName, objv[2], objv[3], interp.getScriptFile(), interp.getArgLineNumber(3));
        StringBuffer ds = new StringBuffer();
        if (ns != NamespaceCmd.getGlobalNamespace(interp)) {
            ds.append(ns.fullName);
            ds.append("::");
        }
        ds.append(procName);
        interp.createCommand(ds.toString(), proc);
    }
}

