/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.settings.GeneralOptionsPanelController;
import blue.settings.GeneralSettings;
import blue.settings.SettingsFileChooser;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class GeneralPanel
extends JPanel {
    private final GeneralOptionsPanelController controller;
    private boolean loading = false;
    private JCheckBox alphaEnabled;
    private JCheckBox csoundErrorWarningEnabled;
    private JTextField defaultDirectoryField;
    private JButton directoryOpenButton;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JCheckBox messageColorsEnabled;
    private JCheckBox newUserDefaultsEnabled;

    GeneralPanel(GeneralOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        SimpleDocumentListener changeListener = new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!GeneralPanel.this.loading) {
                    GeneralPanel.this.controller.changed();
                }
            }
        };
        this.defaultDirectoryField.getDocument().addDocumentListener((DocumentListener)changeListener);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.csoundErrorWarningEnabled = new JCheckBox();
        this.messageColorsEnabled = new JCheckBox();
        this.alphaEnabled = new JCheckBox();
        this.newUserDefaultsEnabled = new JCheckBox();
        this.defaultDirectoryField = new JTextField();
        this.directoryOpenButton = new JButton();
        this.jLabel2.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GeneralPanel.class, (String)"GeneralPanel.jLabel2.text_1"));
        this.jLabel2.setAlignmentX(1.0f);
        this.jLabel4.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(GeneralPanel.class, (String)"GeneralPanel.jLabel4.text_1"));
        this.jLabel4.setAlignmentX(1.0f);
        this.jLabel6.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(GeneralPanel.class, (String)"GeneralPanel.jLabel6.text_1"));
        this.jLabel6.setAlignmentX(1.0f);
        this.jLabel8.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(GeneralPanel.class, (String)"GeneralPanel.jLabel8.text_1"));
        this.jLabel8.setAlignmentX(1.0f);
        this.jLabel9.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(GeneralPanel.class, (String)"GeneralPanel.jLabel9.text_1"));
        this.jLabel9.setAlignmentX(1.0f);
        this.csoundErrorWarningEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.csoundErrorWarningEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.csoundErrorWarningEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.csoundErrorWarningEnabledActionPerformed(evt);
            }
        });
        this.messageColorsEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messageColorsEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.messageColorsEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.messageColorsEnabledActionPerformed(evt);
            }
        });
        this.alphaEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.alphaEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.alphaEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.alphaEnabledActionPerformed(evt);
            }
        });
        this.newUserDefaultsEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.newUserDefaultsEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.newUserDefaultsEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.newUserDefaultsEnabledActionPerformed(evt);
            }
        });
        this.defaultDirectoryField.setText(NbBundle.getMessage(GeneralPanel.class, (String)"GeneralPanel.defaultDirectoryField.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.directoryOpenButton, (String)NbBundle.getMessage(GeneralPanel.class, (String)"GeneralPanel.directoryOpenButton.text_1"));
        this.directoryOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.directoryOpenButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, 213, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 213, Short.MAX_VALUE).addComponent(this.jLabel9, -1, 213, Short.MAX_VALUE).addComponent(this.jLabel6, -2, 213, Short.MAX_VALUE).addComponent(this.jLabel8, -1, 213, Short.MAX_VALUE)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultDirectoryField, -1, 223, Short.MAX_VALUE).addComponent(this.alphaEnabled, -1, 223, Short.MAX_VALUE).addComponent(this.messageColorsEnabled, -1, 195, Short.MAX_VALUE).addComponent(this.csoundErrorWarningEnabled, -1, 195, Short.MAX_VALUE).addComponent(this.newUserDefaultsEnabled, -1, 195, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directoryOpenButton).addContainerGap()));
        layout.linkSize(0, this.jLabel2, this.jLabel4, this.jLabel6, this.jLabel8, this.jLabel9);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.defaultDirectoryField, -2, -1, -2).addComponent(this.directoryOpenButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.newUserDefaultsEnabled)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.alphaEnabled).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.messageColorsEnabled).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.csoundErrorWarningEnabled).addComponent(this.jLabel9)).addContainerGap(31, Short.MAX_VALUE)));
    }

    private void csoundErrorWarningEnabledActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void messageColorsEnabledActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void alphaEnabledActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void newUserDefaultsEnabledActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void directoryOpenButtonActionPerformed(ActionEvent evt) {
        JFileChooser jfc = SettingsFileChooser.getFileChooser();
        jfc.setFileSelectionMode(1);
        jfc.setCurrentDirectory(GeneralSettings.getInstance().getDefaultDirectory());
        int rValue = jfc.showOpenDialog(this);
        if (rValue == 0) {
            this.defaultDirectoryField.setText(jfc.getSelectedFile().getAbsolutePath());
            GeneralSettings.getInstance().setDefaultDirectory(jfc.getSelectedFile());
            this.controller.changed();
        }
    }

    void load() {
        this.loading = true;
        GeneralSettings settings = GeneralSettings.getInstance();
        this.defaultDirectoryField.setText(settings.getDefaultDirectory().getAbsolutePath());
        this.newUserDefaultsEnabled.setSelected(settings.isNewUserDefaultsEnabled());
        this.alphaEnabled.setSelected(settings.isAlphaEnabled());
        this.messageColorsEnabled.setSelected(settings.isMessageColorsEnabled());
        this.csoundErrorWarningEnabled.setSelected(settings.isCsoundErrorWarningEnabled());
        this.loading = false;
    }

    void store() {
        GeneralSettings settings = GeneralSettings.getInstance();
        settings.setDefaultDirectory(new File(this.defaultDirectoryField.getText()));
        settings.setNewUserDefaultsEnabled(this.newUserDefaultsEnabled.isSelected());
        settings.setAlphaEnabled(this.alphaEnabled.isSelected());
        settings.setMessageColorsEnabled(this.messageColorsEnabled.isSelected());
        settings.setCsoundErrorWarningEnabled(this.csoundErrorWarningEnabled.isSelected());
        settings.save();
    }

    boolean valid() {
        return true;
    }
}

