/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "screenshot_options.h"

ScreenshotOptions::ScreenshotOptions (bool init /* = true */) :
    mOptions (ScreenshotOptions::OptionNum),
    mNotify (ScreenshotOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ScreenshotOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // initiate_button
    mOptions[ScreenshotOptions::InitiateButton].setName ("initiate_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Super>Button1");
    mOptions[ScreenshotOptions::InitiateButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ScreenshotOptions::InitiateButton].value ().action ());

    // draw_selection_indicator
    mOptions[ScreenshotOptions::DrawSelectionIndicator].setName ("draw_selection_indicator", CompOption::TypeBool);
    mOptions[ScreenshotOptions::DrawSelectionIndicator].value().set(true);

    // selection_outline_color
    mOptions[ScreenshotOptions::SelectionOutlineColor].setName ("selection_outline_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x2fff));
    color[1] = MAX (0, MIN (0xffff, 0x2fff));
    color[2] = MAX (0, MIN (0xffff, 0x4fff));
    color[3] = MAX (0, MIN (0xffff, 0x9f9f));
    mOptions[ScreenshotOptions::SelectionOutlineColor].value().set(color);

    // selection_fill_color
    mOptions[ScreenshotOptions::SelectionFillColor].setName ("selection_fill_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x2fff));
    color[1] = MAX (0, MIN (0xffff, 0x2fff));
    color[2] = MAX (0, MIN (0xffff, 0x4fff));
    color[3] = MAX (0, MIN (0xffff, 0x4fff));
    mOptions[ScreenshotOptions::SelectionFillColor].value().set(color);

    // directory
    mOptions[ScreenshotOptions::Directory].setName ("directory", CompOption::TypeString);
    mOptions[ScreenshotOptions::Directory].value().set(CompString (""));

    // launch_app
    mOptions[ScreenshotOptions::LaunchApp].setName ("launch_app", CompOption::TypeString);
    mOptions[ScreenshotOptions::LaunchApp].value().set(CompString (""));

}

ScreenshotOptions::~ScreenshotOptions ()
{
}


CompOption::Vector &
ScreenshotOptions::getOptions ()
{
    return mOptions;
}

bool
ScreenshotOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ScreenshotOptions::InitiateButton:
            if (o->set (value))
            {
                if (!mNotify[ScreenshotOptions::InitiateButton].empty ())
                    mNotify[ScreenshotOptions::InitiateButton] (o, ScreenshotOptions::InitiateButton);
                return true;
            }
            break;
        case ScreenshotOptions::DrawSelectionIndicator:
            if (o->set (value))
            {
                if (!mNotify[ScreenshotOptions::DrawSelectionIndicator].empty ())
                    mNotify[ScreenshotOptions::DrawSelectionIndicator] (o, ScreenshotOptions::DrawSelectionIndicator);
                return true;
            }
            break;
        case ScreenshotOptions::SelectionOutlineColor:
            if (o->set (value))
            {
                if (!mNotify[ScreenshotOptions::SelectionOutlineColor].empty ())
                    mNotify[ScreenshotOptions::SelectionOutlineColor] (o, ScreenshotOptions::SelectionOutlineColor);
                return true;
            }
            break;
        case ScreenshotOptions::SelectionFillColor:
            if (o->set (value))
            {
                if (!mNotify[ScreenshotOptions::SelectionFillColor].empty ())
                    mNotify[ScreenshotOptions::SelectionFillColor] (o, ScreenshotOptions::SelectionFillColor);
                return true;
            }
            break;
        case ScreenshotOptions::Directory:
            if (o->set (value))
            {
                if (!mNotify[ScreenshotOptions::Directory].empty ())
                    mNotify[ScreenshotOptions::Directory] (o, ScreenshotOptions::Directory);
                return true;
            }
            break;
        case ScreenshotOptions::LaunchApp:
            if (o->set (value))
            {
                if (!mNotify[ScreenshotOptions::LaunchApp].empty ())
                    mNotify[ScreenshotOptions::LaunchApp] (o, ScreenshotOptions::LaunchApp);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

