/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "shift_options.h"

ShiftOptions::ShiftOptions (bool init /* = true */) :
    mOptions (ShiftOptions::OptionNum),
    mNotify (ShiftOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ShiftOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned int edge;
    unsigned short color[4];

    // initiate_key
    mOptions[ShiftOptions::InitiateKey].setName ("initiate_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super><Shift>s");
    mOptions[ShiftOptions::InitiateKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::InitiateKey].value ().action ());

    // initiate_button
    mOptions[ShiftOptions::InitiateButton].setName ("initiate_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ShiftOptions::InitiateButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::InitiateButton].value ().action ());

    // initiate_edge
    mOptions[ShiftOptions::InitiateEdge].setName ("initiate_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    action.setEdgeMask (edge);
    mOptions[ShiftOptions::InitiateEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::InitiateEdge].value ().action ());

    // initiate_all_key
    mOptions[ShiftOptions::InitiateAllKey].setName ("initiate_all_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ShiftOptions::InitiateAllKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::InitiateAllKey].value ().action ());

    // initiate_all_button
    mOptions[ShiftOptions::InitiateAllButton].setName ("initiate_all_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ShiftOptions::InitiateAllButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::InitiateAllButton].value ().action ());

    // initiate_all_edge
    mOptions[ShiftOptions::InitiateAllEdge].setName ("initiate_all_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    action.setEdgeMask (edge);
    mOptions[ShiftOptions::InitiateAllEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::InitiateAllEdge].value ().action ());

    // next_key
    mOptions[ShiftOptions::NextKey].setName ("next_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>Tab");
    mOptions[ShiftOptions::NextKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::NextKey].value ().action ());

    // next_button
    mOptions[ShiftOptions::NextButton].setName ("next_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ShiftOptions::NextButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::NextButton].value ().action ());

    // prev_key
    mOptions[ShiftOptions::PrevKey].setName ("prev_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super><Shift>Tab");
    mOptions[ShiftOptions::PrevKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::PrevKey].value ().action ());

    // prev_button
    mOptions[ShiftOptions::PrevButton].setName ("prev_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ShiftOptions::PrevButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::PrevButton].value ().action ());

    // next_all_key
    mOptions[ShiftOptions::NextAllKey].setName ("next_all_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super><Alt>Tab");
    mOptions[ShiftOptions::NextAllKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::NextAllKey].value ().action ());

    // next_all_button
    mOptions[ShiftOptions::NextAllButton].setName ("next_all_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ShiftOptions::NextAllButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::NextAllButton].value ().action ());

    // prev_all_key
    mOptions[ShiftOptions::PrevAllKey].setName ("prev_all_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super><Shift><Alt>Tab");
    mOptions[ShiftOptions::PrevAllKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::PrevAllKey].value ().action ());

    // prev_all_button
    mOptions[ShiftOptions::PrevAllButton].setName ("prev_all_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ShiftOptions::PrevAllButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::PrevAllButton].value ().action ());

    // next_group_key
    mOptions[ShiftOptions::NextGroupKey].setName ("next_group_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ShiftOptions::NextGroupKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::NextGroupKey].value ().action ());

    // next_group_button
    mOptions[ShiftOptions::NextGroupButton].setName ("next_group_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    state |= CompAction::StateInitKey;
    state |= CompAction::StateInitButton;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ShiftOptions::NextGroupButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::NextGroupButton].value ().action ());

    // prev_group_key
    mOptions[ShiftOptions::PrevGroupKey].setName ("prev_group_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ShiftOptions::PrevGroupKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::PrevGroupKey].value ().action ());

    // prev_group_button
    mOptions[ShiftOptions::PrevGroupButton].setName ("prev_group_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ShiftOptions::PrevGroupButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ShiftOptions::PrevGroupButton].value ().action ());

    // window_match
    mOptions[ShiftOptions::WindowMatch].setName ("window_match", CompOption::TypeMatch);
    mOptions[ShiftOptions::WindowMatch].value().set(CompMatch ("Normal | Dialog | ModalDialog | Utility | Unknown"));
    mOptions[ShiftOptions::WindowMatch].value().match ().update ();

    // minimized
    mOptions[ShiftOptions::Minimized].setName ("minimized", CompOption::TypeBool);
    mOptions[ShiftOptions::Minimized].value().set(true);

    // speed
    mOptions[ShiftOptions::Speed].setName ("speed", CompOption::TypeFloat);
    mOptions[ShiftOptions::Speed].rest ().set (0.1, 10.0, 0.1);
    mOptions[ShiftOptions::Speed].value().set((float) 1.5);

    // shift_speed
    mOptions[ShiftOptions::ShiftSpeed].setName ("shift_speed", CompOption::TypeFloat);
    mOptions[ShiftOptions::ShiftSpeed].rest ().set (0.1, 5.0, 0.01);
    mOptions[ShiftOptions::ShiftSpeed].value().set((float) 1.0);

    // timestep
    mOptions[ShiftOptions::Timestep].setName ("timestep", CompOption::TypeFloat);
    mOptions[ShiftOptions::Timestep].rest ().set (0.1, 50.0, 0.1);
    mOptions[ShiftOptions::Timestep].value().set((float) 1.2);

    // mouse_speed
    mOptions[ShiftOptions::MouseSpeed].setName ("mouse_speed", CompOption::TypeFloat);
    mOptions[ShiftOptions::MouseSpeed].rest ().set (0.1, 50.0, 0.1);
    mOptions[ShiftOptions::MouseSpeed].value().set((float) 10.0);

    // click_duration
    mOptions[ShiftOptions::ClickDuration].setName ("click_duration", CompOption::TypeInt);
    mOptions[ShiftOptions::ClickDuration].rest ().set (10, 2000);
    mOptions[ShiftOptions::ClickDuration].value().set((int) 500);

    // size
    mOptions[ShiftOptions::Size].setName ("size", CompOption::TypeInt);
    mOptions[ShiftOptions::Size].rest ().set (1, 100);
    mOptions[ShiftOptions::Size].value().set((int) 50);

    // background_intensity
    mOptions[ShiftOptions::BackgroundIntensity].setName ("background_intensity", CompOption::TypeFloat);
    mOptions[ShiftOptions::BackgroundIntensity].rest ().set (0.0, 1.0, 0.01);
    mOptions[ShiftOptions::BackgroundIntensity].value().set((float) 0.5);

    // hide_all
    mOptions[ShiftOptions::HideAll].setName ("hide_all", CompOption::TypeBool);
    mOptions[ShiftOptions::HideAll].value().set(false);

    // reflection
    mOptions[ShiftOptions::Reflection].setName ("reflection", CompOption::TypeBool);
    mOptions[ShiftOptions::Reflection].value().set(true);

    // ground_color1
    mOptions[ShiftOptions::GroundColor1].setName ("ground_color1", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xb333));
    color[1] = MAX (0, MIN (0xffff, 0xb333));
    color[2] = MAX (0, MIN (0xffff, 0xb333));
    color[3] = MAX (0, MIN (0xffff, 0xcccc));
    mOptions[ShiftOptions::GroundColor1].value().set(color);

    // ground_color2
    mOptions[ShiftOptions::GroundColor2].setName ("ground_color2", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xb333));
    color[1] = MAX (0, MIN (0xffff, 0xb333));
    color[2] = MAX (0, MIN (0xffff, 0xb333));
    color[3] = MAX (0, MIN (0xffff, 0x0000));
    mOptions[ShiftOptions::GroundColor2].value().set(color);

    // ground_size
    mOptions[ShiftOptions::GroundSize].setName ("ground_size", CompOption::TypeFloat);
    mOptions[ShiftOptions::GroundSize].rest ().set (0.0, 1.0, 0.01);
    mOptions[ShiftOptions::GroundSize].value().set((float) 0.5);

    // intensity
    mOptions[ShiftOptions::Intensity].setName ("intensity", CompOption::TypeFloat);
    mOptions[ShiftOptions::Intensity].rest ().set (0.0, 1.0, 0.01);
    mOptions[ShiftOptions::Intensity].value().set((float) 0.4);

    // overlay_icon
    mOptions[ShiftOptions::OverlayIcon].setName ("overlay_icon", CompOption::TypeInt);
    mOptions[ShiftOptions::OverlayIcon].rest ().set (0, 2);
    mOptions[ShiftOptions::OverlayIcon].value().set((int) 1);

    // mipmaps
    mOptions[ShiftOptions::Mipmaps].setName ("mipmaps", CompOption::TypeBool);
    mOptions[ShiftOptions::Mipmaps].value().set(false);

    // multioutput_mode
    mOptions[ShiftOptions::MultioutputMode].setName ("multioutput_mode", CompOption::TypeInt);
    mOptions[ShiftOptions::MultioutputMode].rest ().set (0, 2);
    mOptions[ShiftOptions::MultioutputMode].value().set((int) 0);

    // mode
    mOptions[ShiftOptions::Mode].setName ("mode", CompOption::TypeInt);
    mOptions[ShiftOptions::Mode].rest ().set (0, 1);
    mOptions[ShiftOptions::Mode].value().set((int) 0);

    // flip_rotation
    mOptions[ShiftOptions::FlipRotation].setName ("flip_rotation", CompOption::TypeInt);
    mOptions[ShiftOptions::FlipRotation].rest ().set (-80, 80);
    mOptions[ShiftOptions::FlipRotation].value().set((int) 30);

    // cover_offset
    mOptions[ShiftOptions::CoverOffset].setName ("cover_offset", CompOption::TypeFloat);
    mOptions[ShiftOptions::CoverOffset].rest ().set (-0.4, 0.4, 0.01);
    mOptions[ShiftOptions::CoverOffset].value().set((float) 0.0);

    // cover_angle
    mOptions[ShiftOptions::CoverAngle].setName ("cover_angle", CompOption::TypeFloat);
    mOptions[ShiftOptions::CoverAngle].rest ().set (0, 360, 0.1);
    mOptions[ShiftOptions::CoverAngle].value().set((float) 60);

    // cover_extra_space
    mOptions[ShiftOptions::CoverExtraSpace].setName ("cover_extra_space", CompOption::TypeFloat);
    mOptions[ShiftOptions::CoverExtraSpace].rest ().set (1, 2, 0.1);
    mOptions[ShiftOptions::CoverExtraSpace].value().set((float) 1);

    // cover_max_visible_windows
    mOptions[ShiftOptions::CoverMaxVisibleWindows].setName ("cover_max_visible_windows", CompOption::TypeInt);
    mOptions[ShiftOptions::CoverMaxVisibleWindows].rest ().set (1, 100);
    mOptions[ShiftOptions::CoverMaxVisibleWindows].value().set((int) 10);

    // window_title
    mOptions[ShiftOptions::WindowTitle].setName ("window_title", CompOption::TypeBool);
    mOptions[ShiftOptions::WindowTitle].value().set(true);

    // title_font_bold
    mOptions[ShiftOptions::TitleFontBold].setName ("title_font_bold", CompOption::TypeBool);
    mOptions[ShiftOptions::TitleFontBold].value().set(false);

    // title_font_size
    mOptions[ShiftOptions::TitleFontSize].setName ("title_font_size", CompOption::TypeInt);
    mOptions[ShiftOptions::TitleFontSize].rest ().set (6, 96);
    mOptions[ShiftOptions::TitleFontSize].value().set((int) 16);

    // title_back_color
    mOptions[ShiftOptions::TitleBackColor].setName ("title_back_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0000));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0x0000));
    color[3] = MAX (0, MIN (0xffff, 0x9999));
    mOptions[ShiftOptions::TitleBackColor].value().set(color);

    // title_font_color
    mOptions[ShiftOptions::TitleFontColor].setName ("title_font_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[ShiftOptions::TitleFontColor].value().set(color);

    // title_text_placement
    mOptions[ShiftOptions::TitleTextPlacement].setName ("title_text_placement", CompOption::TypeInt);
    mOptions[ShiftOptions::TitleTextPlacement].rest ().set (0, 2);
    mOptions[ShiftOptions::TitleTextPlacement].value().set((int) 2);

    // vertical_offset
    mOptions[ShiftOptions::VerticalOffset].setName ("vertical_offset", CompOption::TypeInt);
    mOptions[ShiftOptions::VerticalOffset].rest ().set (0, 500);
    mOptions[ShiftOptions::VerticalOffset].value().set((int) 50);

}

ShiftOptions::~ShiftOptions ()
{
}


CompOption::Vector &
ShiftOptions::getOptions ()
{
    return mOptions;
}

bool
ShiftOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ShiftOptions::InitiateKey:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::InitiateKey].empty ())
                    mNotify[ShiftOptions::InitiateKey] (o, ShiftOptions::InitiateKey);
                return true;
            }
            break;
        case ShiftOptions::InitiateButton:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::InitiateButton].empty ())
                    mNotify[ShiftOptions::InitiateButton] (o, ShiftOptions::InitiateButton);
                return true;
            }
            break;
        case ShiftOptions::InitiateEdge:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::InitiateEdge].empty ())
                    mNotify[ShiftOptions::InitiateEdge] (o, ShiftOptions::InitiateEdge);
                return true;
            }
            break;
        case ShiftOptions::InitiateAllKey:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::InitiateAllKey].empty ())
                    mNotify[ShiftOptions::InitiateAllKey] (o, ShiftOptions::InitiateAllKey);
                return true;
            }
            break;
        case ShiftOptions::InitiateAllButton:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::InitiateAllButton].empty ())
                    mNotify[ShiftOptions::InitiateAllButton] (o, ShiftOptions::InitiateAllButton);
                return true;
            }
            break;
        case ShiftOptions::InitiateAllEdge:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::InitiateAllEdge].empty ())
                    mNotify[ShiftOptions::InitiateAllEdge] (o, ShiftOptions::InitiateAllEdge);
                return true;
            }
            break;
        case ShiftOptions::NextKey:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::NextKey].empty ())
                    mNotify[ShiftOptions::NextKey] (o, ShiftOptions::NextKey);
                return true;
            }
            break;
        case ShiftOptions::NextButton:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::NextButton].empty ())
                    mNotify[ShiftOptions::NextButton] (o, ShiftOptions::NextButton);
                return true;
            }
            break;
        case ShiftOptions::PrevKey:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::PrevKey].empty ())
                    mNotify[ShiftOptions::PrevKey] (o, ShiftOptions::PrevKey);
                return true;
            }
            break;
        case ShiftOptions::PrevButton:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::PrevButton].empty ())
                    mNotify[ShiftOptions::PrevButton] (o, ShiftOptions::PrevButton);
                return true;
            }
            break;
        case ShiftOptions::NextAllKey:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::NextAllKey].empty ())
                    mNotify[ShiftOptions::NextAllKey] (o, ShiftOptions::NextAllKey);
                return true;
            }
            break;
        case ShiftOptions::NextAllButton:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::NextAllButton].empty ())
                    mNotify[ShiftOptions::NextAllButton] (o, ShiftOptions::NextAllButton);
                return true;
            }
            break;
        case ShiftOptions::PrevAllKey:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::PrevAllKey].empty ())
                    mNotify[ShiftOptions::PrevAllKey] (o, ShiftOptions::PrevAllKey);
                return true;
            }
            break;
        case ShiftOptions::PrevAllButton:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::PrevAllButton].empty ())
                    mNotify[ShiftOptions::PrevAllButton] (o, ShiftOptions::PrevAllButton);
                return true;
            }
            break;
        case ShiftOptions::NextGroupKey:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::NextGroupKey].empty ())
                    mNotify[ShiftOptions::NextGroupKey] (o, ShiftOptions::NextGroupKey);
                return true;
            }
            break;
        case ShiftOptions::NextGroupButton:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::NextGroupButton].empty ())
                    mNotify[ShiftOptions::NextGroupButton] (o, ShiftOptions::NextGroupButton);
                return true;
            }
            break;
        case ShiftOptions::PrevGroupKey:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::PrevGroupKey].empty ())
                    mNotify[ShiftOptions::PrevGroupKey] (o, ShiftOptions::PrevGroupKey);
                return true;
            }
            break;
        case ShiftOptions::PrevGroupButton:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::PrevGroupButton].empty ())
                    mNotify[ShiftOptions::PrevGroupButton] (o, ShiftOptions::PrevGroupButton);
                return true;
            }
            break;
        case ShiftOptions::WindowMatch:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::WindowMatch].empty ())
                    mNotify[ShiftOptions::WindowMatch] (o, ShiftOptions::WindowMatch);
                return true;
            }
            break;
        case ShiftOptions::Minimized:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::Minimized].empty ())
                    mNotify[ShiftOptions::Minimized] (o, ShiftOptions::Minimized);
                return true;
            }
            break;
        case ShiftOptions::Speed:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::Speed].empty ())
                    mNotify[ShiftOptions::Speed] (o, ShiftOptions::Speed);
                return true;
            }
            break;
        case ShiftOptions::ShiftSpeed:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::ShiftSpeed].empty ())
                    mNotify[ShiftOptions::ShiftSpeed] (o, ShiftOptions::ShiftSpeed);
                return true;
            }
            break;
        case ShiftOptions::Timestep:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::Timestep].empty ())
                    mNotify[ShiftOptions::Timestep] (o, ShiftOptions::Timestep);
                return true;
            }
            break;
        case ShiftOptions::MouseSpeed:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::MouseSpeed].empty ())
                    mNotify[ShiftOptions::MouseSpeed] (o, ShiftOptions::MouseSpeed);
                return true;
            }
            break;
        case ShiftOptions::ClickDuration:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::ClickDuration].empty ())
                    mNotify[ShiftOptions::ClickDuration] (o, ShiftOptions::ClickDuration);
                return true;
            }
            break;
        case ShiftOptions::Size:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::Size].empty ())
                    mNotify[ShiftOptions::Size] (o, ShiftOptions::Size);
                return true;
            }
            break;
        case ShiftOptions::BackgroundIntensity:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::BackgroundIntensity].empty ())
                    mNotify[ShiftOptions::BackgroundIntensity] (o, ShiftOptions::BackgroundIntensity);
                return true;
            }
            break;
        case ShiftOptions::HideAll:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::HideAll].empty ())
                    mNotify[ShiftOptions::HideAll] (o, ShiftOptions::HideAll);
                return true;
            }
            break;
        case ShiftOptions::Reflection:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::Reflection].empty ())
                    mNotify[ShiftOptions::Reflection] (o, ShiftOptions::Reflection);
                return true;
            }
            break;
        case ShiftOptions::GroundColor1:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::GroundColor1].empty ())
                    mNotify[ShiftOptions::GroundColor1] (o, ShiftOptions::GroundColor1);
                return true;
            }
            break;
        case ShiftOptions::GroundColor2:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::GroundColor2].empty ())
                    mNotify[ShiftOptions::GroundColor2] (o, ShiftOptions::GroundColor2);
                return true;
            }
            break;
        case ShiftOptions::GroundSize:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::GroundSize].empty ())
                    mNotify[ShiftOptions::GroundSize] (o, ShiftOptions::GroundSize);
                return true;
            }
            break;
        case ShiftOptions::Intensity:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::Intensity].empty ())
                    mNotify[ShiftOptions::Intensity] (o, ShiftOptions::Intensity);
                return true;
            }
            break;
        case ShiftOptions::OverlayIcon:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::OverlayIcon].empty ())
                    mNotify[ShiftOptions::OverlayIcon] (o, ShiftOptions::OverlayIcon);
                return true;
            }
            break;
        case ShiftOptions::Mipmaps:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::Mipmaps].empty ())
                    mNotify[ShiftOptions::Mipmaps] (o, ShiftOptions::Mipmaps);
                return true;
            }
            break;
        case ShiftOptions::MultioutputMode:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::MultioutputMode].empty ())
                    mNotify[ShiftOptions::MultioutputMode] (o, ShiftOptions::MultioutputMode);
                return true;
            }
            break;
        case ShiftOptions::Mode:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::Mode].empty ())
                    mNotify[ShiftOptions::Mode] (o, ShiftOptions::Mode);
                return true;
            }
            break;
        case ShiftOptions::FlipRotation:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::FlipRotation].empty ())
                    mNotify[ShiftOptions::FlipRotation] (o, ShiftOptions::FlipRotation);
                return true;
            }
            break;
        case ShiftOptions::CoverOffset:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::CoverOffset].empty ())
                    mNotify[ShiftOptions::CoverOffset] (o, ShiftOptions::CoverOffset);
                return true;
            }
            break;
        case ShiftOptions::CoverAngle:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::CoverAngle].empty ())
                    mNotify[ShiftOptions::CoverAngle] (o, ShiftOptions::CoverAngle);
                return true;
            }
            break;
        case ShiftOptions::CoverExtraSpace:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::CoverExtraSpace].empty ())
                    mNotify[ShiftOptions::CoverExtraSpace] (o, ShiftOptions::CoverExtraSpace);
                return true;
            }
            break;
        case ShiftOptions::CoverMaxVisibleWindows:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::CoverMaxVisibleWindows].empty ())
                    mNotify[ShiftOptions::CoverMaxVisibleWindows] (o, ShiftOptions::CoverMaxVisibleWindows);
                return true;
            }
            break;
        case ShiftOptions::WindowTitle:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::WindowTitle].empty ())
                    mNotify[ShiftOptions::WindowTitle] (o, ShiftOptions::WindowTitle);
                return true;
            }
            break;
        case ShiftOptions::TitleFontBold:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::TitleFontBold].empty ())
                    mNotify[ShiftOptions::TitleFontBold] (o, ShiftOptions::TitleFontBold);
                return true;
            }
            break;
        case ShiftOptions::TitleFontSize:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::TitleFontSize].empty ())
                    mNotify[ShiftOptions::TitleFontSize] (o, ShiftOptions::TitleFontSize);
                return true;
            }
            break;
        case ShiftOptions::TitleBackColor:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::TitleBackColor].empty ())
                    mNotify[ShiftOptions::TitleBackColor] (o, ShiftOptions::TitleBackColor);
                return true;
            }
            break;
        case ShiftOptions::TitleFontColor:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::TitleFontColor].empty ())
                    mNotify[ShiftOptions::TitleFontColor] (o, ShiftOptions::TitleFontColor);
                return true;
            }
            break;
        case ShiftOptions::TitleTextPlacement:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::TitleTextPlacement].empty ())
                    mNotify[ShiftOptions::TitleTextPlacement] (o, ShiftOptions::TitleTextPlacement);
                return true;
            }
            break;
        case ShiftOptions::VerticalOffset:
            if (o->set (value))
            {
                if (!mNotify[ShiftOptions::VerticalOffset].empty ())
                    mNotify[ShiftOptions::VerticalOffset] (o, ShiftOptions::VerticalOffset);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

