/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "scale_options.h"

ScaleOptions::ScaleOptions (bool init /* = true */) :
    mOptions (ScaleOptions::OptionNum),
    mNotify (ScaleOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ScaleOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned int edge;

    // spacing
    mOptions[ScaleOptions::Spacing].setName ("spacing", CompOption::TypeInt);
    mOptions[ScaleOptions::Spacing].rest ().set (0, 250);
    mOptions[ScaleOptions::Spacing].value().set((int) 10);

    // x_offset
    mOptions[ScaleOptions::XOffset].setName ("x_offset", CompOption::TypeInt);
    mOptions[ScaleOptions::XOffset].rest ().set (0, MAXSHORT);
    mOptions[ScaleOptions::XOffset].value().set((int) 0);

    // y_offset
    mOptions[ScaleOptions::YOffset].setName ("y_offset", CompOption::TypeInt);
    mOptions[ScaleOptions::YOffset].rest ().set (0, MAXSHORT);
    mOptions[ScaleOptions::YOffset].value().set((int) 0);

    // y_bottom_offset
    mOptions[ScaleOptions::YBottomOffset].setName ("y_bottom_offset", CompOption::TypeInt);
    mOptions[ScaleOptions::YBottomOffset].rest ().set (0, MAXSHORT);
    mOptions[ScaleOptions::YBottomOffset].value().set((int) 0);

    // speed
    mOptions[ScaleOptions::Speed].setName ("speed", CompOption::TypeFloat);
    mOptions[ScaleOptions::Speed].rest ().set (0.1, 50, 0.1);
    mOptions[ScaleOptions::Speed].value().set((float) 1.5);

    // timestep
    mOptions[ScaleOptions::Timestep].setName ("timestep", CompOption::TypeFloat);
    mOptions[ScaleOptions::Timestep].rest ().set (0.1, 50, 0.1);
    mOptions[ScaleOptions::Timestep].value().set((float) 1.2);

    // darken_back
    mOptions[ScaleOptions::DarkenBack].setName ("darken_back", CompOption::TypeBool);
    mOptions[ScaleOptions::DarkenBack].value().set(true);

    // opacity
    mOptions[ScaleOptions::Opacity].setName ("opacity", CompOption::TypeInt);
    mOptions[ScaleOptions::Opacity].rest ().set (0, 100);
    mOptions[ScaleOptions::Opacity].value().set((int) 75);

    // overlay_icon
    mOptions[ScaleOptions::OverlayIcon].setName ("overlay_icon", CompOption::TypeInt);
    mOptions[ScaleOptions::OverlayIcon].rest ().set (0, 2);
    mOptions[ScaleOptions::OverlayIcon].value().set((int) 1);

    // window_match
    mOptions[ScaleOptions::WindowMatch].setName ("window_match", CompOption::TypeMatch);
    mOptions[ScaleOptions::WindowMatch].value().set(CompMatch ("Toolbar | Utility | Dialog | Normal | Unknown"));
    mOptions[ScaleOptions::WindowMatch].value().match ().update ();

    // hover_time
    mOptions[ScaleOptions::HoverTime].setName ("hover_time", CompOption::TypeInt);
    mOptions[ScaleOptions::HoverTime].rest ().set (50, 10000);
    mOptions[ScaleOptions::HoverTime].value().set((int) 750);

    // dnd_distance
    mOptions[ScaleOptions::DndDistance].setName ("dnd_distance", CompOption::TypeInt);
    mOptions[ScaleOptions::DndDistance].rest ().set (0, 250);
    mOptions[ScaleOptions::DndDistance].value().set((int) 6);

    // dnd_timeout_spinner
    mOptions[ScaleOptions::DndTimeoutSpinner].setName ("dnd_timeout_spinner", CompOption::TypeBool);
    mOptions[ScaleOptions::DndTimeoutSpinner].value().set(true);

    // dnd_timeout_spinner_speed
    mOptions[ScaleOptions::DndTimeoutSpinnerSpeed].setName ("dnd_timeout_spinner_speed", CompOption::TypeInt);
    mOptions[ScaleOptions::DndTimeoutSpinnerSpeed].rest ().set (50, 250);
    mOptions[ScaleOptions::DndTimeoutSpinnerSpeed].value().set((int) 100);

    // multioutput_mode
    mOptions[ScaleOptions::MultioutputMode].setName ("multioutput_mode", CompOption::TypeInt);
    mOptions[ScaleOptions::MultioutputMode].rest ().set (0, 1);
    mOptions[ScaleOptions::MultioutputMode].value().set((int) 0);

    // skip_animation
    mOptions[ScaleOptions::SkipAnimation].setName ("skip_animation", CompOption::TypeBool);
    mOptions[ScaleOptions::SkipAnimation].value().set(false);

    // key_bindings_toggle
    mOptions[ScaleOptions::KeyBindingsToggle].setName ("key_bindings_toggle", CompOption::TypeBool);
    mOptions[ScaleOptions::KeyBindingsToggle].value().set(false);

    // button_bindings_toggle
    mOptions[ScaleOptions::ButtonBindingsToggle].setName ("button_bindings_toggle", CompOption::TypeBool);
    mOptions[ScaleOptions::ButtonBindingsToggle].value().set(false);

    // initiate_edge
    mOptions[ScaleOptions::InitiateEdge].setName ("initiate_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    state |= CompAction::StateInitEdgeDnd;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    edge |= (1 << 5);
    action.setEdgeMask (edge);
    mOptions[ScaleOptions::InitiateEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateEdge].value ().action ());

    // initiate_key
    mOptions[ScaleOptions::InitiateKey].setName ("initiate_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Shift><Alt>Up");
    mOptions[ScaleOptions::InitiateKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateKey].value ().action ());

    // initiate_button
    mOptions[ScaleOptions::InitiateButton].setName ("initiate_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ScaleOptions::InitiateButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateButton].value ().action ());

    // initiate_all_edge
    mOptions[ScaleOptions::InitiateAllEdge].setName ("initiate_all_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    state |= CompAction::StateInitEdgeDnd;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    action.setEdgeMask (edge);
    mOptions[ScaleOptions::InitiateAllEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateAllEdge].value ().action ());

    // initiate_all_button
    mOptions[ScaleOptions::InitiateAllButton].setName ("initiate_all_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ScaleOptions::InitiateAllButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateAllButton].value ().action ());

    // initiate_all_key
    mOptions[ScaleOptions::InitiateAllKey].setName ("initiate_all_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ScaleOptions::InitiateAllKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateAllKey].value ().action ());

    // initiate_group_edge
    mOptions[ScaleOptions::InitiateGroupEdge].setName ("initiate_group_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    state |= CompAction::StateInitEdgeDnd;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    action.setEdgeMask (edge);
    mOptions[ScaleOptions::InitiateGroupEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateGroupEdge].value ().action ());

    // initiate_group_button
    mOptions[ScaleOptions::InitiateGroupButton].setName ("initiate_group_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ScaleOptions::InitiateGroupButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateGroupButton].value ().action ());

    // initiate_group_key
    mOptions[ScaleOptions::InitiateGroupKey].setName ("initiate_group_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ScaleOptions::InitiateGroupKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateGroupKey].value ().action ());

    // initiate_output_edge
    mOptions[ScaleOptions::InitiateOutputEdge].setName ("initiate_output_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    state |= CompAction::StateInitEdgeDnd;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    action.setEdgeMask (edge);
    mOptions[ScaleOptions::InitiateOutputEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateOutputEdge].value ().action ());

    // initiate_output_button
    mOptions[ScaleOptions::InitiateOutputButton].setName ("initiate_output_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ScaleOptions::InitiateOutputButton].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateOutputButton].value ().action ());

    // initiate_output_key
    mOptions[ScaleOptions::InitiateOutputKey].setName ("initiate_output_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ScaleOptions::InitiateOutputKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ScaleOptions::InitiateOutputKey].value ().action ());

    // click_on_desktop
    mOptions[ScaleOptions::ClickOnDesktop].setName ("click_on_desktop", CompOption::TypeInt);
    mOptions[ScaleOptions::ClickOnDesktop].rest ().set (0, 2);
    mOptions[ScaleOptions::ClickOnDesktop].value().set((int) 2);

}

ScaleOptions::~ScaleOptions ()
{
}


CompOption::Vector &
ScaleOptions::getOptions ()
{
    return mOptions;
}

bool
ScaleOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ScaleOptions::Spacing:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::Spacing].empty ())
                    mNotify[ScaleOptions::Spacing] (o, ScaleOptions::Spacing);
                return true;
            }
            break;
        case ScaleOptions::XOffset:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::XOffset].empty ())
                    mNotify[ScaleOptions::XOffset] (o, ScaleOptions::XOffset);
                return true;
            }
            break;
        case ScaleOptions::YOffset:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::YOffset].empty ())
                    mNotify[ScaleOptions::YOffset] (o, ScaleOptions::YOffset);
                return true;
            }
            break;
        case ScaleOptions::YBottomOffset:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::YBottomOffset].empty ())
                    mNotify[ScaleOptions::YBottomOffset] (o, ScaleOptions::YBottomOffset);
                return true;
            }
            break;
        case ScaleOptions::Speed:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::Speed].empty ())
                    mNotify[ScaleOptions::Speed] (o, ScaleOptions::Speed);
                return true;
            }
            break;
        case ScaleOptions::Timestep:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::Timestep].empty ())
                    mNotify[ScaleOptions::Timestep] (o, ScaleOptions::Timestep);
                return true;
            }
            break;
        case ScaleOptions::DarkenBack:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::DarkenBack].empty ())
                    mNotify[ScaleOptions::DarkenBack] (o, ScaleOptions::DarkenBack);
                return true;
            }
            break;
        case ScaleOptions::Opacity:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::Opacity].empty ())
                    mNotify[ScaleOptions::Opacity] (o, ScaleOptions::Opacity);
                return true;
            }
            break;
        case ScaleOptions::OverlayIcon:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::OverlayIcon].empty ())
                    mNotify[ScaleOptions::OverlayIcon] (o, ScaleOptions::OverlayIcon);
                return true;
            }
            break;
        case ScaleOptions::WindowMatch:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::WindowMatch].empty ())
                    mNotify[ScaleOptions::WindowMatch] (o, ScaleOptions::WindowMatch);
                return true;
            }
            break;
        case ScaleOptions::HoverTime:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::HoverTime].empty ())
                    mNotify[ScaleOptions::HoverTime] (o, ScaleOptions::HoverTime);
                return true;
            }
            break;
        case ScaleOptions::DndDistance:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::DndDistance].empty ())
                    mNotify[ScaleOptions::DndDistance] (o, ScaleOptions::DndDistance);
                return true;
            }
            break;
        case ScaleOptions::DndTimeoutSpinner:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::DndTimeoutSpinner].empty ())
                    mNotify[ScaleOptions::DndTimeoutSpinner] (o, ScaleOptions::DndTimeoutSpinner);
                return true;
            }
            break;
        case ScaleOptions::DndTimeoutSpinnerSpeed:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::DndTimeoutSpinnerSpeed].empty ())
                    mNotify[ScaleOptions::DndTimeoutSpinnerSpeed] (o, ScaleOptions::DndTimeoutSpinnerSpeed);
                return true;
            }
            break;
        case ScaleOptions::MultioutputMode:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::MultioutputMode].empty ())
                    mNotify[ScaleOptions::MultioutputMode] (o, ScaleOptions::MultioutputMode);
                return true;
            }
            break;
        case ScaleOptions::SkipAnimation:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::SkipAnimation].empty ())
                    mNotify[ScaleOptions::SkipAnimation] (o, ScaleOptions::SkipAnimation);
                return true;
            }
            break;
        case ScaleOptions::KeyBindingsToggle:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::KeyBindingsToggle].empty ())
                    mNotify[ScaleOptions::KeyBindingsToggle] (o, ScaleOptions::KeyBindingsToggle);
                return true;
            }
            break;
        case ScaleOptions::ButtonBindingsToggle:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::ButtonBindingsToggle].empty ())
                    mNotify[ScaleOptions::ButtonBindingsToggle] (o, ScaleOptions::ButtonBindingsToggle);
                return true;
            }
            break;
        case ScaleOptions::InitiateEdge:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateEdge].empty ())
                    mNotify[ScaleOptions::InitiateEdge] (o, ScaleOptions::InitiateEdge);
                return true;
            }
            break;
        case ScaleOptions::InitiateKey:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateKey].empty ())
                    mNotify[ScaleOptions::InitiateKey] (o, ScaleOptions::InitiateKey);
                return true;
            }
            break;
        case ScaleOptions::InitiateButton:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateButton].empty ())
                    mNotify[ScaleOptions::InitiateButton] (o, ScaleOptions::InitiateButton);
                return true;
            }
            break;
        case ScaleOptions::InitiateAllEdge:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateAllEdge].empty ())
                    mNotify[ScaleOptions::InitiateAllEdge] (o, ScaleOptions::InitiateAllEdge);
                return true;
            }
            break;
        case ScaleOptions::InitiateAllButton:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateAllButton].empty ())
                    mNotify[ScaleOptions::InitiateAllButton] (o, ScaleOptions::InitiateAllButton);
                return true;
            }
            break;
        case ScaleOptions::InitiateAllKey:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateAllKey].empty ())
                    mNotify[ScaleOptions::InitiateAllKey] (o, ScaleOptions::InitiateAllKey);
                return true;
            }
            break;
        case ScaleOptions::InitiateGroupEdge:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateGroupEdge].empty ())
                    mNotify[ScaleOptions::InitiateGroupEdge] (o, ScaleOptions::InitiateGroupEdge);
                return true;
            }
            break;
        case ScaleOptions::InitiateGroupButton:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateGroupButton].empty ())
                    mNotify[ScaleOptions::InitiateGroupButton] (o, ScaleOptions::InitiateGroupButton);
                return true;
            }
            break;
        case ScaleOptions::InitiateGroupKey:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateGroupKey].empty ())
                    mNotify[ScaleOptions::InitiateGroupKey] (o, ScaleOptions::InitiateGroupKey);
                return true;
            }
            break;
        case ScaleOptions::InitiateOutputEdge:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateOutputEdge].empty ())
                    mNotify[ScaleOptions::InitiateOutputEdge] (o, ScaleOptions::InitiateOutputEdge);
                return true;
            }
            break;
        case ScaleOptions::InitiateOutputButton:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateOutputButton].empty ())
                    mNotify[ScaleOptions::InitiateOutputButton] (o, ScaleOptions::InitiateOutputButton);
                return true;
            }
            break;
        case ScaleOptions::InitiateOutputKey:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::InitiateOutputKey].empty ())
                    mNotify[ScaleOptions::InitiateOutputKey] (o, ScaleOptions::InitiateOutputKey);
                return true;
            }
            break;
        case ScaleOptions::ClickOnDesktop:
            if (o->set (value))
            {
                if (!mNotify[ScaleOptions::ClickOnDesktop].empty ())
                    mNotify[ScaleOptions::ClickOnDesktop] (o, ScaleOptions::ClickOnDesktop);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

