/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "extrawm_options.h"

ExtrawmOptions::ExtrawmOptions (bool init /* = true */) :
    mOptions (ExtrawmOptions::OptionNum),
    mNotify (ExtrawmOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ExtrawmOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // activate
    mOptions[ExtrawmOptions::Activate].setName ("activate", CompOption::TypeAction);
    state = CompAction::StateAutoGrab;
    mOptions[ExtrawmOptions::Activate].value().set(CompAction ());
    mOptions[ExtrawmOptions::Activate].value().action ().setState (state);

    // toggle_redirect_key
    mOptions[ExtrawmOptions::ToggleRedirectKey].setName ("toggle_redirect_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ExtrawmOptions::ToggleRedirectKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ExtrawmOptions::ToggleRedirectKey].value ().action ());

    // toggle_fullscreen_key
    mOptions[ExtrawmOptions::ToggleFullscreenKey].setName ("toggle_fullscreen_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ExtrawmOptions::ToggleFullscreenKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ExtrawmOptions::ToggleFullscreenKey].value ().action ());

    // toggle_always_on_top_key
    mOptions[ExtrawmOptions::ToggleAlwaysOnTopKey].setName ("toggle_always_on_top_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ExtrawmOptions::ToggleAlwaysOnTopKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ExtrawmOptions::ToggleAlwaysOnTopKey].value ().action ());

    // toggle_sticky_key
    mOptions[ExtrawmOptions::ToggleStickyKey].setName ("toggle_sticky_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ExtrawmOptions::ToggleStickyKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ExtrawmOptions::ToggleStickyKey].value ().action ());

    // activate_demands_attention_key
    mOptions[ExtrawmOptions::ActivateDemandsAttentionKey].setName ("activate_demands_attention_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ExtrawmOptions::ActivateDemandsAttentionKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ExtrawmOptions::ActivateDemandsAttentionKey].value ().action ());

}

ExtrawmOptions::~ExtrawmOptions ()
{
}


CompOption::Vector &
ExtrawmOptions::getOptions ()
{
    return mOptions;
}

bool
ExtrawmOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ExtrawmOptions::Activate:
            if (o->set (value))
            {
                if (!mNotify[ExtrawmOptions::Activate].empty ())
                    mNotify[ExtrawmOptions::Activate] (o, ExtrawmOptions::Activate);
                return true;
            }
            break;
        case ExtrawmOptions::ToggleRedirectKey:
            if (o->set (value))
            {
                if (!mNotify[ExtrawmOptions::ToggleRedirectKey].empty ())
                    mNotify[ExtrawmOptions::ToggleRedirectKey] (o, ExtrawmOptions::ToggleRedirectKey);
                return true;
            }
            break;
        case ExtrawmOptions::ToggleFullscreenKey:
            if (o->set (value))
            {
                if (!mNotify[ExtrawmOptions::ToggleFullscreenKey].empty ())
                    mNotify[ExtrawmOptions::ToggleFullscreenKey] (o, ExtrawmOptions::ToggleFullscreenKey);
                return true;
            }
            break;
        case ExtrawmOptions::ToggleAlwaysOnTopKey:
            if (o->set (value))
            {
                if (!mNotify[ExtrawmOptions::ToggleAlwaysOnTopKey].empty ())
                    mNotify[ExtrawmOptions::ToggleAlwaysOnTopKey] (o, ExtrawmOptions::ToggleAlwaysOnTopKey);
                return true;
            }
            break;
        case ExtrawmOptions::ToggleStickyKey:
            if (o->set (value))
            {
                if (!mNotify[ExtrawmOptions::ToggleStickyKey].empty ())
                    mNotify[ExtrawmOptions::ToggleStickyKey] (o, ExtrawmOptions::ToggleStickyKey);
                return true;
            }
            break;
        case ExtrawmOptions::ActivateDemandsAttentionKey:
            if (o->set (value))
            {
                if (!mNotify[ExtrawmOptions::ActivateDemandsAttentionKey].empty ())
                    mNotify[ExtrawmOptions::ActivateDemandsAttentionKey] (o, ExtrawmOptions::ActivateDemandsAttentionKey);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

