/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viz.DensiTree;
import viz.util.Util;

public class LineWidthPanel
extends JPanel
implements ChangeListener {
    public static final String HELP_LINE_WIDTH = "Determine line width of trees of both tree set and consensus trees.For consensus trees, the average value for the topology is used.\nDEFAULT: all lines are same width.\nBY_META_DATA_PATTERN: use value of pattern specified below.\nBY_META_DATA_NUMBER: use the N-th attribute value in the meta data.\nmeta data attribute: only available if any meta data attribute is specified. Use value of the attribute for line width of branches.";
    public static final String HELP_PATTERN = "Regular expression used for width of branches when BY_META_DATA_PATTERN is chosen. The string of the pattern between brackets is selected as value.;";
    public static final String HELP_TOP = "Specifies N-th meta data attribute for top of branch when BY_META_DATA_NUMBER is seleced.";
    public static final String HELP_LINE_WIDTH_BOTTOM = "Line width at bottom of branch.\nsame as top: use same specification as for top of branch.\nFit to bottom: adjust bottom widths so they fit to top of branch below.\nBY_META_DATA_PATTERN: use value of pattern specified below.\nBY_META_DATA_NUMBER: use the N-th attribute value in the meta data.\nmeta data attribute: only available if any meta data attribute is specified. Use value of the attribute for line width of branches.";
    public static final String HELP_BOTTOM = "Specifies N-th meta data attribute for top of branch when BY_META_DATA_NUMBER is seleced.";
    public static final String HELP_ZERO_BASED = "If selected, the minimum value is zero, otherwise the minimum value of the range of whatever value is used.";
    public static final String HELP_SCALE = "Scale width with this number.";
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private JTextField textField_1;
    private JTextField textField_3;
    JSpinner spinner;
    JSpinner spinner_1;
    SpinnerNumberModel topOfBranchModel;
    SpinnerNumberModel bottomOfBranchModel;
    JComboBox<String> comboBoxBottom;
    JComboBox<String> comboBoxTop = new JComboBox();
    static final String SAME_AS_BOTTOM = "Same as top";
    static final String MAKE_FIT_BOTTOM = "Make fit to bottom";
    DensiTree m_dt;
    private JSeparator separator;
    private JSeparator separator_1;
    JCheckBox chckbxZeroBased;

    public LineWidthPanel(DensiTree dt) {
        this.m_dt = dt;
        this.m_dt.addChangeListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        this.setLayout(gridBagLayout);
        this.comboBoxBottom = new JComboBox();
        this.stateChanged(null);
        this.comboBoxBottom.setPreferredSize(new Dimension(130, 20));
        this.comboBoxBottom.setMaximumSize(new Dimension(130, 200));
        this.comboBoxBottom.setSelectedItem((Object)this.m_dt.m_lineWidthMode);
        this.comboBoxBottom.addActionListener(e -> SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String selected = LineWidthPanel.this.comboBoxBottom.getSelectedItem().toString();
                DensiTree.LineWidthMode oldMode = LineWidthPanel.this.m_dt.m_lineWidthMode;
                String oldTag = LineWidthPanel.this.m_dt.m_lineWidthTag;
                if (selected.equals(DensiTree.LineWidthMode.DEFAULT.toString())) {
                    LineWidthPanel.this.m_dt.m_lineWidthMode = DensiTree.LineWidthMode.DEFAULT;
                } else if (selected.equals(DensiTree.LineWidthMode.BY_METADATA_PATTERN.toString())) {
                    LineWidthPanel.this.m_dt.m_lineWidthMode = DensiTree.LineWidthMode.BY_METADATA_PATTERN;
                } else if (selected.equals(DensiTree.LineWidthMode.BY_METADATA_NUMBER.toString())) {
                    LineWidthPanel.this.m_dt.m_lineWidthMode = DensiTree.LineWidthMode.BY_METADATA_NUMBER;
                } else {
                    LineWidthPanel.this.m_dt.m_lineWidthTag = selected;
                    LineWidthPanel.this.m_dt.m_lineWidthMode = DensiTree.LineWidthMode.BY_METADATA_TAG;
                }
                LineWidthPanel.this.m_dt.resetStyle();
                if (LineWidthPanel.this.m_dt.m_lineWidthMode != oldMode || LineWidthPanel.this.m_dt.m_lineWidthTag != null && !LineWidthPanel.this.m_dt.m_lineWidthTag.equals(oldTag)) {
                    LineWidthPanel.this.m_dt.calcLineWidths(true);
                    LineWidthPanel.this.m_dt.makeDirty();
                }
                LineWidthPanel.this.updateEnabled();
                LineWidthPanel.this.repaint();
            }
        }));
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.gridwidth = 2;
        gbc_comboBox.insets = new Insets(0, 0, 5, 0);
        gbc_comboBox.gridx = 0;
        gbc_comboBox.gridy = 2;
        this.add(this.comboBoxBottom, gbc_comboBox);
        this.textField_1 = new JTextField(this.m_dt.m_sLineWidthPattern);
        GridBagConstraints gbc_textField_1 = new GridBagConstraints();
        gbc_textField_1.fill = 2;
        gbc_textField_1.insets = new Insets(0, 0, 5, 0);
        gbc_textField_1.gridx = 0;
        gbc_textField_1.gridy = 3;
        gbc_textField_1.gridwidth = 2;
        this.add((Component)this.textField_1, gbc_textField_1);
        this.textField_1.setColumns(10);
        this.textField_1.addActionListener(e -> {
            try {
                this.m_dt.m_sLineWidthPattern = this.textField_1.getText();
                if (this.m_dt.m_lineWidthMode != DensiTree.LineWidthMode.DEFAULT) {
                    this.m_dt.calcLineWidths(true);
                    this.m_dt.makeDirty();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.bottomOfBranchModel = new SpinnerNumberModel(this.m_dt.m_iPatternForBottom, 1, 100, 1);
        this.topOfBranchModel = new SpinnerNumberModel(this.m_dt.m_iPatternForTop, 0, 100, 1);
        this.bottomOfBranchModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LineWidthPanel.this.m_dt.m_iPatternForBottom = (Integer)LineWidthPanel.this.bottomOfBranchModel.getValue();
                if (LineWidthPanel.this.m_dt.m_iPatternForBottom < 1) {
                    LineWidthPanel.this.m_dt.m_iPatternForBottom = 1;
                }
                if (LineWidthPanel.this.m_dt.m_lineWidthMode != DensiTree.LineWidthMode.DEFAULT) {
                    LineWidthPanel.this.m_dt.m_pattern = LineWidthPanel.this.m_dt.createPattern();
                    LineWidthPanel.this.m_dt.calcLineWidths(true);
                    LineWidthPanel.this.m_dt.makeDirty();
                }
            }
        });
        this.topOfBranchModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LineWidthPanel.this.m_dt.m_iPatternForTop = (Integer)LineWidthPanel.this.topOfBranchModel.getValue();
                if (LineWidthPanel.this.m_dt.m_iPatternForTop < 0) {
                    LineWidthPanel.this.m_dt.m_iPatternForTop = 0;
                }
                if (LineWidthPanel.this.m_dt.m_lineWidthMode != DensiTree.LineWidthMode.DEFAULT) {
                    LineWidthPanel.this.m_dt.m_pattern = LineWidthPanel.this.m_dt.createPattern();
                    LineWidthPanel.this.m_dt.calcLineWidths(true);
                    LineWidthPanel.this.m_dt.makeDirty();
                }
            }
        });
        JLabel lblNumberOfItem_1 = new JLabel("top");
        GridBagConstraints gbc_lblNumberOfItem_1 = new GridBagConstraints();
        gbc_lblNumberOfItem_1.anchor = 13;
        gbc_lblNumberOfItem_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblNumberOfItem_1.gridx = 0;
        gbc_lblNumberOfItem_1.gridy = 4;
        this.add((Component)lblNumberOfItem_1, gbc_lblNumberOfItem_1);
        this.spinner = new JSpinner(this.bottomOfBranchModel);
        GridBagConstraints gbc_spinner = new GridBagConstraints();
        gbc_spinner.insets = new Insets(0, 0, 5, 0);
        gbc_spinner.gridx = 1;
        gbc_spinner.gridy = 4;
        this.add((Component)this.spinner, gbc_spinner);
        this.spinner.setMaximumSize(new Dimension(1, 20));
        this.separator_1 = new JSeparator();
        GridBagConstraints gbc_separator_1 = new GridBagConstraints();
        gbc_separator_1.insets = new Insets(0, 0, 5, 5);
        gbc_separator_1.gridx = 0;
        gbc_separator_1.gridy = 5;
        this.add((Component)this.separator_1, gbc_separator_1);
        GridBagConstraints gbc_comboBoxTop = new GridBagConstraints();
        gbc_comboBoxTop.gridwidth = 2;
        gbc_comboBoxTop.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxTop.gridx = 0;
        gbc_comboBoxTop.gridy = 6;
        this.add(this.comboBoxTop, gbc_comboBoxTop);
        this.comboBoxTop.setPreferredSize(new Dimension(130, 20));
        this.comboBoxTop.setMaximumSize(new Dimension(130, 200));
        this.comboBoxTop.setSelectedItem((Object)this.m_dt.m_lineWidthMode);
        this.comboBoxTop.addActionListener(ea -> SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String selected = LineWidthPanel.this.comboBoxTop.getSelectedItem().toString();
                DensiTree.LineWidthMode oldMode = LineWidthPanel.this.m_dt.m_lineWidthModeTop;
                String oldTag = LineWidthPanel.this.m_dt.m_lineWidthTagTop;
                boolean oldCorrectTopOfBranch = LineWidthPanel.this.m_dt.m_bCorrectTopOfBranch;
                if (selected.equals(LineWidthPanel.SAME_AS_BOTTOM)) {
                    LineWidthPanel.this.m_dt.m_lineWidthModeTop = DensiTree.LineWidthMode.DEFAULT;
                } else if (selected.equals(LineWidthPanel.MAKE_FIT_BOTTOM)) {
                    LineWidthPanel.this.m_dt.m_lineWidthModeTop = DensiTree.LineWidthMode.DEFAULT;
                    LineWidthPanel.this.m_dt.m_bCorrectTopOfBranch = true;
                } else if (selected.equals(DensiTree.LineWidthMode.BY_METADATA_PATTERN.toString())) {
                    LineWidthPanel.this.m_dt.m_lineWidthModeTop = DensiTree.LineWidthMode.BY_METADATA_PATTERN;
                } else if (selected.equals(DensiTree.LineWidthMode.BY_METADATA_NUMBER.toString())) {
                    LineWidthPanel.this.m_dt.m_lineWidthModeTop = DensiTree.LineWidthMode.BY_METADATA_NUMBER;
                } else {
                    LineWidthPanel.this.m_dt.m_lineWidthTagTop = selected;
                    LineWidthPanel.this.m_dt.m_lineWidthModeTop = DensiTree.LineWidthMode.BY_METADATA_TAG;
                }
                LineWidthPanel.this.m_dt.m_bCorrectTopOfBranch = selected.equals(LineWidthPanel.MAKE_FIT_BOTTOM);
                LineWidthPanel.this.m_dt.resetStyle();
                if (LineWidthPanel.this.m_dt.m_lineWidthModeTop != oldMode || LineWidthPanel.this.m_dt.m_lineWidthTag != null && !LineWidthPanel.this.m_dt.m_lineWidthTagTop.equals(oldTag) || oldCorrectTopOfBranch != LineWidthPanel.this.m_dt.m_bCorrectTopOfBranch) {
                    LineWidthPanel.this.m_dt.calcLineWidths(true);
                    LineWidthPanel.this.m_dt.makeDirty();
                }
                LineWidthPanel.this.updateEnabled();
                LineWidthPanel.this.repaint();
            }
        }));
        this.textField = new JTextField(this.m_dt.m_sLineWidthPatternTop);
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.fill = 2;
        gbc_textField.gridwidth = 2;
        gbc_textField.insets = new Insets(0, 0, 5, 0);
        gbc_textField.gridx = 0;
        gbc_textField.gridy = 7;
        this.add((Component)this.textField, gbc_textField);
        this.textField.addActionListener(ea -> {
            try {
                this.m_dt.m_sLineWidthPatternTop = this.textField.getText();
                this.m_dt.calcLineWidths(true);
                this.m_dt.makeDirty();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.textField.setColumns(10);
        JLabel lblNumberOfItem = new JLabel("bottom");
        GridBagConstraints gbc_lblNumberOfItem = new GridBagConstraints();
        gbc_lblNumberOfItem.anchor = 13;
        gbc_lblNumberOfItem.insets = new Insets(0, 0, 5, 5);
        gbc_lblNumberOfItem.gridx = 0;
        gbc_lblNumberOfItem.gridy = 8;
        this.add((Component)lblNumberOfItem, gbc_lblNumberOfItem);
        this.spinner_1 = new JSpinner(this.topOfBranchModel);
        GridBagConstraints gbc_spinner_1 = new GridBagConstraints();
        gbc_spinner_1.insets = new Insets(0, 0, 5, 0);
        gbc_spinner_1.gridx = 1;
        gbc_spinner_1.gridy = 8;
        this.add((Component)this.spinner_1, gbc_spinner_1);
        this.spinner_1.setToolTipText("when 0, top will be egual to bottom");
        this.spinner_1.setMaximumSize(new Dimension(1, 20));
        this.chckbxZeroBased = new JCheckBox("Zero based");
        this.chckbxZeroBased.setSelected(this.m_dt.m_bWidthsAreZeroBased);
        this.chckbxZeroBased.addActionListener(ea -> {
            boolean bPrev = this.m_dt.m_bCorrectTopOfBranch;
            this.m_dt.m_bWidthsAreZeroBased = ((JCheckBox)ea.getSource()).isSelected();
            if (bPrev != this.m_dt.m_bWidthsAreZeroBased) {
                this.m_dt.calcLineWidths(true);
                this.m_dt.makeDirty();
            }
        });
        this.separator = new JSeparator();
        GridBagConstraints gbc_separator = new GridBagConstraints();
        gbc_separator.insets = new Insets(0, 0, 5, 5);
        gbc_separator.gridx = 0;
        gbc_separator.gridy = 9;
        this.add((Component)this.separator, gbc_separator);
        GridBagConstraints gbc_chckbxZeroBased = new GridBagConstraints();
        gbc_chckbxZeroBased.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxZeroBased.gridwidth = 2;
        gbc_chckbxZeroBased.anchor = 17;
        gbc_chckbxZeroBased.gridx = 0;
        gbc_chckbxZeroBased.gridy = 10;
        this.add((Component)this.chckbxZeroBased, gbc_chckbxZeroBased);
        GridBagConstraints gbc_lblMetaDataScale = new GridBagConstraints();
        gbc_lblMetaDataScale.anchor = 13;
        gbc_lblMetaDataScale.insets = new Insets(0, 0, 0, 5);
        gbc_lblMetaDataScale.gridx = 0;
        gbc_lblMetaDataScale.gridy = 11;
        JLabel lblMetaDataScale = new JLabel("Scale");
        this.add((Component)lblMetaDataScale, gbc_lblMetaDataScale);
        GridBagConstraints gbc_textField_3 = new GridBagConstraints();
        gbc_textField_3.fill = 2;
        gbc_textField_3.gridwidth = 1;
        gbc_textField_3.gridx = 1;
        gbc_textField_3.gridy = 11;
        this.textField_3 = new JTextField(String.valueOf(this.m_dt.m_treeDrawer.LINE_WIDTH_SCALE));
        this.add((Component)this.textField_3, gbc_textField_3);
        this.textField_3.setColumns(3);
        this.textField_3.addActionListener(ea -> {
            try {
                this.m_dt.m_treeDrawer.LINE_WIDTH_SCALE = Float.parseFloat(this.textField_3.getText());
                if (this.m_dt.m_lineWidthMode != DensiTree.LineWidthMode.DEFAULT) {
                    this.m_dt.makeDirty();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.updateEnabled();
        this.textField.setToolTipText(Util.formatToolTipAsHtml(HELP_PATTERN));
        this.textField_1.setToolTipText(Util.formatToolTipAsHtml(HELP_PATTERN));
        this.textField_3.setToolTipText(Util.formatToolTipAsHtml(HELP_SCALE));
        this.spinner.setToolTipText(Util.formatToolTipAsHtml("Specifies N-th meta data attribute for top of branch when BY_META_DATA_NUMBER is seleced."));
        this.spinner_1.setToolTipText(Util.formatToolTipAsHtml("Specifies N-th meta data attribute for top of branch when BY_META_DATA_NUMBER is seleced."));
        lblNumberOfItem_1.setToolTipText(Util.formatToolTipAsHtml("Specifies N-th meta data attribute for top of branch when BY_META_DATA_NUMBER is seleced."));
        lblNumberOfItem.setToolTipText(Util.formatToolTipAsHtml("Specifies N-th meta data attribute for top of branch when BY_META_DATA_NUMBER is seleced."));
        this.comboBoxBottom.setToolTipText(Util.formatToolTipAsHtml(HELP_LINE_WIDTH));
        this.comboBoxTop.setToolTipText(Util.formatToolTipAsHtml(HELP_LINE_WIDTH_BOTTOM));
        this.chckbxZeroBased.setToolTipText(Util.formatToolTipAsHtml(HELP_ZERO_BASED));
    }

    private void updateEnabled() {
        if (this.textField_1 == null) {
            return;
        }
        this.textField_3.setEnabled(this.m_dt.m_lineWidthMode != DensiTree.LineWidthMode.DEFAULT);
        this.chckbxZeroBased.setEnabled(this.m_dt.m_lineWidthMode != DensiTree.LineWidthMode.DEFAULT);
        this.textField_1.setEnabled(this.m_dt.m_lineWidthMode == DensiTree.LineWidthMode.BY_METADATA_PATTERN);
        this.spinner.setEnabled(this.m_dt.m_lineWidthMode == DensiTree.LineWidthMode.BY_METADATA_NUMBER);
        this.textField.setEnabled(false);
        this.spinner_1.setEnabled(false);
        if (this.m_dt.m_lineWidthMode == DensiTree.LineWidthMode.DEFAULT) {
            this.comboBoxTop.setEnabled(false);
        } else {
            this.comboBoxTop.setEnabled(true);
            if (this.m_dt.m_lineWidthModeTop == DensiTree.LineWidthMode.BY_METADATA_PATTERN) {
                this.textField.setEnabled(true);
            }
            if (this.m_dt.m_lineWidthModeTop == DensiTree.LineWidthMode.BY_METADATA_NUMBER) {
                this.spinner_1.setEnabled(true);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ArrayList<String> selection = new ArrayList<String>();
        ArrayList<String> selectionTop = new ArrayList<String>();
        selection.add(DensiTree.LineWidthMode.DEFAULT.toString());
        selectionTop.add(SAME_AS_BOTTOM);
        selectionTop.add(MAKE_FIT_BOTTOM);
        if (this.m_dt.m_bMetaDataReady) {
            selection.add(DensiTree.LineWidthMode.BY_METADATA_PATTERN.toString());
            selectionTop.add(DensiTree.LineWidthMode.BY_METADATA_PATTERN.toString());
            selection.add(DensiTree.LineWidthMode.BY_METADATA_NUMBER.toString());
            selectionTop.add(DensiTree.LineWidthMode.BY_METADATA_NUMBER.toString());
            int i = 0;
            while (i < this.m_dt.m_metaDataTags.size()) {
                if (this.m_dt.m_metaDataTypes.get(i).equals((Object)DensiTree.MetaDataType.NUMERIC)) {
                    selection.add(this.m_dt.m_metaDataTags.get(i));
                    selectionTop.add(this.m_dt.m_metaDataTags.get(i));
                }
                ++i;
            }
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(selection.toArray(new String[0]));
        this.comboBoxBottom.setModel(model);
        model = new DefaultComboBoxModel<String>(selectionTop.toArray(new String[0]));
        this.comboBoxTop.setModel(model);
        if (this.m_dt.m_lineWidthMode == DensiTree.LineWidthMode.DEFAULT) {
            this.comboBoxBottom.setSelectedItem(DensiTree.LineWidthMode.DEFAULT.toString());
        } else if (this.m_dt.m_lineWidthMode == DensiTree.LineWidthMode.BY_METADATA_PATTERN) {
            this.comboBoxBottom.setSelectedItem(DensiTree.LineWidthMode.BY_METADATA_PATTERN.toString());
        } else if (this.m_dt.m_lineWidthMode == DensiTree.LineWidthMode.BY_METADATA_NUMBER) {
            this.comboBoxBottom.setSelectedItem(DensiTree.LineWidthMode.BY_METADATA_NUMBER.toString());
        } else {
            this.comboBoxBottom.setSelectedItem(this.m_dt.m_lineWidthTag);
        }
        if (this.m_dt.m_lineWidthModeTop == DensiTree.LineWidthMode.DEFAULT) {
            if (this.m_dt.m_bCorrectTopOfBranch) {
                this.comboBoxTop.setSelectedItem(MAKE_FIT_BOTTOM);
            } else {
                this.comboBoxTop.setSelectedItem(SAME_AS_BOTTOM);
            }
        } else if (this.m_dt.m_lineWidthModeTop == DensiTree.LineWidthMode.BY_METADATA_PATTERN) {
            this.comboBoxTop.setSelectedItem(DensiTree.LineWidthMode.BY_METADATA_PATTERN.toString());
        } else if (this.m_dt.m_lineWidthModeTop == DensiTree.LineWidthMode.BY_METADATA_NUMBER) {
            this.comboBoxTop.setSelectedItem(DensiTree.LineWidthMode.BY_METADATA_NUMBER.toString());
        } else {
            this.comboBoxTop.setSelectedItem(this.m_dt.m_lineWidthTagTop);
        }
        this.updateEnabled();
    }
}

